/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.row.generator;

import com.teradata.tpcds.Nulls;
import com.teradata.tpcds.Scaling;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.SlowlyChangingDimensionUtils;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.generator.InventoryGeneratorColumn;
import com.teradata.tpcds.random.RandomValueGenerator;
import com.teradata.tpcds.row.InventoryRow;
import com.teradata.tpcds.row.generator.AbstractRowGenerator;
import com.teradata.tpcds.row.generator.RowGenerator;
import com.teradata.tpcds.row.generator.RowGeneratorResult;
import com.teradata.tpcds.type.Date;

public class InventoryRowGenerator
extends AbstractRowGenerator {
    public InventoryRowGenerator() {
        super(Table.INVENTORY);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long nullBitMap = Nulls.createNullBitMap(Table.INVENTORY, this.getRandomNumberStream(InventoryGeneratorColumn.INV_NULLS));
        int index = (int)rowNumber - 1;
        Scaling scaling = session.getScaling();
        long itemCount = scaling.getIdCount(Table.ITEM);
        long invItemSk = (long)index % itemCount + 1L;
        long warehouseCount = scaling.getIdCount(Table.WAREHOUSE);
        long invWarehouseSk = (long)(index /= (int)itemCount) % warehouseCount + 1L;
        long invDateSk = Date.JULIAN_DATE_MINIMUM + (index /= (int)warehouseCount) * 7;
        invItemSk = SlowlyChangingDimensionUtils.matchSurrogateKey(invItemSk, invDateSk, Table.ITEM, scaling);
        int invQuantityOnHand = RandomValueGenerator.generateUniformRandomInt(0, 1000, this.getRandomNumberStream(InventoryGeneratorColumn.INV_QUANTITY_ON_HAND));
        return new RowGeneratorResult(new InventoryRow(nullBitMap, invDateSk, invItemSk, invWarehouseSk, invQuantityOnHand));
    }
}

