/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.metadata.utils.SecondaryCorrelatedTreeIndexOperationsHelper;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.runtime.operators.LSMSecondaryIndexBulkLoadOperatorDescriptor;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.jobgen.impl.ConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.base.SinkRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.connectors.OneToOneConnectorDescriptor;
import org.apache.hyracks.dataflow.std.sort.ExternalSortOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;

public class SecondaryCorrelatedRTreeOperationsHelper
extends SecondaryCorrelatedTreeIndexOperationsHelper {
    protected IPrimitiveValueProviderFactory[] valueProviderFactories;
    protected int numNestedSecondaryKeyFields;
    protected ATypeTag keyType;
    protected int[] primaryKeyFields;
    protected int[] rtreeFields;
    protected boolean isPointMBR;
    protected RecordDescriptor secondaryRecDescForPointMBR = null;

    protected SecondaryCorrelatedRTreeOperationsHelper(Dataset dataset, Index index, MetadataProvider metadataProvider, SourceLocation sourceLoc) throws AlgebricksException {
        super(dataset, index, metadataProvider, sourceLoc);
    }

    @Override
    protected int getNumSecondaryKeys() {
        return this.numNestedSecondaryKeyFields;
    }

    @Override
    protected void setSecondaryRecDescAndComparators() throws AlgebricksException {
        int i;
        Index.ValueIndexDetails indexDetails = (Index.ValueIndexDetails)this.index.getIndexDetails();
        List<List<String>> secondaryKeyFields = indexDetails.getKeyFieldNames();
        int numSecondaryKeys = secondaryKeyFields.size();
        boolean isOverridingKeyFieldTypes = indexDetails.isOverridingKeyFieldTypes();
        if (numSecondaryKeys != 1) {
            throw AsterixException.create((ErrorCode)ErrorCode.INDEX_RTREE_MULTIPLE_FIELDS_NOT_ALLOWED, (SourceLocation)this.sourceLoc, (Serializable[])new Serializable[]{Integer.valueOf(numSecondaryKeys)});
        }
        Pair<IAType, Boolean> spatialTypePair = Index.getNonNullableOpenFieldType(this.index, indexDetails.getKeyFieldTypes().get(0), secondaryKeyFields.get(0), this.itemType);
        IAType spatialType = (IAType)spatialTypePair.first;
        this.anySecondaryKeyIsNullable = (Boolean)spatialTypePair.second;
        this.isPointMBR = spatialType.getTypeTag() == ATypeTag.POINT || spatialType.getTypeTag() == ATypeTag.POINT3D;
        int numDimensions = NonTaggedFormatUtil.getNumDimensions((ATypeTag)spatialType.getTypeTag());
        this.numNestedSecondaryKeyFields = numDimensions * 2;
        int recordColumn = 2 + this.numPrimaryKeys;
        this.secondaryFieldAccessEvalFactories = this.metadataProvider.getDataFormat().createMBRFactory(this.metadataProvider.getFunctionManager(), isOverridingKeyFieldTypes ? this.enforcedItemType : this.itemType, secondaryKeyFields.get(0), recordColumn, numDimensions, this.filterFieldName, this.isPointMBR, this.sourceLoc);
        this.secondaryComparatorFactories = new IBinaryComparatorFactory[this.numNestedSecondaryKeyFields];
        this.valueProviderFactories = new IPrimitiveValueProviderFactory[this.numNestedSecondaryKeyFields];
        ISerializerDeserializer[] secondaryRecFields = new ISerializerDeserializer[this.numPrimaryKeys + this.numNestedSecondaryKeyFields + this.numFilterFields];
        ISerializerDeserializer[] enforcedRecFields = new ISerializerDeserializer[1 + this.numPrimaryKeys + this.numFilterFields];
        this.secondaryTypeTraits = new ITypeTraits[this.numNestedSecondaryKeyFields + this.numPrimaryKeys];
        ITypeTraits[] enforcedTypeTraits = new ITypeTraits[1 + this.numPrimaryKeys];
        IAType nestedKeyType = NonTaggedFormatUtil.getNestedSpatialType((ATypeTag)spatialType.getTypeTag());
        this.keyType = nestedKeyType.getTypeTag();
        for (i = 0; i < this.numNestedSecondaryKeyFields; ++i) {
            ISerializerDeserializer keySerde;
            secondaryRecFields[i] = keySerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)nestedKeyType);
            this.secondaryComparatorFactories[i] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)nestedKeyType, true);
            this.secondaryTypeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)nestedKeyType);
            this.valueProviderFactories[i] = this.metadataProvider.getStorageComponentProvider().getPrimitiveValueProviderFactory();
        }
        for (i = 0; i < this.numPrimaryKeys; ++i) {
            secondaryRecFields[this.numNestedSecondaryKeyFields + i] = this.primaryRecDesc.getFields()[i];
            this.secondaryTypeTraits[this.numNestedSecondaryKeyFields + i] = this.primaryRecDesc.getTypeTraits()[i];
            enforcedRecFields[i] = this.primaryRecDesc.getFields()[i];
            enforcedTypeTraits[i] = this.primaryRecDesc.getTypeTraits()[i];
        }
        enforcedRecFields[this.numPrimaryKeys] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)this.itemType);
        this.enforcedRecDesc = new RecordDescriptor(enforcedRecFields, enforcedTypeTraits);
        if (this.numFilterFields > 0) {
            ISerializerDeserializer serde;
            ARecordType filterItemType = ((InternalDatasetDetails)this.dataset.getDatasetDetails()).getFilterSourceIndicator() == 0 ? this.itemType : this.metaType;
            this.rtreeFields = new int[this.numNestedSecondaryKeyFields + this.numPrimaryKeys];
            for (int i2 = 0; i2 < this.rtreeFields.length; ++i2) {
                this.rtreeFields[i2] = i2;
            }
            Pair<IAType, Boolean> typePair = Index.getNonNullableKeyFieldType(this.filterFieldName, filterItemType);
            IAType type = (IAType)typePair.first;
            secondaryRecFields[this.numPrimaryKeys + this.numNestedSecondaryKeyFields] = serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)type);
        }
        this.secondaryRecDesc = new RecordDescriptor(secondaryRecFields);
        this.primaryKeyFields = new int[this.numPrimaryKeys];
        for (int i3 = 0; i3 < this.primaryKeyFields.length; ++i3) {
            this.primaryKeyFields[i3] = i3 + this.numNestedSecondaryKeyFields;
        }
        if (this.isPointMBR) {
            int i4;
            int numNestedSecondaryKeyFieldForPointMBR = this.numNestedSecondaryKeyFields / 2;
            ISerializerDeserializer[] recFieldsForPointMBR = new ISerializerDeserializer[this.numPrimaryKeys + numNestedSecondaryKeyFieldForPointMBR + this.numFilterFields];
            int idx = 0;
            for (i4 = 0; i4 < numNestedSecondaryKeyFieldForPointMBR; ++i4) {
                recFieldsForPointMBR[idx++] = secondaryRecFields[i4];
            }
            for (i4 = 0; i4 < this.numPrimaryKeys + this.numFilterFields; ++i4) {
                recFieldsForPointMBR[idx++] = secondaryRecFields[this.numNestedSecondaryKeyFields + i4];
            }
            this.secondaryRecDescForPointMBR = new RecordDescriptor(recFieldsForPointMBR);
        }
    }

    @Override
    public JobSpecification buildLoadingJobSpec() throws AlgebricksException {
        IOperatorDescriptor primaryScanOp;
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)this.metadataProvider.getApplicationContext());
        int numNestedSecondaryKeFieldsConsideringPointMBR = this.isPointMBR ? this.numNestedSecondaryKeyFields / 2 : this.numNestedSecondaryKeyFields;
        RecordDescriptor secondaryRecDescConsideringPointMBR = this.isPointMBR ? this.getTaggedRecordDescriptor(this.secondaryRecDescForPointMBR) : this.getTaggedRecordDescriptor(this.secondaryRecDesc);
        boolean isOverridingKeyFieldTypes = this.index.getIndexDetails().isOverridingKeyFieldTypes();
        assert (this.dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL);
        IOperatorDescriptor keyProviderOp = DatasetUtil.createDummyKeyProviderOp(spec, this.dataset, this.metadataProvider);
        IndexUtil.bindJobEventListener(spec, this.metadataProvider);
        IOperatorDescriptor sourceOp = primaryScanOp = this.createPrimaryIndexScanDiskComponentsOp(spec, this.metadataProvider, this.getTaggedRecordDescriptor(this.dataset.getPrimaryRecordDescriptor(this.metadataProvider)));
        if (isOverridingKeyFieldTypes && !this.enforcedItemType.equals((Object)this.itemType)) {
            sourceOp = this.createCastOp(spec, this.dataset.getDatasetType(), this.index.isEnforced());
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), primaryScanOp, 0, sourceOp, 0);
        }
        AlgebricksMetaOperatorDescriptor asterixAssignOp = this.createAssignOp(spec, numNestedSecondaryKeFieldsConsideringPointMBR, secondaryRecDescConsideringPointMBR);
        IOperatorDescriptor processorOp = this.createTupleProcessorOp(spec, secondaryRecDescConsideringPointMBR, numNestedSecondaryKeFieldsConsideringPointMBR, this.numPrimaryKeys, false, true, true);
        ExternalSortOperatorDescriptor sortOp = this.createSortOp(spec, this.getTaggedSecondaryComparatorFactories(new IBinaryComparatorFactory[]{MetadataProvider.proposeLinearizer(this.keyType, this.secondaryComparatorFactories.length)}), secondaryRecDescConsideringPointMBR);
        LSMSecondaryIndexBulkLoadOperatorDescriptor secondaryBulkLoadOp = this.createTreeIndexBulkLoadOp(spec, this.metadataProvider, secondaryRecDescConsideringPointMBR, this.createFieldPermutationForBulkLoadOp(), numNestedSecondaryKeFieldsConsideringPointMBR, this.numPrimaryKeys, false);
        SinkRuntimeFactory sinkRuntimeFactory = new SinkRuntimeFactory();
        sinkRuntimeFactory.setSourceLocation(this.sourceLoc);
        AlgebricksMetaOperatorDescriptor metaOp = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 0, new IPushRuntimeFactory[]{sinkRuntimeFactory}, new RecordDescriptor[0]);
        metaOp.setSourceLocation(this.sourceLoc);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), keyProviderOp, 0, primaryScanOp, 0);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, (IOperatorDescriptor)asterixAssignOp, 0);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)asterixAssignOp, 0, processorOp, 0);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), processorOp, 0, (IOperatorDescriptor)sortOp, 0);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)sortOp, 0, (IOperatorDescriptor)secondaryBulkLoadOp, 0);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)secondaryBulkLoadOp, 0, (IOperatorDescriptor)metaOp, 0);
        spec.addRoot((IOperatorDescriptor)metaOp);
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }

    @Override
    protected int[] createFieldPermutationForBulkLoadOp() {
        if (this.isPointMBR) {
            int[] fieldPermutation = new int[2 + this.numNestedSecondaryKeyFields + this.numPrimaryKeys + this.numFilterFields];
            int idx = 0;
            int numSecondaryKeyFieldsForPointMBR = this.numNestedSecondaryKeyFields / 2;
            int i = 0;
            while (i < 2 + numSecondaryKeyFieldsForPointMBR) {
                fieldPermutation[idx++] = i++;
            }
            for (i = 0; i < numSecondaryKeyFieldsForPointMBR; ++i) {
                fieldPermutation[idx++] = 2 + i;
            }
            int end = numSecondaryKeyFieldsForPointMBR + this.numPrimaryKeys + this.numFilterFields;
            for (int i2 = numSecondaryKeyFieldsForPointMBR; i2 < end; ++i2) {
                fieldPermutation[idx++] = 2 + i2;
            }
            return fieldPermutation;
        }
        return super.createFieldPermutationForBulkLoadOp();
    }
}

