/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DatasetFullyQualifiedName;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.expression.ListSliceExpression;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.ViewDecl;
import org.apache.asterix.lang.common.visitor.AbstractInlineUdfsVisitor;
import org.apache.asterix.lang.common.visitor.CloneAndSubstituteVariablesVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.visitor.SqlppCloneAndSubstituteVariablesVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class SqlppInlineUdfsVisitor
extends AbstractInlineUdfsVisitor
implements ISqlppVisitor<Boolean, Void> {
    public SqlppInlineUdfsVisitor(LangRewritingContext context, Map<FunctionSignature, FunctionDecl> usedUDFs, Map<DatasetFullyQualifiedName, ViewDecl> usedViews) {
        super(context, usedUDFs, usedViews, (CloneAndSubstituteVariablesVisitor)new SqlppCloneAndSubstituteVariablesVisitor(context));
    }

    protected Expression generateQueryExpression(List<LetClause> letClauses, Expression returnExpr) throws CompilationException {
        Map<Expression, Expression> varExprMap = this.extractLetBindingVariableExpressionMappings(letClauses);
        return SqlppRewriteUtil.substituteExpression(returnExpr, varExprMap, this.context);
    }

    @Override
    public Boolean visit(FromClause fromClause, Void arg) throws CompilationException {
        boolean changed = false;
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            changed |= fromTerm.accept(this, arg).booleanValue();
        }
        return changed;
    }

    @Override
    public Boolean visit(FromTerm fromTerm, Void arg) throws CompilationException {
        boolean changed = false;
        Pair p = this.inlineUdfsAndViewsInExpr(fromTerm.getLeftExpression());
        fromTerm.setLeftExpression((Expression)p.second);
        changed |= ((Boolean)p.first).booleanValue();
        for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
            changed |= ((Boolean)correlateClause.accept(this, arg)).booleanValue();
        }
        return changed;
    }

    @Override
    public Boolean visit(JoinClause joinClause, Void arg) throws CompilationException {
        Pair p1 = this.inlineUdfsAndViewsInExpr(joinClause.getRightExpression());
        joinClause.setRightExpression((Expression)p1.second);
        Pair p2 = this.inlineUdfsAndViewsInExpr(joinClause.getConditionExpression());
        joinClause.setConditionExpression((Expression)p2.second);
        return (Boolean)p1.first != false || (Boolean)p2.first != false;
    }

    @Override
    public Boolean visit(NestClause nestClause, Void arg) throws CompilationException {
        Pair p1 = this.inlineUdfsAndViewsInExpr(nestClause.getRightExpression());
        nestClause.setRightExpression((Expression)p1.second);
        Pair p2 = this.inlineUdfsAndViewsInExpr(nestClause.getConditionExpression());
        nestClause.setConditionExpression((Expression)p2.second);
        return (Boolean)p1.first != false || (Boolean)p2.first != false;
    }

    @Override
    public Boolean visit(Projection projection, Void arg) throws CompilationException {
        if (!projection.hasExpression()) {
            return false;
        }
        Pair p = this.inlineUdfsAndViewsInExpr(projection.getExpression());
        projection.setExpression((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(SelectBlock selectBlock, Void arg) throws CompilationException {
        boolean changed = false;
        if (selectBlock.hasFromClause()) {
            changed |= selectBlock.getFromClause().accept(this, arg).booleanValue();
        }
        if (selectBlock.hasLetWhereClauses()) {
            for (AbstractClause letWhereClause : selectBlock.getLetWhereList()) {
                changed |= ((Boolean)letWhereClause.accept((ILangVisitor)this, (Object)arg)).booleanValue();
            }
        }
        if (selectBlock.hasGroupbyClause()) {
            changed |= ((Boolean)selectBlock.getGroupbyClause().accept((ILangVisitor)this, (Object)arg)).booleanValue();
        }
        if (selectBlock.hasLetHavingClausesAfterGroupby()) {
            for (AbstractClause letHavingClause : selectBlock.getLetHavingListAfterGroupby()) {
                changed |= ((Boolean)letHavingClause.accept((ILangVisitor)this, (Object)arg)).booleanValue();
            }
        }
        return changed |= selectBlock.getSelectClause().accept(this, arg).booleanValue();
    }

    @Override
    public Boolean visit(SelectClause selectClause, Void arg) throws CompilationException {
        boolean changed = false;
        changed = selectClause.selectElement() ? (changed |= selectClause.getSelectElement().accept(this, arg).booleanValue()) : (changed |= selectClause.getSelectRegular().accept(this, arg).booleanValue());
        return changed;
    }

    @Override
    public Boolean visit(SelectElement selectElement, Void arg) throws CompilationException {
        Pair p = this.inlineUdfsAndViewsInExpr(selectElement.getExpression());
        selectElement.setExpression((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(SelectRegular selectRegular, Void arg) throws CompilationException {
        boolean changed = false;
        for (Projection projection : selectRegular.getProjections()) {
            changed |= projection.accept(this, arg).booleanValue();
        }
        return changed;
    }

    @Override
    public Boolean visit(SelectSetOperation selectSetOperation, Void arg) throws CompilationException {
        boolean changed = false;
        changed |= selectSetOperation.getLeftInput().accept(this, arg).booleanValue();
        for (SetOperationRight right : selectSetOperation.getRightInputs()) {
            changed |= right.getSetOperationRightInput().accept(this, arg).booleanValue();
        }
        return changed;
    }

    @Override
    public Boolean visit(SelectExpression selectExpression, Void arg) throws CompilationException {
        boolean changed = false;
        if (selectExpression.hasLetClauses()) {
            for (LetClause letClause : selectExpression.getLetList()) {
                changed |= ((Boolean)letClause.accept((ILangVisitor)this, (Object)arg)).booleanValue();
            }
        }
        changed |= selectExpression.getSelectSetOperation().accept(this, arg).booleanValue();
        if (selectExpression.hasOrderby()) {
            changed |= ((Boolean)selectExpression.getOrderbyClause().accept((ILangVisitor)this, (Object)arg)).booleanValue();
        }
        if (selectExpression.hasLimit()) {
            changed |= ((Boolean)selectExpression.getLimitClause().accept((ILangVisitor)this, (Object)arg)).booleanValue();
        }
        return changed;
    }

    @Override
    public Boolean visit(UnnestClause unnestClause, Void arg) throws CompilationException {
        Pair p = this.inlineUdfsAndViewsInExpr(unnestClause.getRightExpression());
        unnestClause.setRightExpression((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(HavingClause havingClause, Void arg) throws CompilationException {
        Pair p = this.inlineUdfsAndViewsInExpr(havingClause.getFilterExpression());
        havingClause.setFilterExpression((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(CaseExpression caseExpr, Void arg) throws CompilationException {
        Pair result = this.inlineUdfsAndViewsInExpr(caseExpr.getConditionExpr());
        caseExpr.setConditionExpr((Expression)result.second);
        boolean inlined = (Boolean)result.first;
        Pair inlinedList = this.inlineUdfsInExprList(caseExpr.getWhenExprs());
        inlined = inlined || (Boolean)inlinedList.first != false;
        caseExpr.setWhenExprs((List)inlinedList.second);
        inlinedList = this.inlineUdfsInExprList(caseExpr.getThenExprs());
        inlined = inlined || (Boolean)inlinedList.first != false;
        caseExpr.setThenExprs((List)inlinedList.second);
        result = this.inlineUdfsAndViewsInExpr(caseExpr.getElseExpr());
        caseExpr.setElseExpr((Expression)result.second);
        return inlined || (Boolean)result.first != false;
    }

    @Override
    public Boolean visit(WindowExpression winExpr, Void arg) throws CompilationException {
        Pair inlinedExpr;
        Pair inlinedList;
        boolean inlined = false;
        if (winExpr.hasPartitionList()) {
            inlinedList = this.inlineUdfsInExprList(winExpr.getPartitionList());
            winExpr.setPartitionList((List)inlinedList.second);
            inlined = (Boolean)inlinedList.first;
        }
        if (winExpr.hasOrderByList()) {
            inlinedList = this.inlineUdfsInExprList(winExpr.getOrderbyList());
            winExpr.setOrderbyList((List)inlinedList.second);
            inlined |= ((Boolean)inlinedList.first).booleanValue();
        }
        if (winExpr.hasFrameStartExpr()) {
            inlinedExpr = this.inlineUdfsAndViewsInExpr(winExpr.getFrameStartExpr());
            winExpr.setFrameStartExpr((Expression)inlinedExpr.second);
            inlined |= ((Boolean)inlinedExpr.first).booleanValue();
        }
        if (winExpr.hasFrameEndExpr()) {
            inlinedExpr = this.inlineUdfsAndViewsInExpr(winExpr.getFrameEndExpr());
            winExpr.setFrameEndExpr((Expression)inlinedExpr.second);
            inlined |= ((Boolean)inlinedExpr.first).booleanValue();
        }
        if (winExpr.hasWindowFieldList()) {
            inlinedList = this.inlineUdfsInFieldList(winExpr.getWindowFieldList());
            winExpr.setWindowFieldList((List)inlinedList.second);
            inlined |= ((Boolean)inlinedList.first).booleanValue();
        }
        if (winExpr.hasAggregateFilterExpr()) {
            inlinedExpr = this.inlineUdfsAndViewsInExpr(winExpr.getAggregateFilterExpr());
            winExpr.setAggregateFilterExpr((Expression)inlinedExpr.second);
            inlined |= ((Boolean)inlinedExpr.first).booleanValue();
        }
        inlinedList = this.inlineUdfsInExprList(winExpr.getExprList());
        winExpr.setExprList((List)inlinedList.second);
        return inlined |= ((Boolean)inlinedList.first).booleanValue();
    }

    public Boolean visit(ListSliceExpression expression, Void arg) throws CompilationException {
        Pair expressionResult = this.inlineUdfsAndViewsInExpr(expression.getExpr());
        expression.setExpr((Expression)expressionResult.second);
        boolean inlined = (Boolean)expressionResult.first;
        Pair startIndexExpressResult = this.inlineUdfsAndViewsInExpr(expression.getStartIndexExpression());
        expression.setStartIndexExpression((Expression)startIndexExpressResult.second);
        inlined |= ((Boolean)startIndexExpressResult.first).booleanValue();
        if (expression.hasEndExpression()) {
            Pair endIndexExpressionResult = this.inlineUdfsAndViewsInExpr(expression.getEndIndexExpression());
            expression.setEndIndexExpression((Expression)endIndexExpressionResult.second);
            inlined |= ((Boolean)endIndexExpressionResult.first).booleanValue();
        }
        return inlined;
    }

    private Map<Expression, Expression> extractLetBindingVariableExpressionMappings(List<LetClause> letClauses) throws CompilationException {
        HashMap<Expression, Expression> varExprMap = new HashMap<Expression, Expression>();
        for (LetClause lc : letClauses) {
            lc.setBindingExpr(SqlppRewriteUtil.substituteExpression(lc.getBindingExpr(), varExprMap, this.context));
            varExprMap.put((Expression)lc.getVarExpr(), lc.getBindingExpr());
        }
        return varExprMap;
    }
}

