/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.rewrites.VariableSubstitutionEnvironment;
import org.apache.asterix.lang.common.util.VariableCloneAndSubstitutionUtil;
import org.apache.asterix.lang.common.visitor.CloneAndSubstituteVariablesVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class SqlppCloneAndSubstituteVariablesVisitor
extends CloneAndSubstituteVariablesVisitor
implements ISqlppVisitor<Pair<ILangExpression, VariableSubstitutionEnvironment>, VariableSubstitutionEnvironment> {
    private LangRewritingContext context;

    public SqlppCloneAndSubstituteVariablesVisitor(LangRewritingContext context) {
        super(context);
        this.context = context;
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(FromClause fromClause, VariableSubstitutionEnvironment env) throws CompilationException {
        VariableSubstitutionEnvironment currentEnv = new VariableSubstitutionEnvironment(env);
        ArrayList<FromTerm> newFromTerms = new ArrayList<FromTerm>();
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            Pair<ILangExpression, VariableSubstitutionEnvironment> p = fromTerm.accept(this, currentEnv);
            newFromTerms.add((FromTerm)((Object)p.first));
            currentEnv = (VariableSubstitutionEnvironment)p.second;
        }
        FromClause newFromClause = new FromClause(newFromTerms);
        newFromClause.setSourceLocation(fromClause.getSourceLocation());
        return new Pair((Object)newFromClause, (Object)currentEnv);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(FromTerm fromTerm, VariableSubstitutionEnvironment env) throws CompilationException {
        VariableExpr leftVar = fromTerm.getLeftVariable();
        VariableExpr newLeftVar = this.generateNewVariable(this.context, leftVar);
        VariableExpr newLeftPosVar = fromTerm.hasPositionalVariable() ? this.generateNewVariable(this.context, fromTerm.getPositionalVariable()) : null;
        Expression newLeftExpr = (Expression)this.visitUnnestBindingExpression((Expression)fromTerm.getLeftExpression(), (VariableSubstitutionEnvironment)env).first;
        ArrayList<AbstractBinaryCorrelateClause> newCorrelateClauses = new ArrayList<AbstractBinaryCorrelateClause>();
        VariableSubstitutionEnvironment currentEnv = new VariableSubstitutionEnvironment(env);
        currentEnv.removeSubstitution(newLeftVar);
        if (newLeftPosVar != null) {
            currentEnv.removeSubstitution(newLeftPosVar);
        }
        for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
            if (correlateClause.getClauseType() == Clause.ClauseType.UNNEST_CLAUSE) {
                Pair p = (Pair)correlateClause.accept(this, currentEnv);
                currentEnv = (VariableSubstitutionEnvironment)p.second;
                newCorrelateClauses.add((AbstractBinaryCorrelateClause)((Object)p.first));
                continue;
            }
            newCorrelateClauses.add((AbstractBinaryCorrelateClause)((Object)((Pair)correlateClause.accept((ILangVisitor)this, (Object)env)).first));
            currentEnv.removeSubstitution(correlateClause.getRightVariable());
            if (!correlateClause.hasPositionalVariable()) continue;
            currentEnv.removeSubstitution(correlateClause.getPositionalVariable());
        }
        FromTerm newFromTerm = new FromTerm(newLeftExpr, newLeftVar, newLeftPosVar, newCorrelateClauses);
        newFromTerm.setSourceLocation(fromTerm.getSourceLocation());
        return new Pair((Object)newFromTerm, (Object)currentEnv);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(JoinClause joinClause, VariableSubstitutionEnvironment env) throws CompilationException {
        VariableExpr rightVar = joinClause.getRightVariable();
        VariableExpr newRightVar = this.generateNewVariable(this.context, rightVar);
        VariableExpr newRightPosVar = joinClause.hasPositionalVariable() ? this.generateNewVariable(this.context, joinClause.getPositionalVariable()) : null;
        Expression newRightExpr = (Expression)this.visitUnnestBindingExpression((Expression)joinClause.getRightExpression(), (VariableSubstitutionEnvironment)env).first;
        VariableSubstitutionEnvironment currentEnv = new VariableSubstitutionEnvironment(env);
        currentEnv.removeSubstitution(newRightVar);
        if (newRightPosVar != null) {
            currentEnv.removeSubstitution(newRightPosVar);
        }
        Expression conditionExpr = (Expression)((Pair)joinClause.getConditionExpression().accept((ILangVisitor)this, (Object)currentEnv)).first;
        JoinClause newJoinClause = new JoinClause(joinClause.getJoinType(), newRightExpr, newRightVar, newRightPosVar, conditionExpr, joinClause.getOuterJoinMissingValueType());
        newJoinClause.setSourceLocation(joinClause.getSourceLocation());
        return new Pair((Object)newJoinClause, (Object)currentEnv);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(NestClause nestClause, VariableSubstitutionEnvironment env) throws CompilationException {
        VariableExpr rightVar = nestClause.getRightVariable();
        VariableExpr newRightVar = this.generateNewVariable(this.context, rightVar);
        VariableExpr newRightPosVar = nestClause.hasPositionalVariable() ? this.generateNewVariable(this.context, nestClause.getPositionalVariable()) : null;
        Expression rightExpr = (Expression)((Pair)nestClause.getRightExpression().accept((ILangVisitor)this, (Object)env)).first;
        VariableSubstitutionEnvironment currentEnv = new VariableSubstitutionEnvironment(env);
        currentEnv.removeSubstitution(newRightVar);
        if (newRightPosVar != null) {
            currentEnv.removeSubstitution(newRightPosVar);
        }
        Expression conditionExpr = (Expression)((Pair)nestClause.getConditionExpression().accept((ILangVisitor)this, (Object)currentEnv)).first;
        NestClause newNestClause = new NestClause(nestClause.getNestType(), rightExpr, newRightVar, newRightPosVar, conditionExpr);
        newNestClause.setSourceLocation(nestClause.getSourceLocation());
        return new Pair((Object)newNestClause, (Object)currentEnv);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(UnnestClause unnestClause, VariableSubstitutionEnvironment env) throws CompilationException {
        VariableExpr rightVar = unnestClause.getRightVariable();
        VariableExpr newRightVar = this.generateNewVariable(this.context, rightVar);
        VariableExpr newRightPosVar = unnestClause.hasPositionalVariable() ? this.generateNewVariable(this.context, unnestClause.getPositionalVariable()) : null;
        Expression rightExpr = (Expression)this.visitUnnestBindingExpression((Expression)unnestClause.getRightExpression(), (VariableSubstitutionEnvironment)env).first;
        VariableSubstitutionEnvironment currentEnv = new VariableSubstitutionEnvironment(env);
        currentEnv.removeSubstitution(newRightVar);
        if (newRightPosVar != null) {
            currentEnv.removeSubstitution(newRightPosVar);
        }
        UnnestClause newUnnestClause = new UnnestClause(unnestClause.getUnnestType(), rightExpr, newRightVar, newRightPosVar, unnestClause.getOuterUnnestMissingValueType());
        newUnnestClause.setSourceLocation(unnestClause.getSourceLocation());
        return new Pair((Object)newUnnestClause, (Object)currentEnv);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(Projection projection, VariableSubstitutionEnvironment env) throws CompilationException {
        Projection newProjection = new Projection(projection.getKind(), projection.hasExpression() ? (Expression)((Pair)projection.getExpression().accept((ILangVisitor)this, (Object)env)).first : null, projection.getName());
        newProjection.setSourceLocation(projection.getSourceLocation());
        return new Pair((Object)newProjection, (Object)env);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(SelectBlock selectBlock, VariableSubstitutionEnvironment env) throws CompilationException {
        Pair<ILangExpression, VariableSubstitutionEnvironment> newFrom = null;
        Pair newGroupby = null;
        ArrayList<AbstractClause> newLetWhereClauses = new ArrayList<AbstractClause>();
        ArrayList<AbstractClause> newLetHavingClausesAfterGby = new ArrayList<AbstractClause>();
        VariableSubstitutionEnvironment currentEnv = new VariableSubstitutionEnvironment(env);
        if (selectBlock.hasFromClause()) {
            newFrom = selectBlock.getFromClause().accept(this, currentEnv);
            currentEnv = (VariableSubstitutionEnvironment)newFrom.second;
        }
        if (selectBlock.hasLetWhereClauses()) {
            for (AbstractClause letWhereClause : selectBlock.getLetWhereList()) {
                Pair newLetWhere = (Pair)letWhereClause.accept((ILangVisitor)this, (Object)currentEnv);
                currentEnv = (VariableSubstitutionEnvironment)newLetWhere.second;
                newLetWhereClauses.add((AbstractClause)newLetWhere.first);
            }
        }
        if (selectBlock.hasGroupbyClause()) {
            newGroupby = (Pair)selectBlock.getGroupbyClause().accept((ILangVisitor)this, (Object)currentEnv);
            currentEnv = (VariableSubstitutionEnvironment)newGroupby.second;
            if (selectBlock.hasLetHavingClausesAfterGroupby()) {
                for (AbstractClause letHavingClauseAfterGby : selectBlock.getLetHavingListAfterGroupby()) {
                    Pair newLetHaving = (Pair)letHavingClauseAfterGby.accept((ILangVisitor)this, (Object)currentEnv);
                    currentEnv = (VariableSubstitutionEnvironment)newLetHaving.second;
                    newLetHavingClausesAfterGby.add((AbstractClause)newLetHaving.first);
                }
            }
        }
        Pair<ILangExpression, VariableSubstitutionEnvironment> newSelect = selectBlock.getSelectClause().accept(this, currentEnv);
        currentEnv = (VariableSubstitutionEnvironment)newSelect.second;
        FromClause fromClause = newFrom == null ? null : (FromClause)((Object)newFrom.first);
        GroupbyClause groupbyClause = newGroupby == null ? null : (GroupbyClause)newGroupby.first;
        SelectBlock newSelectBlock = new SelectBlock((SelectClause)((Object)newSelect.first), fromClause, newLetWhereClauses, groupbyClause, newLetHavingClausesAfterGby);
        newSelectBlock.setSourceLocation(selectBlock.getSourceLocation());
        return new Pair((Object)newSelectBlock, (Object)currentEnv);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(SelectClause selectClause, VariableSubstitutionEnvironment env) throws CompilationException {
        boolean distinct = selectClause.distinct();
        if (selectClause.selectElement()) {
            Pair<ILangExpression, VariableSubstitutionEnvironment> newSelectElement = selectClause.getSelectElement().accept(this, env);
            SelectClause newSelectClause = new SelectClause((SelectElement)((Object)newSelectElement.first), null, distinct);
            newSelectClause.setSourceLocation(selectClause.getSourceLocation());
            return new Pair((Object)newSelectClause, (Object)((VariableSubstitutionEnvironment)newSelectElement.second));
        }
        Pair<ILangExpression, VariableSubstitutionEnvironment> newSelectRegular = selectClause.getSelectRegular().accept(this, env);
        SelectClause newSelectClause = new SelectClause(null, (SelectRegular)((Object)newSelectRegular.first), distinct);
        newSelectClause.setSourceLocation(selectClause.getSourceLocation());
        return new Pair((Object)newSelectClause, (Object)((VariableSubstitutionEnvironment)newSelectRegular.second));
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(SelectElement selectElement, VariableSubstitutionEnvironment env) throws CompilationException {
        Pair newExpr = (Pair)selectElement.getExpression().accept((ILangVisitor)this, (Object)env);
        SelectElement newSelectElement = new SelectElement((Expression)newExpr.first);
        newSelectElement.setSourceLocation(selectElement.getSourceLocation());
        return new Pair((Object)newSelectElement, (Object)((VariableSubstitutionEnvironment)newExpr.second));
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(SelectRegular selectRegular, VariableSubstitutionEnvironment env) throws CompilationException {
        ArrayList<Projection> newProjections = new ArrayList<Projection>();
        for (Projection projection : selectRegular.getProjections()) {
            newProjections.add((Projection)((Object)projection.accept(this, env).first));
        }
        SelectRegular newSelectRegular = new SelectRegular(newProjections);
        newSelectRegular.setSourceLocation(selectRegular.getSourceLocation());
        return new Pair((Object)newSelectRegular, (Object)env);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(SelectSetOperation selectSetOperation, VariableSubstitutionEnvironment env) throws CompilationException {
        SetOperationInput newLeftInput;
        Pair<ILangExpression, VariableSubstitutionEnvironment> leftResult;
        SetOperationInput leftInput = selectSetOperation.getLeftInput();
        if (leftInput.selectBlock()) {
            leftResult = leftInput.getSelectBlock().accept(this, env);
            newLeftInput = new SetOperationInput((SelectBlock)((Object)leftResult.first), null);
        } else {
            leftResult = leftInput.getSubquery().accept(this, env);
            newLeftInput = new SetOperationInput(null, (SelectExpression)((Object)leftResult.first));
        }
        ArrayList<SetOperationRight> newRightInputs = new ArrayList<SetOperationRight>();
        if (selectSetOperation.hasRightInputs()) {
            for (SetOperationRight right : selectSetOperation.getRightInputs()) {
                SetOperationInput newRightInput;
                Pair<ILangExpression, VariableSubstitutionEnvironment> rightResult;
                SetOperationInput rightInput = right.getSetOperationRightInput();
                if (rightInput.selectBlock()) {
                    rightResult = rightInput.getSelectBlock().accept(this, env);
                    newRightInput = new SetOperationInput((SelectBlock)((Object)rightResult.first), null);
                } else {
                    rightResult = rightInput.getSubquery().accept(this, env);
                    newRightInput = new SetOperationInput(null, (SelectExpression)((Object)rightResult.first));
                }
                newRightInputs.add(new SetOperationRight(right.getSetOpType(), right.isSetSemantics(), newRightInput));
            }
        }
        SelectSetOperation newSelectSetOperation = new SelectSetOperation(newLeftInput, newRightInputs);
        newSelectSetOperation.setSourceLocation(selectSetOperation.getSourceLocation());
        return new Pair((Object)newSelectSetOperation, (Object)(selectSetOperation.hasRightInputs() ? env : (VariableSubstitutionEnvironment)leftResult.second));
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(SelectExpression selectExpression, VariableSubstitutionEnvironment env) throws CompilationException {
        Pair p;
        boolean subquery = selectExpression.isSubquery();
        ArrayList<LetClause> newLetList = new ArrayList<LetClause>();
        OrderbyClause newOrderbyClause = null;
        LimitClause newLimitClause = null;
        VariableSubstitutionEnvironment currentEnv = env;
        if (selectExpression.hasLetClauses()) {
            for (LetClause letClause : selectExpression.getLetList()) {
                p = (Pair)letClause.accept((ILangVisitor)this, (Object)currentEnv);
                newLetList.add((LetClause)p.first);
                currentEnv = (VariableSubstitutionEnvironment)p.second;
            }
        }
        p = selectExpression.getSelectSetOperation().accept(this, env);
        SelectSetOperation newSelectSetOperation = (SelectSetOperation)((Object)p.first);
        currentEnv = (VariableSubstitutionEnvironment)p.second;
        if (selectExpression.hasOrderby()) {
            p = (Pair)selectExpression.getOrderbyClause().accept((ILangVisitor)this, (Object)currentEnv);
            newOrderbyClause = (OrderbyClause)p.first;
            currentEnv = (VariableSubstitutionEnvironment)p.second;
        }
        if (selectExpression.hasLimit()) {
            p = (Pair)selectExpression.getLimitClause().accept((ILangVisitor)this, (Object)currentEnv);
            newLimitClause = (LimitClause)p.first;
            currentEnv = (VariableSubstitutionEnvironment)p.second;
        }
        SelectExpression newSelectExpression = new SelectExpression(newLetList, newSelectSetOperation, newOrderbyClause, newLimitClause, subquery);
        newSelectExpression.setSourceLocation(selectExpression.getSourceLocation());
        return new Pair((Object)newSelectExpression, (Object)currentEnv);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(HavingClause havingClause, VariableSubstitutionEnvironment env) throws CompilationException {
        Pair p = (Pair)havingClause.getFilterExpression().accept((ILangVisitor)this, (Object)env);
        HavingClause newHavingClause = new HavingClause((Expression)p.first);
        newHavingClause.setSourceLocation(havingClause.getSourceLocation());
        return new Pair((Object)newHavingClause, (Object)((VariableSubstitutionEnvironment)p.second));
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(CaseExpression caseExpr, VariableSubstitutionEnvironment env) throws CompilationException {
        Expression conditionExpr = (Expression)((Pair)caseExpr.getConditionExpr().accept((ILangVisitor)this, (Object)env)).first;
        List whenExprList = VariableCloneAndSubstitutionUtil.visitAndCloneExprList(caseExpr.getWhenExprs(), (VariableSubstitutionEnvironment)env, (CloneAndSubstituteVariablesVisitor)this);
        List thenExprList = VariableCloneAndSubstitutionUtil.visitAndCloneExprList(caseExpr.getThenExprs(), (VariableSubstitutionEnvironment)env, (CloneAndSubstituteVariablesVisitor)this);
        Expression elseExpr = (Expression)((Pair)caseExpr.getElseExpr().accept((ILangVisitor)this, (Object)env)).first;
        CaseExpression newCaseExpr = new CaseExpression(conditionExpr, whenExprList, thenExprList, elseExpr);
        newCaseExpr.setSourceLocation(caseExpr.getSourceLocation());
        return new Pair((Object)newCaseExpr, (Object)env);
    }

    @Override
    public Pair<ILangExpression, VariableSubstitutionEnvironment> visit(WindowExpression winExpr, VariableSubstitutionEnvironment env) throws CompilationException {
        List newExprList = VariableCloneAndSubstitutionUtil.visitAndCloneExprList((List)winExpr.getExprList(), (VariableSubstitutionEnvironment)env, (CloneAndSubstituteVariablesVisitor)this);
        Expression newAggFilterExpr = winExpr.hasAggregateFilterExpr() ? (Expression)((Pair)winExpr.getAggregateFilterExpr().accept((ILangVisitor)this, (Object)env)).first : null;
        List newPartitionList = winExpr.hasPartitionList() ? VariableCloneAndSubstitutionUtil.visitAndCloneExprList(winExpr.getPartitionList(), (VariableSubstitutionEnvironment)env, (CloneAndSubstituteVariablesVisitor)this) : null;
        List newOrderbyList = winExpr.hasOrderByList() ? VariableCloneAndSubstitutionUtil.visitAndCloneExprList(winExpr.getOrderbyList(), (VariableSubstitutionEnvironment)env, (CloneAndSubstituteVariablesVisitor)this) : null;
        ArrayList<OrderbyClause.OrderModifier> newOrderbyModifierList = winExpr.hasOrderByList() ? new ArrayList<OrderbyClause.OrderModifier>(winExpr.getOrderbyModifierList()) : null;
        ArrayList<OrderbyClause.NullOrderModifier> newOrderbyNullModifierList = winExpr.hasOrderByList() ? new ArrayList<OrderbyClause.NullOrderModifier>(winExpr.getOrderbyNullModifierList()) : null;
        Expression newFrameStartExpr = winExpr.hasFrameStartExpr() ? (Expression)((Pair)winExpr.getFrameStartExpr().accept((ILangVisitor)this, (Object)env)).first : null;
        Expression newFrameEndExpr = winExpr.hasFrameEndExpr() ? (Expression)((Pair)winExpr.getFrameEndExpr().accept((ILangVisitor)this, (Object)env)).first : null;
        VariableExpr newWindowVar = winExpr.hasWindowVar() ? (VariableExpr)((Pair)winExpr.getWindowVar().accept((ILangVisitor)this, (Object)env)).first : null;
        List newWindowFieldList = winExpr.hasWindowFieldList() ? VariableCloneAndSubstitutionUtil.substInFieldList(winExpr.getWindowFieldList(), (VariableSubstitutionEnvironment)env, (CloneAndSubstituteVariablesVisitor)this) : null;
        WindowExpression newWinExpr = new WindowExpression(winExpr.getFunctionSignature(), newExprList, newAggFilterExpr, newPartitionList, newOrderbyList, newOrderbyModifierList, newOrderbyNullModifierList, winExpr.getFrameMode(), winExpr.getFrameStartKind(), newFrameStartExpr, winExpr.getFrameEndKind(), newFrameEndExpr, winExpr.getFrameExclusionKind(), newWindowVar, newWindowFieldList, winExpr.getIgnoreNulls(), winExpr.getFromLast());
        newWinExpr.setSourceLocation(winExpr.getSourceLocation());
        newWinExpr.addHints(winExpr.getHints());
        return new Pair((Object)newWinExpr, (Object)env);
    }
}

