/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARectangleSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class ReferenceTileDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ReferenceTileDescriptor();
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.REFERENCE_TILE;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final IPointable inputArg0 = new VoidPointable();
                    private final IPointable inputArg1 = new VoidPointable();
                    private final IPointable inputArg2 = new VoidPointable();
                    private final IPointable inputArg3 = new VoidPointable();
                    private final IPointable inputArg4 = new VoidPointable();
                    private final IPointable inputArg5 = new VoidPointable();
                    private final IScalarEvaluator eval0;
                    private final IScalarEvaluator eval1;
                    private final IScalarEvaluator eval2;
                    private final IScalarEvaluator eval3;
                    private final IScalarEvaluator eval4;
                    private final IScalarEvaluator eval5;
                    private final AMutableInt32 aInt32;
                    private final ISerializerDeserializer intSerde;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.eval1 = args[1].createScalarEvaluator(ctx);
                        this.eval2 = args[2].createScalarEvaluator(ctx);
                        this.eval3 = args[3].createScalarEvaluator(ctx);
                        this.eval4 = args[4].createScalarEvaluator(ctx);
                        this.eval5 = args[5].createScalarEvaluator(ctx);
                        this.aInt32 = new AMutableInt32(0);
                        this.intSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.eval0.evaluate(tuple, this.inputArg0);
                        this.eval1.evaluate(tuple, this.inputArg1);
                        this.eval2.evaluate(tuple, this.inputArg2);
                        this.eval3.evaluate(tuple, this.inputArg3);
                        this.eval4.evaluate(tuple, this.inputArg4);
                        this.eval5.evaluate(tuple, this.inputArg5);
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.inputArg0, this.inputArg1, this.inputArg2, this.inputArg3, this.inputArg4)) {
                            return;
                        }
                        byte[] bytes0 = this.inputArg0.getByteArray();
                        byte[] bytes1 = this.inputArg1.getByteArray();
                        byte[] bytes2 = this.inputArg2.getByteArray();
                        byte[] bytes3 = this.inputArg3.getByteArray();
                        byte[] bytes4 = this.inputArg4.getByteArray();
                        int offset0 = this.inputArg0.getStartOffset();
                        int offset1 = this.inputArg1.getStartOffset();
                        int offset2 = this.inputArg2.getStartOffset();
                        int offset3 = this.inputArg3.getStartOffset();
                        int offset4 = this.inputArg4.getStartOffset();
                        ATypeTag tag0 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes0[offset0]);
                        ATypeTag tag1 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes1[offset1]);
                        ATypeTag tag2 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes2[offset2]);
                        if (tag0 != ATypeTag.RECTANGLE) {
                            throw new TypeMismatchException(ReferenceTileDescriptor.this.sourceLoc, ReferenceTileDescriptor.this.getIdentifier(), 0, bytes0[offset0], ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG);
                        }
                        if (tag1 != ATypeTag.RECTANGLE) {
                            throw new TypeMismatchException(ReferenceTileDescriptor.this.sourceLoc, ReferenceTileDescriptor.this.getIdentifier(), 0, bytes1[offset1], ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG);
                        }
                        if (tag2 != ATypeTag.RECTANGLE) {
                            throw new TypeMismatchException(ReferenceTileDescriptor.this.sourceLoc, ReferenceTileDescriptor.this.getIdentifier(), 0, bytes2[offset2], ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG);
                        }
                        double ax1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.X)));
                        double ay1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.Y)));
                        double bx1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.X)));
                        double by1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.Y)));
                        double minX = ADoubleSerializerDeserializer.getDouble((byte[])bytes2, (int)(offset2 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.X)));
                        double minY = ADoubleSerializerDeserializer.getDouble((byte[])bytes2, (int)(offset2 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.Y)));
                        double maxX = ADoubleSerializerDeserializer.getDouble((byte[])bytes2, (int)(offset2 + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.X)));
                        double maxY = ADoubleSerializerDeserializer.getDouble((byte[])bytes2, (int)(offset2 + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.Y)));
                        int rows = ATypeHierarchy.getIntegerValue((String)ReferenceTileDescriptor.this.getIdentifier().getName(), (int)0, (byte[])bytes3, (int)offset3);
                        int columns = ATypeHierarchy.getIntegerValue((String)ReferenceTileDescriptor.this.getIdentifier().getName(), (int)0, (byte[])bytes4, (int)offset4);
                        double x = Math.max(ax1, bx1);
                        double y = Math.max(ay1, by1);
                        int row = (int)Math.ceil((y - minY) * (double)rows / (maxY - minY));
                        int col = (int)Math.ceil((x - minX) * (double)columns / (maxX - minX));
                        row = Math.min(Math.max(1, row), rows * columns);
                        col = Math.min(Math.max(1, col), rows * columns);
                        int tileId = (row - 1) * columns + col;
                        this.resultStorage.reset();
                        this.aInt32.setValue(tileId);
                        this.intSerde.serialize((Object)this.aInt32, this.resultStorage.getDataOutput());
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }
}

