/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.bitwise;

import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.bitwise.AbstractBitValuePositionEvaluator;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;

@MissingNullInOutFunction
public class BitClearDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = -1790134294538449161L;
    public static final IFunctionDescriptorFactory FACTORY = BitClearDescriptor::new;

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.BIT_CLEAR;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new AbstractBitValuePositionEvaluator(ctx, args, BitClearDescriptor.this.getIdentifier(), BitClearDescriptor.this.sourceLoc){

                    @Override
                    long applyBitwiseOperation(long value, long position) {
                        return value & (1L << (int)(position - 1L) ^ 0xFFFFFFFFFFFFFFFFL);
                    }
                };
            }
        };
    }
}

