/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourceUtilizationPBImpl
extends ResourceUtilization {
    private YarnProtos.ResourceUtilizationProto proto = YarnProtos.ResourceUtilizationProto.getDefaultInstance();
    private YarnProtos.ResourceUtilizationProto.Builder builder = null;
    private boolean viaProto = false;

    public ResourceUtilizationPBImpl() {
        this.builder = YarnProtos.ResourceUtilizationProto.newBuilder();
    }

    public ResourceUtilizationPBImpl(YarnProtos.ResourceUtilizationProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ResourceUtilizationProto getProto() {
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ResourceUtilizationProto.newBuilder((YarnProtos.ResourceUtilizationProto)this.proto);
        }
        this.viaProto = false;
    }

    public int getPhysicalMemory() {
        YarnProtos.ResourceUtilizationProto p = this.viaProto ? this.proto : this.builder;
        return p.getPmem();
    }

    public void setPhysicalMemory(int pmem) {
        this.maybeInitBuilder();
        this.builder.setPmem(pmem);
    }

    public int getVirtualMemory() {
        YarnProtos.ResourceUtilizationProto p = this.viaProto ? this.proto : this.builder;
        return p.getVmem();
    }

    public void setVirtualMemory(int vmem) {
        this.maybeInitBuilder();
        this.builder.setVmem(vmem);
    }

    public float getCPU() {
        YarnProtos.ResourceUtilizationProto p = this.viaProto ? this.proto : this.builder;
        return p.getCpu();
    }

    public void setCPU(float cpu) {
        this.maybeInitBuilder();
        this.builder.setCpu(cpu);
    }

    public float getCustomResource(String resourceName) {
        return this.getCustomResources().get(resourceName).floatValue();
    }

    public Map<String, Float> getCustomResources() {
        YarnProtos.ResourceUtilizationProto p = this.viaProto ? this.proto : this.builder;
        return ProtoUtils.convertStringFloatMapProtoListToMap(p.getCustomResourcesList());
    }

    public void setCustomResources(Map<String, Float> customResources) {
        if (customResources != null) {
            this.maybeInitBuilder();
            this.builder.addAllCustomResources(ProtoUtils.convertMapToStringFloatMapProtoList(customResources));
        }
    }

    public int compareTo(ResourceUtilization other) {
        int diff = this.getPhysicalMemory() - other.getPhysicalMemory();
        if (diff == 0 && (diff = this.getVirtualMemory() - other.getVirtualMemory()) == 0 && (diff = Float.compare(this.getCPU(), other.getCPU())) == 0) {
            diff = this.getCustomResources().size() - other.getCustomResources().size();
        }
        return diff;
    }
}

