/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.statement.IDatasetDetailsDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.util.ConfigurationUtil;
import org.apache.asterix.lang.common.util.DatasetDeclParametersUtil;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.metadata.dataset.DatasetFormatInfo;
import org.apache.asterix.object.base.AdmObjectNode;
import org.apache.asterix.object.base.IAdmNode;
import org.apache.hyracks.util.StorageUtil;

public class DatasetDecl
extends AbstractStatement {
    protected final Identifier name;
    protected final Namespace namespace;
    protected final TypeExpression itemType;
    protected final TypeExpression metaItemType;
    protected final DatasetConfig.DatasetType datasetType;
    protected final IDatasetDetailsDecl datasetDetailsDecl;
    protected final Map<String, String> hints;
    private final AdmObjectNode withObjectNode;
    protected final boolean ifNotExists;
    protected final Query query;

    public DatasetDecl(Namespace namespace, Identifier name, TypeExpression itemType, TypeExpression metaItemType, Map<String, String> hints, DatasetConfig.DatasetType datasetType, IDatasetDetailsDecl idd, RecordConstructor withRecord, boolean ifNotExists) throws CompilationException {
        this(namespace, name, itemType, metaItemType, hints, datasetType, idd, withRecord, ifNotExists, null);
    }

    public DatasetDecl(Namespace namespace, Identifier name, TypeExpression itemType, TypeExpression metaItemType, Map<String, String> hints, DatasetConfig.DatasetType datasetType, IDatasetDetailsDecl idd, RecordConstructor withRecord, boolean ifNotExists, Query query) throws CompilationException {
        this.namespace = namespace;
        this.name = name;
        this.itemType = itemType;
        this.metaItemType = metaItemType;
        this.hints = hints;
        this.withObjectNode = DatasetDeclParametersUtil.validateAndGetWithObjectNode(withRecord, datasetType);
        this.ifNotExists = ifNotExists;
        this.datasetType = datasetType;
        this.datasetDetailsDecl = idd;
        this.query = query;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public DatasetConfig.DatasetType getDatasetType() {
        return this.datasetType;
    }

    public Identifier getName() {
        return this.name;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public DataverseName getDataverse() {
        return this.namespace == null ? null : this.namespace.getDataverseName();
    }

    public TypeExpression getItemType() {
        return this.itemType;
    }

    public TypeExpression getMetaItemType() {
        return this.metaItemType;
    }

    public Query getQuery() {
        return this.query;
    }

    public String getNodegroupName() {
        AdmObjectNode nodeGroupObj = (AdmObjectNode)this.withObjectNode.get("node-group");
        if (nodeGroupObj == null) {
            return null;
        }
        return nodeGroupObj.getOptionalString("name");
    }

    private AdmObjectNode getMergePolicyObject() {
        return (AdmObjectNode)this.withObjectNode.get("merge-policy");
    }

    public String getCompactionPolicy() {
        AdmObjectNode mergePolicy = this.getMergePolicyObject();
        if (mergePolicy == null) {
            return null;
        }
        return mergePolicy.getOptionalString("name");
    }

    public Map<String, String> getCompactionPolicyProperties() throws CompilationException {
        AdmObjectNode mergePolicy = this.getMergePolicyObject();
        if (mergePolicy == null) {
            return null;
        }
        IAdmNode mergePolicyParameters = mergePolicy.get("parameters");
        if (mergePolicyParameters == null) {
            return null;
        }
        return ConfigurationUtil.toProperties((AdmObjectNode)mergePolicyParameters);
    }

    public String getDatasetCompressionScheme() {
        if (this.datasetType != DatasetConfig.DatasetType.INTERNAL) {
            return "none";
        }
        AdmObjectNode storageBlockCompression = (AdmObjectNode)this.withObjectNode.get("storage-block-compression");
        if (storageBlockCompression == null) {
            return null;
        }
        return storageBlockCompression.getOptionalString("scheme");
    }

    public DatasetFormatInfo getDatasetFormatInfo(String defaultFormat, int defaultMaxTupleCount, double defaultFreeSpaceTolerance, int defaultMaxLeafNodeSize) throws CompilationException {
        if (this.datasetType != DatasetConfig.DatasetType.INTERNAL) {
            return DatasetFormatInfo.SYSTEM_DEFAULT;
        }
        AdmObjectNode datasetFormatNode = (AdmObjectNode)this.withObjectNode.getOrDefault("storage-format", (IAdmNode)AdmObjectNode.EMPTY);
        DatasetConfig.DatasetFormat datasetFormat = DatasetConfig.DatasetFormat.getFormat((String)datasetFormatNode.getOptionalString("format", defaultFormat));
        if (datasetFormat == DatasetConfig.DatasetFormat.ROW) {
            return DatasetFormatInfo.SYSTEM_DEFAULT;
        }
        int maxTupleCount = datasetFormatNode.getOptionalInt("max-tuple-count", defaultMaxTupleCount);
        double freeSpaceTolerance = datasetFormatNode.getOptionalDouble("free-space-tolerance", defaultFreeSpaceTolerance);
        String maxLeafNodeSizeString = datasetFormatNode.getOptionalString("max-leaf-node-size");
        int maxLeafNodeSize = maxLeafNodeSizeString == null ? defaultMaxLeafNodeSize : (int)StorageUtil.getByteValue((String)maxLeafNodeSizeString);
        return new DatasetFormatInfo(datasetFormat, maxTupleCount, freeSpaceTolerance, maxLeafNodeSize);
    }

    public Map<String, String> getHints() {
        return this.hints;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.DATASET_DECL;
    }

    public IDatasetDetailsDecl getDatasetDetailsDecl() {
        return this.datasetDetailsDecl;
    }

    @Override
    public byte getCategory() {
        return 4;
    }

    public AdmObjectNode getWithObjectNode() {
        return this.withObjectNode;
    }
}

