/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.common.EnforcedIndexCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class TreeIndexDiskOrderScanCursor
extends EnforcedIndexCursor
implements ITreeIndexCursor {
    protected int tupleIndex = 0;
    protected int fileId = -1;
    protected int currentPageId = -1;
    protected int maxPageId = -1;
    protected ICachedPage page = null;
    protected IBufferCache bufferCache = null;
    private final ITreeIndexFrame frame;
    private final ITreeIndexTupleReference frameTuple;

    public TreeIndexDiskOrderScanCursor(ITreeIndexFrame frame) {
        this.frame = frame;
        this.frameTuple = frame.createTupleReference();
    }

    public void doDestroy() throws HyracksDataException {
        this.tupleIndex = 0;
        this.currentPageId = -1;
        this.maxPageId = -1;
        this.releasePage();
    }

    public ITreeIndexTupleReference doGetTuple() {
        return this.frameTuple;
    }

    private boolean positionToNextLeaf(boolean skipCurrent) throws HyracksDataException {
        while ((this.frame.getLevel() != 0 || skipCurrent || this.frame.getTupleCount() == 0) && ++this.currentPageId <= this.maxPageId) {
            ICachedPage nextPage;
            this.releasePage();
            this.page = nextPage = this.acquireNextPage();
            this.frame.setPage(this.page);
            this.tupleIndex = 0;
            skipCurrent = false;
        }
        return this.currentPageId <= this.maxPageId;
    }

    public boolean doHasNext() throws HyracksDataException {
        if (this.currentPageId > this.maxPageId) {
            return false;
        }
        if (this.tupleIndex >= this.frame.getTupleCount()) {
            boolean nextLeafExists = this.positionToNextLeaf(true);
            if (nextLeafExists) {
                this.frameTuple.resetByTupleIndex(this.frame, this.tupleIndex);
                return true;
            }
            return false;
        }
        this.frameTuple.resetByTupleIndex(this.frame, this.tupleIndex);
        return true;
    }

    public void doNext() throws HyracksDataException {
        ++this.tupleIndex;
    }

    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        this.page = initialState.getPage();
        this.tupleIndex = 0;
        this.frame.setPage(this.page);
        this.positionToNextLeaf(false);
    }

    public void doClose() throws HyracksDataException {
        this.tupleIndex = 0;
        this.currentPageId = -1;
        this.maxPageId = -1;
        this.releasePage();
    }

    @Override
    public void setBufferCache(IBufferCache bufferCache) {
        this.bufferCache = bufferCache;
    }

    @Override
    public void setFileId(int fileId) {
        this.fileId = fileId;
    }

    public void setCurrentPageId(int currentPageId) {
        this.currentPageId = currentPageId;
    }

    public void setMaxPageId(int maxPageId) {
        this.maxPageId = maxPageId;
    }

    @Override
    public boolean isExclusiveLatchNodes() {
        return false;
    }

    protected void releasePage() throws HyracksDataException {
        if (this.page != null) {
            this.page.releaseReadLatch();
            this.bufferCache.unpin(this.page);
            this.page = null;
        }
    }

    protected ICachedPage acquireNextPage() throws HyracksDataException {
        ICachedPage nextPage = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.currentPageId), false);
        nextPage.acquireReadLatch();
        return nextPage;
    }
}

