/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.util;

import java.util.List;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.rules.am.IOptimizableFuncExpr;
import org.apache.asterix.optimizer.rules.am.InvertedIndexAccessMethod;
import org.apache.asterix.runtime.evaluators.functions.FullTextContainsFunctionDescriptor;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;

public class FullTextUtil {
    public static boolean isFullTextContainsFunctionExpr(IOptimizableFuncExpr expr) {
        return FullTextUtil.isFullTextContainsFunctionExpr(expr.getFuncExpr());
    }

    public static boolean isFullTextContainsFunctionExpr(AbstractFunctionCallExpression expr) {
        FunctionIdentifier funcId = expr.getFunctionIdentifier();
        return funcId.equals((Object)BuiltinFunctions.FULLTEXT_CONTAINS) || funcId.equals((Object)BuiltinFunctions.FULLTEXT_CONTAINS_WO_OPTION);
    }

    public static String getFullTextConfigNameFromExpr(IOptimizableFuncExpr expr) {
        return FullTextUtil.getFullTextConfigNameFromExpr(expr.getFuncExpr());
    }

    public static String getFullTextConfigNameFromExpr(AbstractFunctionCallExpression funcExpr) {
        if (!FullTextUtil.isFullTextContainsFunctionExpr(funcExpr)) {
            return null;
        }
        String configName = null;
        List arguments = funcExpr.getArguments();
        for (int i = 2; i < arguments.size(); i += 2) {
            String optionName = ConstantExpressionUtil.getStringConstant((ILogicalExpression)((ILogicalExpression)((Mutable)arguments.get(i)).getValue()));
            if (!optionName.equalsIgnoreCase("config")) continue;
            configName = ConstantExpressionUtil.getStringConstant((ILogicalExpression)((ILogicalExpression)((Mutable)arguments.get(i + 1)).getValue()));
            break;
        }
        return configName;
    }

    public static InvertedIndexAccessMethod.SearchModifierType getFullTextSearchModeFromExpr(AbstractFunctionCallExpression funcExpr) {
        for (int i = 2; i < funcExpr.getArguments().size(); i += 2) {
            String optionName = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)funcExpr, (int)i);
            if (!optionName.equals("mode")) continue;
            String searchType = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)funcExpr, (int)(i + 1));
            if (searchType.equals(FullTextContainsFunctionDescriptor.SearchMode.ALL.getValue())) {
                return InvertedIndexAccessMethod.SearchModifierType.CONJUNCTIVE;
            }
            return InvertedIndexAccessMethod.SearchModifierType.DISJUNCTIVE;
        }
        return InvertedIndexAccessMethod.SearchModifierType.CONJUNCTIVE;
    }
}

