/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.utils;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.cluster.PartitioningProperties;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.dataflow.LSMTreeInsertDeleteOperatorDescriptor;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.external.api.ITypedAdapterFactory;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.external.feed.management.FeedConnectionId;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.operators.FeedCollectOperatorDescriptor;
import org.apache.asterix.external.operators.FeedIntakeOperatorDescriptor;
import org.apache.asterix.external.operators.FeedMetaOperatorDescriptor;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.IntegerLiteral;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.statement.UpsertStatement;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.parser.SqlppParserFactory;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.feeds.FeedMetadataUtil;
import org.apache.asterix.metadata.feeds.LocationConstraint;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.runtime.job.listener.JobEventListenerFactory;
import org.apache.asterix.runtime.job.listener.MultiTransactionJobletEventListenerFactory;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.asterix.translator.CompiledStatements;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.algebricks.runtime.operators.std.AssignRuntimeFactory;
import org.apache.hyracks.api.client.IClusterInfoCollector;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.constraints.Constraint;
import org.apache.hyracks.api.constraints.PartitionConstraintHelper;
import org.apache.hyracks.api.constraints.expressions.ConstantExpression;
import org.apache.hyracks.api.constraints.expressions.ConstraintExpression;
import org.apache.hyracks.api.constraints.expressions.LValueConstraintExpression;
import org.apache.hyracks.api.constraints.expressions.PartitionCountExpression;
import org.apache.hyracks.api.constraints.expressions.PartitionLocationExpression;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.OperatorDescriptorId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.connectors.MToNPartitioningConnectorDescriptor;
import org.apache.hyracks.dataflow.std.connectors.MToNPartitioningWithMessageConnectorDescriptor;
import org.apache.hyracks.dataflow.std.connectors.OneToOneConnectorDescriptor;
import org.apache.hyracks.dataflow.std.file.FileRemoveOperatorDescriptor;
import org.apache.hyracks.dataflow.std.misc.NullSinkOperatorDescriptor;
import org.apache.hyracks.dataflow.std.misc.ReplicateOperatorDescriptor;

public class FeedOperations {
    public static final String FEED_DATAFLOW_INTERMEIDATE_VAL_PREFIX = "val";

    private FeedOperations() {
    }

    private static Pair<JobSpecification, ITypedAdapterFactory> buildFeedIntakeJobSpec(Feed feed, MetadataProvider metadataProvider, FeedPolicyAccessor policyAccessor) throws Exception {
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)metadataProvider.getApplicationContext());
        spec.setFrameSize(metadataProvider.getApplicationContext().getCompilerProperties().getFrameSize());
        Triple t = metadataProvider.getFeedIntakeRuntime(spec, feed, policyAccessor);
        IOperatorDescriptor feedIngestor = (IOperatorDescriptor)t.first;
        AlgebricksPartitionConstraint ingesterPc = (AlgebricksPartitionConstraint)t.second;
        ITypedAdapterFactory adapterFactory = (ITypedAdapterFactory)t.third;
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)feedIngestor, (AlgebricksPartitionConstraint)ingesterPc);
        NullSinkOperatorDescriptor nullSink = new NullSinkOperatorDescriptor((IOperatorDescriptorRegistry)spec);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)nullSink, (AlgebricksPartitionConstraint)ingesterPc);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), feedIngestor, 0, (IOperatorDescriptor)nullSink, 0);
        spec.addRoot((IOperatorDescriptor)nullSink);
        return Pair.of((Object)spec, (Object)adapterFactory);
    }

    public static JobSpecification buildRemoveFeedStorageJob(MetadataProvider metadataProvider, Feed feed) throws AlgebricksException {
        ICcApplicationContext appCtx = metadataProvider.getApplicationContext();
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)appCtx);
        PartitioningProperties partitioningProperties = metadataProvider.getPartitioningProperties(feed);
        FileRemoveOperatorDescriptor frod = new FileRemoveOperatorDescriptor((IOperatorDescriptorRegistry)spec, partitioningProperties.getSplitsProvider(), true, partitioningProperties.getComputeStorageMap());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)frod, (AlgebricksPartitionConstraint)partitioningProperties.getConstraints());
        spec.addRoot((IOperatorDescriptor)frod);
        return spec;
    }

    private static List<Expression> addArgs(Object ... args) {
        ArrayList<Expression> argExprs = new ArrayList<Expression>();
        for (Object arg : args) {
            if (arg instanceof Integer) {
                argExprs.add((Expression)new LiteralExpr((Literal)new IntegerLiteral((Integer)arg)));
                continue;
            }
            if (arg instanceof String) {
                argExprs.add((Expression)new LiteralExpr((Literal)new StringLiteral((String)arg)));
                continue;
            }
            if (arg instanceof Expression) {
                argExprs.add((Expression)arg);
                continue;
            }
            if (arg instanceof DataverseName) {
                argExprs.add((Expression)new LiteralExpr((Literal)new StringLiteral(((DataverseName)arg).getCanonicalForm())));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return argExprs;
    }

    private static Query makeConnectionQuery(FeedConnection feedConnection, MetadataProvider md) throws AlgebricksException {
        VarIdentifier fromVarId = SqlppVariableUtil.toInternalVariableIdentifier((String)feedConnection.getFeedName());
        VariableExpr fromTermLeftExpr = new VariableExpr(fromVarId);
        List<Expression> exprList = FeedOperations.addArgs(feedConnection.getDatabaseName(), feedConnection.getDataverseName(), feedConnection.getFeedId().getEntityName(), feedConnection.getFeedId().getEntityName(), FeedUtils.FeedRuntimeType.INTAKE.toString(), feedConnection.getDatasetName(), feedConnection.getOutputType());
        CallExpr datasrouceCallFunction = new CallExpr(new FunctionSignature(BuiltinFunctions.FEED_COLLECT), exprList);
        FromTerm fromterm = new FromTerm((Expression)datasrouceCallFunction, fromTermLeftExpr, null, null);
        FromClause fromClause = new FromClause(Arrays.asList(fromterm));
        WhereClause whereClause = null;
        if (feedConnection.getWhereClauseBody().length() != 0) {
            String whereClauseExpr = feedConnection.getWhereClauseBody() + ";";
            SqlppParserFactory sqlppParserFactory = new SqlppParserFactory(md.getNamespaceResolver());
            IParser sqlppParser = sqlppParserFactory.createParser(whereClauseExpr);
            List stmts = sqlppParser.parse();
            if (stmts.size() != 1) {
                throw new CompilationException("Exceptions happened in processing where clause.");
            }
            Query whereClauseQuery = (Query)stmts.get(0);
            whereClause = new WhereClause(whereClauseQuery.getBody());
        }
        VariableExpr previousVarExpr = fromTermLeftExpr;
        for (FunctionSignature functionSignature : feedConnection.getAppliedFunctions()) {
            CallExpr functionCallExpr = new CallExpr(functionSignature, FeedOperations.addArgs(previousVarExpr));
            previousVarExpr = functionCallExpr;
        }
        SelectElement selectElement = new SelectElement((Expression)previousVarExpr);
        SelectClause selectClause = new SelectClause(selectElement, null, false);
        SelectBlock selectBlock = new SelectBlock(selectClause, fromClause, whereClause != null ? Collections.singletonList(whereClause) : null, null, null);
        SelectSetOperation selectSetOperation = new SelectSetOperation(new SetOperationInput(selectBlock, null), null);
        SelectExpression body = new SelectExpression(null, selectSetOperation, null, null, true);
        Query query = new Query(false, true, (Expression)body, 0);
        return query;
    }

    private static JobSpecification getConnectionJob(MetadataProvider metadataProvider, FeedConnection feedConn, IStatementExecutor statementExecutor, IHyracksClientConnection hcc, Boolean insertFeed) throws AlgebricksException, RemoteException, ACIDException {
        CompiledStatements.CompiledInsertStatement clfrqs;
        metadataProvider.getConfig().put("feed-policy-name", feedConn.getPolicyName());
        Query feedConnQuery = FeedOperations.makeConnectionQuery(feedConn, metadataProvider);
        String feedDatabaseName = feedConn.getDatabaseName();
        DataverseName feedDataverseName = feedConn.getDataverseName();
        if (insertFeed.booleanValue()) {
            InsertStatement stmtUpsert = new InsertStatement(new Namespace(feedDatabaseName, feedDataverseName), feedConn.getDatasetName(), feedConnQuery, -1, null, null);
            clfrqs = new CompiledStatements.CompiledInsertStatement(feedDatabaseName, feedDataverseName, feedConn.getDatasetName(), feedConnQuery, stmtUpsert.getVarCounter(), null, null);
        } else {
            UpsertStatement stmtUpsert = new UpsertStatement(new Namespace(feedDatabaseName, feedDataverseName), feedConn.getDatasetName(), feedConnQuery, -1, null, null);
            clfrqs = new CompiledStatements.CompiledUpsertStatement(feedDatabaseName, feedDataverseName, feedConn.getDatasetName(), feedConnQuery, stmtUpsert.getVarCounter(), null, null);
        }
        return statementExecutor.rewriteCompileQuery((IClusterInfoCollector)hcc, metadataProvider, feedConnQuery, (CompiledStatements.ICompiledDmlStatement)clfrqs, null, null);
    }

    private static JobSpecification combineIntakeCollectJobs(MetadataProvider metadataProvider, Feed feed, JobSpecification intakeJob, List<JobSpecification> jobsList, List<FeedConnection> feedConnections, String[] intakeLocations) throws AlgebricksException, HyracksDataException {
        JobSpecification jobSpec = new JobSpecification(intakeJob.getFrameSize());
        FeedIntakeOperatorDescriptor firstOp = (FeedIntakeOperatorDescriptor)intakeJob.getOperatorMap().get(new OperatorDescriptorId(0));
        FeedIntakeOperatorDescriptor ingestionOp = firstOp.getAdaptorFactory() == null ? new FeedIntakeOperatorDescriptor(jobSpec, (IFeed)feed, firstOp.getAdaptorLibraryDatabase(), firstOp.getAdaptorLibraryDataverse(), firstOp.getAdaptorLibraryName(), firstOp.getAdaptorFactoryClassName(), firstOp.getAdapterOutputType(), firstOp.getPolicyAccessor(), firstOp.getOutputRecordDescriptors()[0]) : new FeedIntakeOperatorDescriptor(jobSpec, (IFeed)feed, firstOp.getAdaptorFactory(), firstOp.getAdapterOutputType(), firstOp.getPolicyAccessor(), firstOp.getOutputRecordDescriptors()[0]);
        ReplicateOperatorDescriptor replicateOp = new ReplicateOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, ingestionOp.getOutputRecordDescriptors()[0], jobsList.size());
        jobSpec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)jobSpec), (IOperatorDescriptor)ingestionOp, 0, (IOperatorDescriptor)replicateOp, 0);
        PartitionConstraintHelper.addAbsoluteLocationConstraint((JobSpecification)jobSpec, (IOperatorDescriptor)ingestionOp, (String[])intakeLocations);
        PartitionConstraintHelper.addAbsoluteLocationConstraint((JobSpecification)jobSpec, (IOperatorDescriptor)replicateOp, (String[])intakeLocations);
        HashMap<OperatorDescriptorId, OperatorDescriptorId> operatorIdMapping = new HashMap<OperatorDescriptorId, OperatorDescriptorId>();
        HashMap connectorIdMapping = new HashMap();
        HashMap operatorLocations = new HashMap();
        HashMap<OperatorDescriptorId, Integer> operatorCounts = new HashMap<OperatorDescriptorId, Integer>();
        HashMap<Integer, TxnId> txnIdMap = new HashMap<Integer, TxnId>();
        for (int iter1 = 0; iter1 < jobsList.size(); ++iter1) {
            OperatorDescriptorId opId;
            IOperatorDescriptor opDesc;
            FeedConnection curFeedConnection = feedConnections.get(iter1);
            JobSpecification subJob = jobsList.get(iter1);
            operatorIdMapping.clear();
            Map operatorsMap = subJob.getOperatorMap();
            String datasetName = feedConnections.get(iter1).getDatasetName();
            FeedConnectionId feedConnectionId = new FeedConnectionId(ingestionOp.getEntityId(), datasetName);
            FeedPolicyEntity feedPolicyEntity = FeedMetadataUtil.validateIfPolicyExists((String)curFeedConnection.getDatabaseName(), (DataverseName)curFeedConnection.getDataverseName(), (String)curFeedConnection.getPolicyName(), (MetadataTransactionContext)metadataProvider.getMetadataTxnContext());
            for (Map.Entry entry : operatorsMap.entrySet()) {
                FeedMetaOperatorDescriptor metaOp;
                opDesc = (IOperatorDescriptor)entry.getValue();
                OperatorDescriptorId oldId = opDesc.getOperatorId();
                opId = null;
                if (opDesc instanceof LSMTreeInsertDeleteOperatorDescriptor && ((LSMTreeInsertDeleteOperatorDescriptor)opDesc).isPrimary()) {
                    metaOp = new FeedMetaOperatorDescriptor(jobSpec, feedConnectionId, opDesc, feedPolicyEntity.getProperties(), FeedUtils.FeedRuntimeType.STORE, true);
                    opId = metaOp.getOperatorId();
                    opDesc.setOperatorId(opId);
                } else {
                    IConnectorDescriptor connectorDesc;
                    AlgebricksMetaOperatorDescriptor algOp;
                    IPushRuntimeFactory[] runtimeFactories;
                    if (opDesc instanceof AlgebricksMetaOperatorDescriptor && (runtimeFactories = (algOp = (AlgebricksMetaOperatorDescriptor)opDesc).getPipeline().getRuntimeFactories())[0] instanceof AssignRuntimeFactory && runtimeFactories.length > 1 && (connectorDesc = (IConnectorDescriptor)((List)subJob.getOperatorInputMap().get(opDesc.getOperatorId())).get(0)) instanceof MToNPartitioningConnectorDescriptor) {
                        metaOp = new FeedMetaOperatorDescriptor(jobSpec, feedConnectionId, opDesc, feedPolicyEntity.getProperties(), FeedUtils.FeedRuntimeType.COMPUTE, true);
                        opId = metaOp.getOperatorId();
                        opDesc.setOperatorId(opId);
                    }
                    if (opId == null) {
                        opId = jobSpec.createOperatorDescriptorId(opDesc);
                    }
                }
                operatorIdMapping.put(oldId, opId);
            }
            connectorIdMapping.clear();
            subJob.getConnectorMap().forEach((key, connDesc) -> {
                ConnectorDescriptorId newConnId;
                if (connDesc instanceof MToNPartitioningConnectorDescriptor) {
                    MToNPartitioningConnectorDescriptor m2nConn = (MToNPartitioningConnectorDescriptor)connDesc;
                    connDesc = new MToNPartitioningWithMessageConnectorDescriptor((IConnectorDescriptorRegistry)jobSpec, m2nConn.getTuplePartitionComputerFactory());
                    newConnId = connDesc.getConnectorId();
                } else {
                    newConnId = jobSpec.createConnectorDescriptor(connDesc);
                }
                connectorIdMapping.put(key, newConnId);
            });
            for (Map.Entry entry : subJob.getConnectorOperatorMap().entrySet()) {
                ConnectorDescriptorId newId = (ConnectorDescriptorId)connectorIdMapping.get(entry.getKey());
                IConnectorDescriptor connDesc2 = (IConnectorDescriptor)jobSpec.getConnectorMap().get(newId);
                Pair leftOp = (Pair)((Pair)entry.getValue()).getLeft();
                Pair rightOp = (Pair)((Pair)entry.getValue()).getRight();
                IOperatorDescriptor leftOpDesc = (IOperatorDescriptor)jobSpec.getOperatorMap().get(((IOperatorDescriptor)leftOp.getLeft()).getOperatorId());
                IOperatorDescriptor rightOpDesc = (IOperatorDescriptor)jobSpec.getOperatorMap().get(((IOperatorDescriptor)rightOp.getLeft()).getOperatorId());
                if (leftOp.getLeft() instanceof FeedCollectOperatorDescriptor) {
                    jobSpec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)jobSpec), (IOperatorDescriptor)replicateOp, iter1, leftOpDesc, ((Integer)leftOp.getRight()).intValue());
                }
                jobSpec.connect(connDesc2, leftOpDesc, ((Integer)leftOp.getRight()).intValue(), rightOpDesc, ((Integer)rightOp.getRight()).intValue());
            }
            operatorLocations.clear();
            operatorCounts.clear();
            for (Constraint constraint : subJob.getUserConstraints()) {
                LValueConstraintExpression lexpr = constraint.getLValue();
                ConstraintExpression cexpr = constraint.getRValue();
                switch (lexpr.getTag()) {
                    case PARTITION_COUNT: {
                        opId = ((PartitionCountExpression)lexpr).getOperatorDescriptorId();
                        operatorCounts.put((OperatorDescriptorId)operatorIdMapping.get(opId), (Integer)((ConstantExpression)cexpr).getValue());
                        break;
                    }
                    case PARTITION_LOCATION: {
                        opId = ((PartitionLocationExpression)lexpr).getOperatorDescriptorId();
                        IOperatorDescriptor opDesc2 = (IOperatorDescriptor)jobSpec.getOperatorMap().get(operatorIdMapping.get(opId));
                        ArrayList<LocationConstraint> locations = (ArrayList<LocationConstraint>)operatorLocations.get(opDesc2.getOperatorId());
                        if (locations == null) {
                            locations = new ArrayList<LocationConstraint>();
                            operatorLocations.put(opDesc2.getOperatorId(), locations);
                        }
                        String location = (String)((ConstantExpression)cexpr).getValue();
                        LocationConstraint lc = new LocationConstraint(location, ((PartitionLocationExpression)lexpr).getPartition());
                        locations.add(lc);
                        break;
                    }
                }
            }
            for (Map.Entry entry : operatorLocations.entrySet()) {
                opDesc = (IOperatorDescriptor)jobSpec.getOperatorMap().get(entry.getKey());
                Collections.sort((List)entry.getValue(), (o1, o2) -> o1.partition - o2.partition);
                String[] locations = new String[((List)entry.getValue()).size()];
                for (int j = 0; j < locations.length; ++j) {
                    locations[j] = ((LocationConstraint)((List)entry.getValue()).get((int)j)).location;
                }
                PartitionConstraintHelper.addAbsoluteLocationConstraint((JobSpecification)jobSpec, (IOperatorDescriptor)opDesc, (String[])locations);
            }
            operatorCounts.forEach((key, value) -> {
                IOperatorDescriptor opDesc = (IOperatorDescriptor)jobSpec.getOperatorMap().get(key);
                if (!operatorLocations.keySet().contains(key)) {
                    PartitionConstraintHelper.addPartitionCountConstraint((JobSpecification)jobSpec, (IOperatorDescriptor)opDesc, (int)value);
                }
            });
            for (OperatorDescriptorId root : subJob.getRoots()) {
                jobSpec.addRoot((IOperatorDescriptor)jobSpec.getOperatorMap().get(operatorIdMapping.get(root)));
            }
            int datasetId = metadataProvider.findDataset(curFeedConnection.getDatabaseName(), curFeedConnection.getDataverseName(), curFeedConnection.getDatasetName()).getDatasetId();
            TxnId txnId = ((JobEventListenerFactory)subJob.getJobletEventListenerFactory()).getTxnId(datasetId);
            txnIdMap.put(datasetId, txnId);
        }
        jobSpec.setJobletEventListenerFactory((IJobletEventListenerFactory)new MultiTransactionJobletEventListenerFactory(txnIdMap, true));
        jobSpec.setUseConnectorPolicyForScheduling(jobsList.get(0).isUseConnectorPolicyForScheduling());
        jobSpec.setConnectorPolicyAssignmentPolicy(jobsList.get(0).getConnectorPolicyAssignmentPolicy());
        return jobSpec;
    }

    public static Pair<JobSpecification, AlgebricksAbsolutePartitionConstraint> buildStartFeedJob(MetadataProvider metadataProvider, Feed feed, List<FeedConnection> feedConnections, IStatementExecutor statementExecutor, IHyracksClientConnection hcc) throws Exception {
        FeedPolicyAccessor fpa = new FeedPolicyAccessor(new HashMap());
        Pair<JobSpecification, ITypedAdapterFactory> intakeInfo = FeedOperations.buildFeedIntakeJobSpec(feed, metadataProvider, fpa);
        ArrayList<JobSpecification> jobsList = new ArrayList<JobSpecification>();
        Boolean insertFeed = ExternalDataUtils.isInsertFeed((Map)feed.getConfiguration());
        JobSpecification intakeJob = (JobSpecification)intakeInfo.getLeft();
        ITypedAdapterFactory ingestionAdaptorFactory = (ITypedAdapterFactory)intakeInfo.getRight();
        Object[] ingestionLocations = ingestionAdaptorFactory.getPartitionConstraint().getLocations();
        metadataProvider.getConfig().put("import-private-functions", Boolean.TRUE.toString());
        metadataProvider.getConfig().put("collect-locations", StringUtils.join((Object[])ingestionLocations, (char)','));
        for (FeedConnection feedConnection : feedConnections) {
            JobSpecification connectionJob = FeedOperations.getConnectionJob(metadataProvider, feedConnection, statementExecutor, hcc, insertFeed);
            jobsList.add(connectionJob);
        }
        return Pair.of((Object)FeedOperations.combineIntakeCollectJobs(metadataProvider, feed, intakeJob, jobsList, feedConnections, (String[])ingestionLocations), (Object)((ITypedAdapterFactory)intakeInfo.getRight()).getPartitionConstraint());
    }
}

