/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.metadata.schema;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.asterix.column.metadata.PathInfoSerializer;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNestedNode;
import org.apache.asterix.column.metadata.schema.ISchemaNodeVisitor;
import org.apache.asterix.column.metadata.schema.ObjectSchemaNode;
import org.apache.asterix.column.metadata.schema.UnionSchemaNode;
import org.apache.asterix.column.metadata.schema.collection.ArraySchemaNode;
import org.apache.asterix.column.metadata.schema.collection.MultisetSchemaNode;
import org.apache.asterix.column.metadata.schema.primitive.MissingFieldSchemaNode;
import org.apache.asterix.column.metadata.schema.primitive.PrimitiveSchemaNode;
import org.apache.asterix.column.util.RunLengthIntArray;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class AbstractSchemaNode {
    private int counter;

    public abstract ATypeTag getTypeTag();

    public abstract boolean isNested();

    public abstract boolean isObjectOrCollection();

    public abstract boolean isCollection();

    public final void incrementCounter() {
        ++this.counter;
    }

    public final void setCounter(int counter) {
        this.counter = counter;
    }

    public final int getCounter() {
        return this.counter;
    }

    public abstract <R, T> R accept(ISchemaNodeVisitor<R, T> var1, T var2) throws HyracksDataException;

    public abstract void serialize(DataOutput var1, PathInfoSerializer var2) throws IOException;

    public static AbstractSchemaNode deserialize(DataInput input, Map<AbstractSchemaNestedNode, RunLengthIntArray> definitionLevels) throws IOException {
        ATypeTag typeTag = ATypeTag.VALUE_TYPE_MAPPING[input.readByte()];
        switch (typeTag) {
            case SYSTEM_NULL: {
                return MissingFieldSchemaNode.INSTANCE;
            }
            case OBJECT: {
                return new ObjectSchemaNode(input, definitionLevels);
            }
            case ARRAY: {
                return new ArraySchemaNode(input, definitionLevels);
            }
            case MULTISET: {
                return new MultisetSchemaNode(input, definitionLevels);
            }
            case UNION: {
                return new UnionSchemaNode(input, definitionLevels);
            }
            case NULL: 
            case MISSING: 
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case UUID: {
                return new PrimitiveSchemaNode(typeTag, input);
            }
        }
        throw new UnsupportedEncodingException(typeTag + " is not supported");
    }
}

