/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc.core;

import java.sql.ParameterMetaData;
import java.util.Objects;
import org.apache.asterix.jdbc.core.ADBDatatype;
import org.apache.asterix.jdbc.core.ADBErrorReporter;
import org.apache.asterix.jdbc.core.ADBPreparedStatement;
import org.apache.asterix.jdbc.core.ADBWrapperSupport;

public class ADBParameterMetaData
extends ADBWrapperSupport
implements ParameterMetaData {
    protected final ADBPreparedStatement statement;
    protected final int parameterCount;

    public ADBParameterMetaData(ADBPreparedStatement statement, int parameterCount) {
        this.statement = Objects.requireNonNull(statement);
        this.parameterCount = parameterCount;
    }

    @Override
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public int getParameterMode(int parameterIndex) {
        return 1;
    }

    @Override
    public int getParameterType(int parameterIndex) {
        return ADBDatatype.ANY.getJdbcType().getVendorTypeNumber();
    }

    @Override
    public String getParameterTypeName(int parameterIndex) {
        return ADBDatatype.ANY.getTypeName();
    }

    @Override
    public String getParameterClassName(int parameterIndex) {
        return Object.class.getName();
    }

    @Override
    public int isNullable(int parameterIndex) {
        return 1;
    }

    @Override
    public boolean isSigned(int parameterIndex) {
        return false;
    }

    @Override
    public int getPrecision(int parameterIndex) {
        return 0;
    }

    @Override
    public int getScale(int parameterIndex) {
        return 0;
    }

    @Override
    protected ADBErrorReporter getErrorReporter() {
        return this.statement.getErrorReporter();
    }
}

