/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc.core;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.asterix.jdbc.core.ADBColumn;
import org.apache.asterix.jdbc.core.ADBErrorReporter;
import org.apache.asterix.jdbc.core.ADBStatement;
import org.apache.asterix.jdbc.core.ADBWrapperSupport;

public class ADBResultSetMetaData
extends ADBWrapperSupport
implements ResultSetMetaData {
    final ADBStatement statement;
    private final List<ADBColumn> columns;
    private final Map<String, Integer> indexByName;

    public ADBResultSetMetaData(ADBStatement statement, List<ADBColumn> columns) {
        this.statement = Objects.requireNonNull(statement);
        this.columns = columns != null ? columns : Collections.emptyList();
        this.indexByName = ADBResultSetMetaData.createIndexByName(this.columns);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int columnNumber) throws SQLException {
        return this.getColumnByNumber(columnNumber).getName();
    }

    @Override
    public String getColumnLabel(int columnNumber) throws SQLException {
        return this.getColumnByNumber(columnNumber).getName();
    }

    @Override
    public int getColumnType(int columnNumber) throws SQLException {
        return this.getColumnByNumber(columnNumber).getType().getJdbcType().getVendorTypeNumber();
    }

    @Override
    public String getColumnTypeName(int columnNumber) throws SQLException {
        return this.getColumnByNumber(columnNumber).getType().getTypeName();
    }

    @Override
    public String getColumnClassName(int columnNumber) throws SQLException {
        return this.getColumnByNumber(columnNumber).getType().getJavaClass().getName();
    }

    @Override
    public int getColumnDisplaySize(int columnNumber) {
        return 1;
    }

    @Override
    public int getPrecision(int columnNumber) {
        return 0;
    }

    @Override
    public int getScale(int columnNumber) {
        return 0;
    }

    @Override
    public boolean isAutoIncrement(int columnNumber) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int columnNumber) {
        return false;
    }

    @Override
    public boolean isCurrency(int columnNumber) {
        return false;
    }

    @Override
    public int isNullable(int columnNumber) throws SQLException {
        return this.getColumnByNumber(columnNumber).isOptional() ? 1 : 0;
    }

    @Override
    public boolean isSearchable(int columnNumber) {
        return true;
    }

    @Override
    public boolean isSigned(int columnNumber) {
        return false;
    }

    @Override
    public boolean isReadOnly(int columnNumber) {
        return false;
    }

    @Override
    public boolean isWritable(int columnNumber) {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int columnNumber) {
        return false;
    }

    @Override
    public String getCatalogName(int columnNumber) {
        return "";
    }

    @Override
    public String getSchemaName(int columnNumber) {
        return "";
    }

    @Override
    public String getTableName(int columnNumber) {
        return "";
    }

    private ADBColumn getColumnByNumber(int columnNumber) throws SQLException {
        return this.getColumnByIndex(this.toColumnIndex(columnNumber));
    }

    private int toColumnIndex(int columnNumber) throws SQLException {
        boolean ok;
        boolean bl = ok = 0 < columnNumber && columnNumber <= this.columns.size();
        if (!ok) {
            throw this.getErrorReporter().errorParameterValueNotSupported("columnNumber");
        }
        return columnNumber - 1;
    }

    ADBColumn getColumnByIndex(int idx) {
        return this.columns.get(idx);
    }

    int findColumnIndexByName(String columnName) {
        Integer idx = this.indexByName.get(columnName);
        return idx != null ? idx : -1;
    }

    private static Map<String, Integer> createIndexByName(List<ADBColumn> columns) {
        int n = columns.size();
        switch (n) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                return Collections.singletonMap(columns.get(0).getName(), 0);
            }
        }
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        for (int i = 0; i < n; ++i) {
            m.put(columns.get(i).getName(), i);
        }
        return m;
    }

    @Override
    protected ADBErrorReporter getErrorReporter() {
        return this.statement.getErrorReporter();
    }
}

