/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.source.util;

import java.lang.reflect.Method;
import org.openjdk.javax.annotation.processing.ProcessingEnvironment;
import org.openjdk.javax.lang.model.element.AnnotationMirror;
import org.openjdk.javax.lang.model.element.AnnotationValue;
import org.openjdk.javax.lang.model.element.Element;
import org.openjdk.javax.lang.model.element.ExecutableElement;
import org.openjdk.javax.lang.model.element.TypeElement;
import org.openjdk.javax.lang.model.type.DeclaredType;
import org.openjdk.javax.lang.model.type.ErrorType;
import org.openjdk.javax.lang.model.type.TypeMirror;
import org.openjdk.javax.tools.Diagnostic;
import org.openjdk.javax.tools.JavaCompiler;
import org.openjdk.source.tree.CatchTree;
import org.openjdk.source.tree.ClassTree;
import org.openjdk.source.tree.CompilationUnitTree;
import org.openjdk.source.tree.MethodTree;
import org.openjdk.source.tree.Scope;
import org.openjdk.source.tree.Tree;
import org.openjdk.source.util.SourcePositions;
import org.openjdk.source.util.TreePath;

public abstract class Trees {
    public static Trees instance(JavaCompiler.CompilationTask compilationTask) {
        String string = compilationTask.getClass().getName();
        if (!string.equals("org.openjdk.tools.javac.api.JavacTaskImpl") && !string.equals("org.openjdk.tools.javac.api.BasicJavacTask")) {
            throw new IllegalArgumentException();
        }
        return Trees.getJavacTrees(JavaCompiler.CompilationTask.class, compilationTask);
    }

    public static Trees instance(ProcessingEnvironment processingEnvironment) {
        if (!processingEnvironment.getClass().getName().equals("org.openjdk.tools.javac.processing.JavacProcessingEnvironment")) {
            throw new IllegalArgumentException();
        }
        return Trees.getJavacTrees(ProcessingEnvironment.class, processingEnvironment);
    }

    static Trees getJavacTrees(Class<?> clazz, Object object) {
        try {
            ClassLoader classLoader = object.getClass().getClassLoader();
            Class<?> clazz2 = Class.forName("org.openjdk.tools.javac.api.JavacTrees", false, classLoader);
            clazz = Class.forName(clazz.getName(), false, classLoader);
            Method method = clazz2.getMethod("instance", clazz);
            return (Trees)method.invoke(null, object);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
    }

    public abstract SourcePositions getSourcePositions();

    public abstract Tree getTree(Element var1);

    public abstract ClassTree getTree(TypeElement var1);

    public abstract MethodTree getTree(ExecutableElement var1);

    public abstract Tree getTree(Element var1, AnnotationMirror var2);

    public abstract Tree getTree(Element var1, AnnotationMirror var2, AnnotationValue var3);

    public abstract TreePath getPath(CompilationUnitTree var1, Tree var2);

    public abstract TreePath getPath(Element var1);

    public abstract TreePath getPath(Element var1, AnnotationMirror var2);

    public abstract TreePath getPath(Element var1, AnnotationMirror var2, AnnotationValue var3);

    public abstract Element getElement(TreePath var1);

    public abstract TypeMirror getTypeMirror(TreePath var1);

    public abstract Scope getScope(TreePath var1);

    public abstract String getDocComment(TreePath var1);

    public abstract boolean isAccessible(Scope var1, TypeElement var2);

    public abstract boolean isAccessible(Scope var1, Element var2, DeclaredType var3);

    public abstract TypeMirror getOriginalType(ErrorType var1);

    public abstract void printMessage(Diagnostic.Kind var1, CharSequence var2, Tree var3, CompilationUnitTree var4);

    public abstract TypeMirror getLub(CatchTree var1);
}

