/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.tree;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.openjdk.source.doctree.AttributeTree;
import org.openjdk.source.doctree.AuthorTree;
import org.openjdk.source.doctree.CommentTree;
import org.openjdk.source.doctree.DeprecatedTree;
import org.openjdk.source.doctree.DocCommentTree;
import org.openjdk.source.doctree.DocRootTree;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.source.doctree.DocTreeVisitor;
import org.openjdk.source.doctree.EndElementTree;
import org.openjdk.source.doctree.EntityTree;
import org.openjdk.source.doctree.ErroneousTree;
import org.openjdk.source.doctree.HiddenTree;
import org.openjdk.source.doctree.IdentifierTree;
import org.openjdk.source.doctree.IndexTree;
import org.openjdk.source.doctree.InheritDocTree;
import org.openjdk.source.doctree.LinkTree;
import org.openjdk.source.doctree.LiteralTree;
import org.openjdk.source.doctree.ParamTree;
import org.openjdk.source.doctree.ProvidesTree;
import org.openjdk.source.doctree.ReferenceTree;
import org.openjdk.source.doctree.ReturnTree;
import org.openjdk.source.doctree.SeeTree;
import org.openjdk.source.doctree.SerialDataTree;
import org.openjdk.source.doctree.SerialFieldTree;
import org.openjdk.source.doctree.SerialTree;
import org.openjdk.source.doctree.SinceTree;
import org.openjdk.source.doctree.StartElementTree;
import org.openjdk.source.doctree.TextTree;
import org.openjdk.source.doctree.ThrowsTree;
import org.openjdk.source.doctree.UnknownBlockTagTree;
import org.openjdk.source.doctree.UnknownInlineTagTree;
import org.openjdk.source.doctree.UsesTree;
import org.openjdk.source.doctree.ValueTree;
import org.openjdk.source.doctree.VersionTree;
import org.openjdk.tools.javac.util.Convert;

public class DocPretty
implements DocTreeVisitor<Void, Void> {
    final Writer out;
    int lmargin = 0;
    final String lineSep = System.getProperty("line.separator");

    public DocPretty(Writer writer) {
        this.out = writer;
    }

    public void print(DocTree docTree) throws IOException {
        try {
            if (docTree == null) {
                this.print("/*missing*/");
            } else {
                docTree.accept(this, null);
            }
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw new IOException(uncheckedIOException.getMessage(), uncheckedIOException);
        }
    }

    protected void print(Object object) throws IOException {
        this.out.write(Convert.escapeUnicode(object.toString()));
    }

    public void print(List<? extends DocTree> list) throws IOException {
        for (DocTree docTree : list) {
            this.print(docTree);
        }
    }

    protected void print(List<? extends DocTree> list, String string) throws IOException {
        if (list.isEmpty()) {
            return;
        }
        boolean bl = true;
        for (DocTree docTree : list) {
            if (!bl) {
                this.print(string);
            }
            this.print(docTree);
            bl = false;
        }
    }

    protected void println() throws IOException {
        this.out.write(this.lineSep);
    }

    protected void printTagName(DocTree docTree) throws IOException {
        this.out.write("@");
        this.out.write(docTree.getKind().tagName);
    }

    @Override
    public Void visitAttribute(AttributeTree attributeTree, Void void_) {
        try {
            String string;
            this.print(attributeTree.getName());
            switch (attributeTree.getValueKind()) {
                case EMPTY: {
                    string = null;
                    break;
                }
                case UNQUOTED: {
                    string = "";
                    break;
                }
                case SINGLE: {
                    string = "'";
                    break;
                }
                case DOUBLE: {
                    string = "\"";
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (string != null) {
                this.print("=" + string);
                this.print(attributeTree.getValue());
                this.print(string);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitAuthor(AuthorTree authorTree, Void void_) {
        try {
            this.printTagName(authorTree);
            this.print(" ");
            this.print(authorTree.getName());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitComment(CommentTree commentTree, Void void_) {
        try {
            this.print(commentTree.getBody());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitDeprecated(DeprecatedTree deprecatedTree, Void void_) {
        try {
            this.printTagName(deprecatedTree);
            if (!deprecatedTree.getBody().isEmpty()) {
                this.print(" ");
                this.print(deprecatedTree.getBody());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitDocComment(DocCommentTree docCommentTree, Void void_) {
        try {
            List<? extends DocTree> list = docCommentTree.getFullBody();
            List<? extends DocTree> list2 = docCommentTree.getBlockTags();
            this.print(list);
            if (!list.isEmpty() && !list2.isEmpty()) {
                this.print("\n");
            }
            this.print(list2, "\n");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitDocRoot(DocRootTree docRootTree, Void void_) {
        try {
            this.print("{");
            this.printTagName(docRootTree);
            this.print("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitEndElement(EndElementTree endElementTree, Void void_) {
        try {
            this.print("</");
            this.print(endElementTree.getName());
            this.print(">");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitEntity(EntityTree entityTree, Void void_) {
        try {
            this.print("&");
            this.print(entityTree.getName());
            this.print(";");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitErroneous(ErroneousTree erroneousTree, Void void_) {
        try {
            this.print(erroneousTree.getBody());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitHidden(HiddenTree hiddenTree, Void void_) {
        try {
            this.printTagName(hiddenTree);
            if (!hiddenTree.getBody().isEmpty()) {
                this.print(" ");
                this.print(hiddenTree.getBody());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree identifierTree, Void void_) {
        try {
            this.print(identifierTree.getName());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitIndex(IndexTree indexTree, Void void_) {
        try {
            this.print("{");
            this.printTagName(indexTree);
            this.print(" ");
            this.print(indexTree.getSearchTerm());
            if (!indexTree.getDescription().isEmpty()) {
                this.print(" ");
                this.print(indexTree.getDescription());
            }
            this.print("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitInheritDoc(InheritDocTree inheritDocTree, Void void_) {
        try {
            this.print("{");
            this.printTagName(inheritDocTree);
            this.print("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitLink(LinkTree linkTree, Void void_) {
        try {
            this.print("{");
            this.printTagName(linkTree);
            this.print(" ");
            this.print(linkTree.getReference());
            if (!linkTree.getLabel().isEmpty()) {
                this.print(" ");
                this.print(linkTree.getLabel());
            }
            this.print("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitLiteral(LiteralTree literalTree, Void void_) {
        try {
            this.print("{");
            this.printTagName(literalTree);
            String string = literalTree.getBody().getBody();
            if (!string.isEmpty() && !Character.isWhitespace(string.charAt(0))) {
                this.print(" ");
            }
            this.print(literalTree.getBody());
            this.print("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitParam(ParamTree paramTree, Void void_) {
        try {
            this.printTagName(paramTree);
            this.print(" ");
            if (paramTree.isTypeParameter()) {
                this.print("<");
            }
            this.print(paramTree.getName());
            if (paramTree.isTypeParameter()) {
                this.print(">");
            }
            if (!paramTree.getDescription().isEmpty()) {
                this.print(" ");
                this.print(paramTree.getDescription());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitProvides(ProvidesTree providesTree, Void void_) {
        try {
            this.printTagName(providesTree);
            this.print(" ");
            this.print(providesTree.getServiceType());
            if (!providesTree.getDescription().isEmpty()) {
                this.print(" ");
                this.print(providesTree.getDescription());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitReference(ReferenceTree referenceTree, Void void_) {
        try {
            this.print(referenceTree.getSignature());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitReturn(ReturnTree returnTree, Void void_) {
        try {
            this.printTagName(returnTree);
            this.print(" ");
            this.print(returnTree.getDescription());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitSee(SeeTree seeTree, Void void_) {
        try {
            this.printTagName(seeTree);
            boolean bl = true;
            boolean bl2 = true;
            for (DocTree docTree : seeTree.getReference()) {
                if (bl2) {
                    this.print(" ");
                }
                bl2 = bl && docTree instanceof ReferenceTree;
                bl = false;
                this.print(docTree);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitSerial(SerialTree serialTree, Void void_) {
        try {
            this.printTagName(serialTree);
            if (!serialTree.getDescription().isEmpty()) {
                this.print(" ");
                this.print(serialTree.getDescription());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitSerialData(SerialDataTree serialDataTree, Void void_) {
        try {
            this.printTagName(serialDataTree);
            if (!serialDataTree.getDescription().isEmpty()) {
                this.print(" ");
                this.print(serialDataTree.getDescription());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitSerialField(SerialFieldTree serialFieldTree, Void void_) {
        try {
            this.printTagName(serialFieldTree);
            this.print(" ");
            this.print(serialFieldTree.getName());
            this.print(" ");
            this.print(serialFieldTree.getType());
            if (!serialFieldTree.getDescription().isEmpty()) {
                this.print(" ");
                this.print(serialFieldTree.getDescription());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitSince(SinceTree sinceTree, Void void_) {
        try {
            this.printTagName(sinceTree);
            this.print(" ");
            this.print(sinceTree.getBody());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitStartElement(StartElementTree startElementTree, Void void_) {
        try {
            this.print("<");
            this.print(startElementTree.getName());
            List<? extends DocTree> list = startElementTree.getAttributes();
            if (!list.isEmpty()) {
                this.print(" ");
                this.print(list);
                DocTree docTree = startElementTree.getAttributes().get(list.size() - 1);
                if (startElementTree.isSelfClosing() && docTree instanceof AttributeTree && ((AttributeTree)docTree).getValueKind() == AttributeTree.ValueKind.UNQUOTED) {
                    this.print(" ");
                }
            }
            if (startElementTree.isSelfClosing()) {
                this.print("/");
            }
            this.print(">");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitText(TextTree textTree, Void void_) {
        try {
            this.print(textTree.getBody());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitThrows(ThrowsTree throwsTree, Void void_) {
        try {
            this.printTagName(throwsTree);
            this.print(" ");
            this.print(throwsTree.getExceptionName());
            if (!throwsTree.getDescription().isEmpty()) {
                this.print(" ");
                this.print(throwsTree.getDescription());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitUnknownBlockTag(UnknownBlockTagTree unknownBlockTagTree, Void void_) {
        try {
            this.print("@");
            this.print(unknownBlockTagTree.getTagName());
            this.print(" ");
            this.print(unknownBlockTagTree.getContent());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitUnknownInlineTag(UnknownInlineTagTree unknownInlineTagTree, Void void_) {
        try {
            this.print("{");
            this.print("@");
            this.print(unknownInlineTagTree.getTagName());
            this.print(" ");
            this.print(unknownInlineTagTree.getContent());
            this.print("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitUses(UsesTree usesTree, Void void_) {
        try {
            this.printTagName(usesTree);
            this.print(" ");
            this.print(usesTree.getServiceType());
            if (!usesTree.getDescription().isEmpty()) {
                this.print(" ");
                this.print(usesTree.getDescription());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitValue(ValueTree valueTree, Void void_) {
        try {
            this.print("{");
            this.printTagName(valueTree);
            if (valueTree.getReference() != null) {
                this.print(" ");
                this.print(valueTree.getReference());
            }
            this.print("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitVersion(VersionTree versionTree, Void void_) {
        try {
            this.printTagName(versionTree);
            this.print(" ");
            this.print(versionTree.getBody());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitOther(DocTree docTree, Void void_) {
        try {
            this.print("(UNKNOWN: " + docTree + ")");
            this.println();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    private static class UncheckedIOException
    extends Error {
        static final long serialVersionUID = -4032692679158424751L;

        UncheckedIOException(IOException iOException) {
            super(iOException.getMessage(), iOException);
        }
    }
}

