/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import org.jibx.binding.model.ModelVisitor;
import org.jibx.binding.model.StructureElementBase;
import org.jibx.binding.model.ValidationContext;
import org.jibx.binding.model.ValueElement;

class SequenceVisitor
extends ModelVisitor {
    private final StructureElementBase m_baseStructure;
    private final ValidationContext m_validationContext;
    private boolean m_isTextAllowed;

    public SequenceVisitor(StructureElementBase base, ValidationContext vctx) {
        this.m_baseStructure = base;
        this.m_validationContext = vctx;
        this.m_isTextAllowed = true;
    }

    @Override
    public boolean visit(StructureElementBase node) {
        if (node != this.m_baseStructure && node.hasName()) {
            this.m_isTextAllowed = !node.isOptional();
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(ValueElement node) {
        switch (node.getStyle()) {
            case 2: 
            case 3: {
                if (this.m_isTextAllowed) {
                    this.m_isTextAllowed = false;
                    break;
                }
                this.m_validationContext.addError("Text value must be preceded by required element", node);
                break;
            }
            case 1: {
                this.m_isTextAllowed = !node.isOptional();
                break;
            }
        }
        return false;
    }

    @Override
    public void exit(StructureElementBase node) {
        if (node.hasName()) {
            this.m_isTextAllowed = !node.isOptional();
        }
    }
}

