/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.classloader;

import java.beans.Introspector;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.commons.logging.LogFactory;

public class MultiParentClassLoader
extends URLClassLoader {
    private final ClassLoader[] parents;
    private final boolean inverseClassLoading;
    private final String[] hiddenClasses;
    private final String[] nonOverridableClasses;
    private final String[] hiddenResources;
    private final String[] nonOverridableResources;
    private boolean destroyed = false;

    public MultiParentClassLoader(URL[] urls) {
        super(urls);
        this.parents = new ClassLoader[]{ClassLoader.getSystemClassLoader()};
        this.inverseClassLoading = false;
        this.hiddenClasses = new String[0];
        this.nonOverridableClasses = new String[0];
        this.hiddenResources = new String[0];
        this.nonOverridableResources = new String[0];
    }

    public MultiParentClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, new ClassLoader[]{parent});
    }

    public MultiParentClassLoader(URL[] urls, ClassLoader parent, boolean inverseClassLoading, String[] hiddenClasses, String[] nonOverridableClasses) {
        this(urls, new ClassLoader[]{parent}, inverseClassLoading, hiddenClasses, nonOverridableClasses);
    }

    public MultiParentClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this(urls, new ClassLoader[]{parent}, factory);
    }

    public MultiParentClassLoader(URL[] urls, ClassLoader[] parents) {
        super(urls);
        this.parents = MultiParentClassLoader.copyParents(parents);
        this.inverseClassLoading = false;
        this.hiddenClasses = new String[0];
        this.nonOverridableClasses = new String[0];
        this.hiddenResources = new String[0];
        this.nonOverridableResources = new String[0];
    }

    public MultiParentClassLoader(URL[] urls, ClassLoader[] parents, boolean inverseClassLoading, Collection hiddenClasses, Collection nonOverridableClasses) {
        this(urls, parents, inverseClassLoading, hiddenClasses.toArray(new String[hiddenClasses.size()]), nonOverridableClasses.toArray(new String[nonOverridableClasses.size()]));
    }

    public MultiParentClassLoader(URL[] urls, ClassLoader[] parents, boolean inverseClassLoading, String[] hiddenClasses, String[] nonOverridableClasses) {
        super(urls);
        this.parents = MultiParentClassLoader.copyParents(parents);
        this.inverseClassLoading = inverseClassLoading;
        this.hiddenClasses = hiddenClasses;
        this.nonOverridableClasses = nonOverridableClasses;
        this.hiddenResources = this.toResources(hiddenClasses);
        this.nonOverridableResources = this.toResources(nonOverridableClasses);
    }

    public MultiParentClassLoader(MultiParentClassLoader source) {
        this(source.getURLs(), MultiParentClassLoader.deepCopyParents(source.parents), source.inverseClassLoading, source.hiddenClasses, source.nonOverridableClasses);
    }

    static ClassLoader copy(ClassLoader source) {
        if (source instanceof MultiParentClassLoader) {
            return new MultiParentClassLoader((MultiParentClassLoader)source);
        }
        if (source instanceof URLClassLoader) {
            return new URLClassLoader(((URLClassLoader)source).getURLs(), source.getParent());
        }
        return new URLClassLoader(new URL[0], source);
    }

    ClassLoader copy() {
        return MultiParentClassLoader.copy(this);
    }

    private String[] toResources(String[] classes) {
        String[] resources = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            String className = classes[i];
            resources[i] = className.replace('.', '/');
        }
        return resources;
    }

    public MultiParentClassLoader(URL[] urls, ClassLoader[] parents, URLStreamHandlerFactory factory) {
        super(urls, null, factory);
        this.parents = MultiParentClassLoader.copyParents(parents);
        this.inverseClassLoading = false;
        this.hiddenClasses = new String[0];
        this.nonOverridableClasses = new String[0];
        this.hiddenResources = new String[0];
        this.nonOverridableResources = new String[0];
    }

    private static ClassLoader[] copyParents(ClassLoader[] parents) {
        ClassLoader[] newParentsArray = new ClassLoader[parents.length];
        for (int i = 0; i < parents.length; ++i) {
            ClassLoader parent = parents[i];
            if (parent == null) {
                throw new RuntimeException("parent[" + i + "] is null");
            }
            newParentsArray[i] = parent;
        }
        return newParentsArray;
    }

    private static ClassLoader[] deepCopyParents(ClassLoader[] parents) {
        ClassLoader[] newParentsArray = new ClassLoader[parents.length];
        for (int i = 0; i < parents.length; ++i) {
            ClassLoader parent = parents[i];
            if (parent == null) {
                throw new RuntimeException("parent[" + i + "] is null");
            }
            if (parent instanceof MultiParentClassLoader) {
                parent = ((MultiParentClassLoader)parent).copy();
            }
            newParentsArray[i] = parent;
        }
        return newParentsArray;
    }

    public ClassLoader[] getParents() {
        return this.parents;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cachedClass = this.findLoadedClass(name);
        if (cachedClass != null) {
            return this.resolveClass(cachedClass, resolve);
        }
        if (this.inverseClassLoading && !this.isDestroyed() && !this.isNonOverridableClass(name)) {
            try {
                Class<?> clazz = this.findClass(name);
                return this.resolveClass(clazz, resolve);
            }
            catch (ClassNotFoundException clazz) {
                // empty catch block
            }
        }
        if (!this.isHiddenClass(name)) {
            for (int i = 0; i < this.parents.length; ++i) {
                ClassLoader parent = this.parents[i];
                try {
                    Class<?> clazz = parent.loadClass(name);
                    return this.resolveClass(clazz, resolve);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
            }
        }
        if (!this.isDestroyed()) {
            try {
                Class<?> clazz = this.findClass(name);
                return this.resolveClass(clazz, resolve);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    private boolean isNonOverridableClass(String name) {
        for (int i = 0; i < this.nonOverridableClasses.length; ++i) {
            if (!name.startsWith(this.nonOverridableClasses[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isHiddenClass(String name) {
        for (int i = 0; i < this.hiddenClasses.length; ++i) {
            if (!name.startsWith(this.hiddenClasses[i])) continue;
            return true;
        }
        return false;
    }

    private Class resolveClass(Class clazz, boolean resolve) {
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        URL url;
        if (this.isDestroyed()) {
            return null;
        }
        if (this.inverseClassLoading && !this.isDestroyed() && !this.isNonOverridableResource(name) && (url = this.findResource(name)) != null) {
            return url;
        }
        if (!this.isHiddenResource(name)) {
            for (int i = 0; i < this.parents.length; ++i) {
                ClassLoader parent = this.parents[i];
                URL url2 = parent.getResource(name);
                if (url2 == null) continue;
                return url2;
            }
        }
        if (!this.isDestroyed()) {
            return this.findResource(name);
        }
        return null;
    }

    public Enumeration findResources(String name) throws IOException {
        if (this.isDestroyed()) {
            return Collections.enumeration(Collections.EMPTY_SET);
        }
        ArrayList<URL> resources = new ArrayList<URL>();
        if (this.inverseClassLoading && !this.isDestroyed()) {
            ArrayList<URL> myResources = Collections.list(super.findResources(name));
            resources.addAll(myResources);
        }
        for (int i = 0; i < this.parents.length; ++i) {
            ClassLoader parent = this.parents[i];
            ArrayList<URL> parentResources = Collections.list(parent.getResources(name));
            resources.addAll(parentResources);
        }
        if (!this.inverseClassLoading && !this.isDestroyed()) {
            ArrayList<URL> myResources = Collections.list(super.findResources(name));
            resources.addAll(myResources);
        }
        return Collections.enumeration(resources);
    }

    private boolean isNonOverridableResource(String name) {
        for (int i = 0; i < this.nonOverridableResources.length; ++i) {
            if (!name.startsWith(this.nonOverridableResources[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isHiddenResource(String name) {
        for (int i = 0; i < this.hiddenResources.length; ++i) {
            if (!name.startsWith(this.hiddenResources[i])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[" + this.getClass().getName() + "]";
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        MultiParentClassLoader multiParentClassLoader = this;
        synchronized (multiParentClassLoader) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        LogFactory.release((ClassLoader)this);
        Introspector.flushCaches();
    }
}

