/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.corba.idl.parser;

import antlr.collections.AST;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.axis2.corba.exceptions.InvalidIDLException;
import org.apache.axis2.corba.idl.parser.ExpressionUtil;
import org.apache.axis2.corba.idl.types.AbstractCollectionType;
import org.apache.axis2.corba.idl.types.AnyType;
import org.apache.axis2.corba.idl.types.ArrayType;
import org.apache.axis2.corba.idl.types.ConstType;
import org.apache.axis2.corba.idl.types.DataType;
import org.apache.axis2.corba.idl.types.EnumType;
import org.apache.axis2.corba.idl.types.ExceptionType;
import org.apache.axis2.corba.idl.types.FixedType;
import org.apache.axis2.corba.idl.types.IDL;
import org.apache.axis2.corba.idl.types.Interface;
import org.apache.axis2.corba.idl.types.Member;
import org.apache.axis2.corba.idl.types.Operation;
import org.apache.axis2.corba.idl.types.PrimitiveDataType;
import org.apache.axis2.corba.idl.types.SequenceType;
import org.apache.axis2.corba.idl.types.Struct;
import org.apache.axis2.corba.idl.types.Typedef;
import org.apache.axis2.corba.idl.types.UnionMember;
import org.apache.axis2.corba.idl.types.UnionType;
import org.apache.axis2.corba.idl.types.ValueType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IDLVisitor {
    private static final Log log = LogFactory.getLog(IDLVisitor.class);
    private IDL idl = new IDL();
    private String module = "";
    private String moduleForInnerTypes = null;
    private static final String INNERTYPE_SUFFIX = "Package";

    public IDL getIDL() {
        return this.idl;
    }

    public void setIDL(IDL idl) {
        this.idl = idl;
    }

    public void visit(AST node) throws InvalidIDLException {
        while (node != null) {
            switch (node.getType()) {
                case 7: {
                    this.idl.addInterface(this.visitInterface(node));
                    break;
                }
                case 11: {
                    AST moduleName = node.getFirstChild();
                    IDLVisitor moduleVisitor = new IDLVisitor();
                    moduleVisitor.setIDL(this.idl);
                    moduleVisitor.setModule(this.module + moduleName);
                    moduleVisitor.visit(moduleName.getNextSibling());
                    this.idl.addIDL(moduleVisitor.getIDL());
                    break;
                }
                case 55: {
                    this.idl.addType(this.visitStruct(node));
                    break;
                }
                case 9: {
                    this.idl.addType(this.visitValueType(node));
                    break;
                }
                case 68: {
                    this.idl.addType(this.visitException(node));
                    break;
                }
                case 60: {
                    this.idl.addType(this.visitEnum(node));
                    break;
                }
                case 56: {
                    this.idl.addType(this.visitUnion(node));
                    break;
                }
                case 42: {
                    this.visitAndAddTypedefs(node, this.module);
                    break;
                }
                case 27: {
                    this.idl.addType(this.visitConst(node));
                    break;
                }
                default: {
                    throw new InvalidIDLException("Unsupported IDL token " + node);
                }
            }
            node = node.getNextSibling();
        }
    }

    private Struct visitStruct(AST node) throws InvalidIDLException {
        AST structNode = node.getFirstChild();
        String structName = structNode.toString();
        Struct struct = new Struct();
        struct.setModule(this.module);
        struct.setName(structName);
        AST memberTypeNode = structNode.getNextSibling();
        while (memberTypeNode != null) {
            Member member = new Member();
            DataType dataType = this.findDataType(memberTypeNode, structName);
            AST memberNode = memberTypeNode.getNextSibling();
            String memberName = memberNode.getText();
            int dimensions = memberNode.getNumberOfChildren();
            if (dimensions > 0) {
                AbstractCollectionType arrayType = null;
                ArrayType rootArrayType = null;
                int i = 1;
                for (AST dimensionNode = memberNode.getFirstChild(); dimensionNode != null; dimensionNode = dimensionNode.getNextSibling()) {
                    ArrayType temp = new ArrayType();
                    temp.setElementModule(this.module);
                    temp.setElementName(memberName);
                    temp.setDepth(i);
                    ++i;
                    if (arrayType != null) {
                        arrayType.setDataType(temp);
                    } else {
                        rootArrayType = temp;
                    }
                    arrayType = temp;
                    arrayType.setElementCount(Integer.parseInt(dimensionNode.getText()));
                }
                if (arrayType != null) {
                    arrayType.setDataType(dataType);
                }
                Typedef typedef = new Typedef();
                typedef.setDataType(rootArrayType);
                typedef.setModule(this.module);
                typedef.setName(structName + '_' + memberName);
                this.idl.addType(typedef);
                dataType = typedef;
            }
            member.setDataType(dataType);
            member.setName(memberName);
            struct.addMember(member);
            memberTypeNode = memberNode.getNextSibling();
        }
        return struct;
    }

    private ValueType visitValueType(AST node) throws InvalidIDLException {
        AST valueNode = node.getFirstChild();
        ValueType value = new ValueType();
        value.setModule(this.module);
        String valueName = valueNode.toString();
        value.setName(valueName);
        AST memberModifierNode = valueNode.getNextSibling();
        while (memberModifierNode != null) {
            String memberModifierName = memberModifierNode.toString();
            if (!memberModifierName.equals("private") && !memberModifierName.equals("public")) {
                if (14 == memberModifierNode.getType()) {
                    String[] pragma;
                    if (memberModifierName.startsWith("pragma ID ") && (pragma = (memberModifierName = memberModifierName.substring(10)).split(" ")).length == 2 && pragma[0] != null && pragma[1] != null && pragma[0].equals(value.getName())) {
                        pragma[1] = pragma[1].replace('\"', ' ');
                        value.setId(pragma[1].trim());
                    }
                } else {
                    value.addOperation(this.visitOperation(memberModifierNode));
                }
                memberModifierNode = memberModifierNode.getNextSibling();
                continue;
            }
            Member memberType = new Member();
            memberType.setModifier(memberModifierName);
            AST memberTypeNode = memberModifierNode.getNextSibling();
            memberType.setDataType(this.findDataType(memberTypeNode, valueName));
            AST memberNode = memberTypeNode.getNextSibling();
            memberType.setName(memberNode.toString());
            value.addMember(memberType);
            memberModifierNode = memberNode.getNextSibling();
        }
        return value;
    }

    private Interface visitInterface(AST node) throws InvalidIDLException {
        Interface intf = new Interface();
        intf.setModule(this.module);
        AST interfaceNode = node.getFirstChild();
        String interfaceName = interfaceNode.toString();
        intf.setName(interfaceName);
        this.moduleForInnerTypes = this.module + interfaceName + INNERTYPE_SUFFIX + "::";
        block10: for (AST node2 = interfaceNode.getNextSibling(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getType()) {
                case 55: {
                    Struct innerStruct = this.visitStruct(node2);
                    innerStruct.setModule(this.moduleForInnerTypes);
                    this.idl.addType(innerStruct);
                    continue block10;
                }
                case 9: {
                    log.error((Object)("Unsupported IDL token " + node2));
                    continue block10;
                }
                case 68: {
                    ExceptionType innerEx = this.visitException(node2);
                    innerEx.setModule(this.moduleForInnerTypes);
                    this.idl.addType(innerEx);
                    continue block10;
                }
                case 60: {
                    EnumType innerEnum = this.visitEnum(node2);
                    innerEnum.setModule(this.moduleForInnerTypes);
                    this.idl.addType(innerEnum);
                    continue block10;
                }
                case 56: {
                    UnionType innerUnion = this.visitUnion(node2);
                    innerUnion.setModule(this.moduleForInnerTypes);
                    this.idl.addType(innerUnion);
                    continue block10;
                }
                case 42: {
                    this.visitAndAddTypedefs(node2, this.moduleForInnerTypes);
                    continue block10;
                }
                case 27: {
                    log.error((Object)("Unsupported IDL token " + node2));
                    continue block10;
                }
                case 81: {
                    intf.addOperation(this.visitGetAttribute(node2));
                    intf.addOperation(this.visitSetAttribute(node2));
                    continue block10;
                }
                default: {
                    if (node2.toString().startsWith("pragma ID ")) {
                        String pragmaId = node2.toString().substring(10);
                        String[] pragma = pragmaId.split(" ");
                        if (pragma.length != 2 || pragma[0] == null || pragma[1] == null || !pragma[0].equals(intf.getName())) continue block10;
                        pragma[1] = pragma[1].replace('\"', ' ');
                        intf.setId(pragma[1].trim());
                        continue block10;
                    }
                    intf.addOperation(this.visitOperation(node2));
                }
            }
        }
        this.moduleForInnerTypes = null;
        return intf;
    }

    private Operation visitGetAttribute(AST node) throws InvalidIDLException {
        Operation operation = new Operation();
        AST type = node.getFirstChild();
        AST name = type.getNextSibling();
        String attrName = name.toString();
        operation.setReturnType(this.findDataType(type, attrName));
        operation.setName("_get_" + attrName);
        return operation;
    }

    private Operation visitSetAttribute(AST node) throws InvalidIDLException {
        Operation operation = new Operation();
        AST type = node.getFirstChild();
        operation.setReturnType(PrimitiveDataType.getPrimitiveDataType("void"));
        AST name = type.getNextSibling();
        String attrName = name.toString();
        operation.setName("_set_" + attrName);
        Member param = new Member();
        param.setName(attrName);
        param.setDataType(this.findDataType(type, attrName));
        operation.addParam(param);
        return operation;
    }

    private Operation visitOperation(AST node) throws InvalidIDLException {
        Operation operation = new Operation();
        String opName = node.toString();
        operation.setName(opName);
        AST type = node.getFirstChild();
        operation.setReturnType(this.findDataType(type, opName));
        for (AST mode = type.getNextSibling(); mode != null; mode = mode.getNextSibling()) {
            if (73 == mode.getType()) {
                for (AST idlType = mode.getFirstChild(); idlType != null; idlType = idlType.getNextSibling()) {
                    operation.addRaises((ExceptionType)this.findDataType(idlType, opName));
                }
                continue;
            }
            Member param = new Member();
            param.setMode(mode.toString());
            AST idlType = mode.getFirstChild();
            AST paramName = idlType.getNextSibling();
            String paramNameStr = paramName.toString();
            param.setDataType(this.findDataType(idlType, paramNameStr));
            param.setName(paramNameStr);
            operation.addParam(param);
        }
        return operation;
    }

    private ExceptionType visitException(AST node) throws InvalidIDLException {
        ExceptionType raisesType = new ExceptionType();
        AST exNode = node.getFirstChild();
        String exName = exNode.toString();
        raisesType.setModule(this.module);
        raisesType.setName(exName);
        AST memberTypeNode = exNode.getNextSibling();
        while (memberTypeNode != null) {
            Member member = new Member();
            member.setDataType(this.findDataType(memberTypeNode, exName));
            AST memberNode = memberTypeNode.getNextSibling();
            member.setName(memberNode.toString());
            raisesType.addMember(member);
            memberTypeNode = memberNode.getNextSibling();
        }
        return raisesType;
    }

    private DataType findDataType(AST typeNode, String parentName) throws InvalidIDLException {
        return this.findDataType(typeNode, parentName, true, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataType findDataType(AST typeNode, String parentName, boolean root, boolean isInsideATypeDef) throws InvalidIDLException {
        String typeName;
        if (typeNode.getType() == 61) {
            SequenceType sequenceType = this.visitAnonymousSequence(typeNode, parentName, root);
            if (isInsideATypeDef) {
                return sequenceType;
            }
            Typedef typedef = new Typedef();
            typedef.setDataType(sequenceType);
            typedef.setModule(this.module);
            typedef.setName(parentName + '_' + sequenceType.getName());
            this.idl.addType(typedef);
            return typedef;
        }
        if (typeNode.getType() == 48) {
            AST nextNode = typeNode.getNextSibling();
            if (nextNode == null) {
                throw new InvalidIDLException("'unsigned' without a data type");
            }
            if (nextNode.getType() == 47) {
                typeNode.setNextSibling(nextNode.getNextSibling());
                typeNode.setFirstChild(nextNode.getFirstChild());
                typeName = "ushort";
                return this.getDataType(typeName);
            } else {
                if (nextNode.getType() != 46) throw new InvalidIDLException("either 'long' or 'short' is expected after the 'unsigned' keyword");
                AST nextToLong = nextNode.getNextSibling();
                if (nextToLong != null && nextToLong.getType() == 46) {
                    typeNode.setNextSibling(nextToLong.getNextSibling());
                    typeNode.setFirstChild(nextToLong.getFirstChild());
                    typeName = "ulonglong";
                    return this.getDataType(typeName);
                } else {
                    typeNode.setNextSibling(nextNode.getNextSibling());
                    typeNode.setFirstChild(nextNode.getFirstChild());
                    typeName = "ulong";
                }
            }
            return this.getDataType(typeName);
        } else if (typeNode.getType() == 46) {
            AST nextToLong = typeNode.getNextSibling();
            if (nextToLong != null && nextToLong.getType() == 46) {
                typeNode.setNextSibling(nextToLong.getNextSibling());
                typeNode.setFirstChild(nextToLong.getFirstChild());
                typeName = "longlong";
                return this.getDataType(typeName);
            } else {
                typeName = "long";
            }
            return this.getDataType(typeName);
        } else {
            if (typeNode.getType() == 55) {
                String innerModule = this.module + parentName + INNERTYPE_SUFFIX + "::";
                Struct innerElem = this.visitStruct(typeNode);
                innerElem.setModule(innerModule);
                this.idl.addType(innerElem);
                return innerElem;
            }
            if (typeNode.getType() == 9) {
                String innerModule = this.module + parentName + INNERTYPE_SUFFIX + "::";
                ValueType innerElem = this.visitValueType(typeNode);
                innerElem.setModule(innerModule);
                this.idl.addType(innerElem);
                return innerElem;
            }
            if (typeNode.getType() == 68) {
                String innerModule = this.module + parentName + INNERTYPE_SUFFIX + "::";
                ExceptionType innerElem = this.visitException(typeNode);
                innerElem.setModule(innerModule);
                this.idl.addType(innerElem);
                return innerElem;
            }
            if (typeNode.getType() == 60) {
                String innerModule = this.module + parentName + INNERTYPE_SUFFIX + "::";
                EnumType innerElem = this.visitEnum(typeNode);
                innerElem.setModule(innerModule);
                this.idl.addType(innerElem);
                return innerElem;
            }
            if (typeNode.getType() == 56) {
                String innerModule = this.module + parentName + INNERTYPE_SUFFIX + "::";
                UnionType innerElem = this.visitUnion(typeNode);
                innerElem.setModule(innerModule);
                this.idl.addType(innerElem);
                return innerElem;
            }
            if (typeNode.getType() == 75) {
                AST digitsNode = typeNode.getFirstChild();
                short digits = 0;
                short scale = 0;
                if (digitsNode != null) {
                    AST scaleNode = digitsNode.getNextSibling();
                    digits = Short.parseShort(digitsNode.getText());
                    scale = Short.parseShort(scaleNode.getText());
                }
                FixedType fixedType = new FixedType(digits, scale);
                if (isInsideATypeDef) {
                    return fixedType;
                }
                Typedef typedef = new Typedef();
                typedef.setDataType(fixedType);
                typedef.setModule(this.module);
                String name = typeNode.getNextSibling().getText();
                typedef.setName(parentName + '_' + name);
                this.idl.addType(typedef);
                return typedef;
            }
            typeName = this.getTypeName(typeNode);
        }
        return this.getDataType(typeName);
    }

    DataType getDataType(String typeName) throws InvalidIDLException {
        DataType dataType = null;
        Map compositeDataTypes = this.idl.getCompositeDataTypes();
        if (compositeDataTypes != null) {
            if (this.moduleForInnerTypes != null && !typeName.startsWith(this.module)) {
                dataType = (DataType)compositeDataTypes.get(this.moduleForInnerTypes + typeName);
            }
            String tempModule = this.module;
            int modSepLen = "::".length();
            while (dataType == null && (dataType = (DataType)this.idl.getCompositeDataTypes().get(tempModule + typeName)) == null && tempModule.length() > 0) {
                int modSepPos;
                if (tempModule.endsWith("::")) {
                    tempModule = tempModule.substring(0, tempModule.length() - modSepLen);
                }
                if ((modSepPos = tempModule.lastIndexOf("::")) < 0) {
                    tempModule = "";
                    continue;
                }
                tempModule = tempModule.substring(0, modSepPos + modSepLen);
            }
        }
        if (dataType == null) {
            dataType = PrimitiveDataType.getPrimitiveDataType(typeName);
        }
        if (dataType == null && "any".equals(typeName)) {
            dataType = new AnyType();
        }
        if (dataType == null) {
            throw new InvalidIDLException("Invalid data type: " + typeName);
        }
        return dataType;
    }

    public String getTypeName(AST node) {
        String typeName = node.getText();
        for (AST memberTypeNodeChild = node.getFirstChild(); memberTypeNodeChild != null; memberTypeNodeChild = memberTypeNodeChild.getNextSibling()) {
            typeName = typeName + "::" + memberTypeNodeChild.toString();
        }
        return typeName;
    }

    public void setModule(String module) {
        if (module == null || module.length() < 1) {
            module = "";
        } else if (!module.endsWith("::")) {
            module = module + "::";
        }
        this.module = module;
    }

    private EnumType visitEnum(AST node) {
        AST enumNode = node.getFirstChild();
        String enumName = enumNode.toString();
        EnumType enumType = new EnumType();
        enumType.setModule(this.module);
        enumType.setName(enumName);
        for (AST memberTypeNode = enumNode.getNextSibling(); memberTypeNode != null; memberTypeNode = memberTypeNode.getNextSibling()) {
            enumType.addEnumMember(memberTypeNode.toString());
        }
        return enumType;
    }

    private UnionType visitUnion(AST node) throws InvalidIDLException {
        UnionType unionType = new UnionType();
        AST unNode = node.getFirstChild();
        String unName = unNode.toString();
        unionType.setModule(this.module);
        unionType.setName(unName);
        AST switchTypeNode = unNode.getNextSibling();
        DataType discrimType = this.findDataType(switchTypeNode, unName);
        unionType.setDiscriminatorType(discrimType);
        for (AST caseOrDefaultNode = switchTypeNode.getNextSibling(); caseOrDefaultNode != null; caseOrDefaultNode = caseOrDefaultNode.getNextSibling()) {
            AST typeNode;
            UnionMember unionMember = new UnionMember();
            if (59 == caseOrDefaultNode.getType()) {
                unionMember.setDefault(true);
                typeNode = caseOrDefaultNode.getFirstChild();
            } else {
                unionMember.setDefault(false);
                AST caseValueNode = caseOrDefaultNode.getFirstChild();
                String caseNodeText = caseValueNode.getText();
                if (!(discrimType instanceof EnumType) && 18 == caseValueNode.getType()) {
                    DataType constType = this.getDataType(caseNodeText);
                    if (constType instanceof ConstType) {
                        caseNodeText = ((ConstType)constType).getValue().toString();
                    } else {
                        throw new InvalidIDLException(caseNodeText + "is not a constant name");
                    }
                }
                unionMember.setDiscriminatorValue(caseNodeText);
                typeNode = caseValueNode.getNextSibling();
            }
            unionMember.setDataType(this.findDataType(typeNode, unName));
            AST memberNode = typeNode.getNextSibling();
            unionMember.setName(memberNode.toString());
            unionType.addMember(unionMember);
        }
        return unionType;
    }

    private void visitAndAddTypedefs(AST node, String moduleName) throws InvalidIDLException {
        AST typedefNameNode;
        AST typedefNode = node.getFirstChild();
        DataType dataType = this.findDataType(typedefNode, null, true, true);
        String typedefName = typedefNameNode.toString();
        for (typedefNameNode = typedefNode.getNextSibling(); typedefNameNode != null; typedefNameNode = typedefNameNode.getNextSibling()) {
            int dimensions = typedefNameNode.getNumberOfChildren();
            if (dimensions > 0) {
                AbstractCollectionType arrayType = null;
                ArrayType rootArrayType = null;
                int i = 1;
                for (AST dimensionNode = typedefNameNode.getFirstChild(); dimensionNode != null; dimensionNode = dimensionNode.getNextSibling()) {
                    ArrayType temp = new ArrayType();
                    temp.setElementModule(moduleName);
                    temp.setElementName(typedefName);
                    temp.setDepth(i);
                    ++i;
                    if (arrayType != null) {
                        arrayType.setDataType(temp);
                    } else {
                        rootArrayType = temp;
                    }
                    arrayType = temp;
                    arrayType.setElementCount(Integer.parseInt(dimensionNode.getText()));
                }
                if (arrayType != null) {
                    arrayType.setDataType(dataType);
                }
                dataType = rootArrayType;
            }
            Typedef typedef = new Typedef();
            typedef.setDataType(dataType);
            typedef.setModule(moduleName);
            typedef.setName(typedefName);
            this.idl.addType(typedef);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SequenceType visitAnonymousSequence(AST node, String parentName, boolean root) throws InvalidIDLException {
        AST countNode;
        AST typeNode = node.getFirstChild();
        SequenceType sequenceType = new SequenceType();
        DataType dataType = this.findDataType(typeNode, parentName, false, false);
        sequenceType.setDataType(dataType);
        sequenceType.setElementModule(this.module);
        AST elementNode = node.getNextSibling();
        if (elementNode != null && root) {
            String elementName = elementNode.getText();
            sequenceType.setName(elementName);
            SequenceType tempSeqType = sequenceType;
            int i = 1;
            while (true) {
                tempSeqType.setElementName(elementName);
                tempSeqType.setDepth(i);
                ++i;
                DataType tempDataType = tempSeqType.getDataType();
                if (!(tempDataType instanceof SequenceType)) break;
                tempSeqType = (SequenceType)tempDataType;
            }
        }
        if ((countNode = typeNode.getNextSibling()) != null) {
            int count;
            if (18 == countNode.getType()) {
                String constName = countNode.getText();
                DataType constType = this.getDataType(constName);
                if (!(constType instanceof ConstType)) throw new InvalidIDLException(constName + "is not a constant name");
                Object countValue = ((ConstType)constType).getValue();
                if (!(countValue instanceof Integer)) throw new InvalidIDLException(constName + "is not a long");
                count = (Integer)countValue;
            } else {
                count = Integer.parseInt(countNode.getText());
            }
            sequenceType.setElementCount(count);
            return sequenceType;
        } else {
            sequenceType.setElementCount(0);
        }
        return sequenceType;
    }

    private ConstType visitConst(AST node) throws InvalidIDLException {
        AST constNameNode;
        AST constTypeNode = node.getFirstChild();
        for (constNameNode = constTypeNode.getNextSibling(); constNameNode != null && 18 != constNameNode.getType(); constNameNode = constNameNode.getNextSibling()) {
        }
        if (constNameNode == null) {
            throw new InvalidIDLException("Constant name not found");
        }
        String constName = constNameNode.toString();
        ConstType constType = new ConstType();
        constType.setModule(this.module);
        constType.setName(constName);
        DataType type = this.findDataType(constTypeNode, constName, true, true);
        constType.setDataType(type);
        AST constValueNode = constNameNode.getNextSibling();
        constType.setValue(ExpressionUtil.eval(constValueNode, type, this));
        if (type instanceof FixedType) {
            Object value;
            FixedType fixedType = (FixedType)type;
            if (fixedType.getDigits() == 0 && fixedType.getScale() == 0) {
                value = constValueNode.getText().trim();
                short digits = (short)((String)value).replace(".", "").length();
                int index = ((String)value).indexOf(46);
                short scale = (short)(index > -1 ? digits - index : 0);
                fixedType.setDigits(digits);
                fixedType.setScale(scale);
            }
            value = (BigDecimal)constType.getValue();
            value = ((BigDecimal)value).setScale((int)fixedType.getDigits(), fixedType.getDigits());
            constType.setValue(value);
        }
        return constType;
    }
}

