/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import javax.xml.namespace.QName;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNSAwareAttribute;
import org.apache.axiom.core.CoreNamedNode;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreTypedAttribute;
import org.apache.axiom.core.NodeType;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.common.NSUtil;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.common.builder.OMNamespaceCache;
import org.apache.axiom.om.impl.intf.AxiomAttribute;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.AxiomNamedInformationItem;
import org.apache.axiom.om.impl.intf.AxiomSourcedElement;
import org.apache.axiom.om.impl.llom.CoreAttributeImpl;
import org.apache.axiom.util.xml.QNameCache;

public final class AxiomAttributeImpl
extends CoreAttributeImpl
implements AxiomAttribute,
OMAttribute,
CoreNSAwareAttribute,
AxiomNamedInformationItem {
    private String type;
    private OMNamespace namespace;
    private String localName;

    public final OMElement getOwner() {
        return (OMElement)this.coreGetOwnerElement();
    }

    @Override
    public void beforeSetLocalName() {
    }

    public final void setNamespace(OMNamespace namespace, boolean decl) {
        this.internalSetNamespace(NSUtil.handleNamespace((AxiomElement)this.getOwner(), namespace, true, decl));
    }

    public final void setOMNamespace(OMNamespace omNamespace) {
        this.internalSetNamespace(omNamespace);
    }

    public final String getAttributeValue() {
        try {
            return this.coreGetCharacterData().toString();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final void setAttributeValue(String value) {
        try {
            this.coreSetCharacterData(value, AxiomSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final String getAttributeType() {
        return this.coreGetType();
    }

    public final void setAttributeType(String type) {
        this.coreSetType(type);
    }

    public final void build() {
    }

    @Override
    public final String coreGetType() {
        return this.type;
    }

    @Override
    public final void coreSetType(String type) {
        this.type = type;
    }

    @Override
    public final <T> void init(ClonePolicy<T> policy, T options, CoreNode other) {
        CoreTypedAttribute o = (CoreTypedAttribute)other;
        this.initName(o);
        this.coreSetType(o.coreGetType());
    }

    @Override
    public final NodeType coreGetNodeType() {
        return NodeType.NS_AWARE_ATTRIBUTE;
    }

    @Override
    public final void internalSerialize(XmlHandler handler, boolean cache) throws CoreModelException, StreamException {
        handler.processAttribute(this.coreGetNamespaceURI(), this.coreGetLocalName(), this.coreGetPrefix(), this.coreGetCharacterData().toString(), this.coreGetType(), this.coreGetSpecified());
    }

    @Override
    public final void initName(String namespaceURI, String localName, String prefix, Object namespaceHelper) {
        this.localName = localName;
        this.namespace = ((OMNamespaceCache)namespaceHelper).getOMNamespace(namespaceURI, prefix);
    }

    @Override
    public final void internalSetNamespace(OMNamespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public final String internalGetLocalName() {
        return this.localName;
    }

    @Override
    public final void internalSetLocalName(String localName) {
        this.localName = localName;
    }

    public OMNamespace getNamespace() {
        return this.defaultGetNamespace();
    }

    public final String getLocalName() {
        return this.coreGetLocalName();
    }

    public final String getNamespaceURI() {
        String namespaceURI = this.coreGetNamespaceURI();
        return namespaceURI.length() == 0 ? null : namespaceURI;
    }

    public final String getPrefix() {
        String prefix = this.coreGetPrefix();
        return prefix.length() == 0 ? null : prefix;
    }

    @Override
    public final OMNamespace defaultGetNamespace() {
        return this.namespace;
    }

    public final void setLocalName(String localName) {
        this.beforeSetLocalName();
        this.localName = localName;
    }

    public QName getQName() {
        return this.defaultGetQName();
    }

    @Override
    public final QName defaultGetQName() {
        return QNameCache.getQName(this.namespace == null ? "" : this.namespace.getNamespaceURI(), this.localName, this.namespace == null ? "" : this.namespace.getPrefix());
    }

    public final boolean hasName(QName name) {
        if (name.getLocalPart().equals(this.getLocalName())) {
            OMNamespace ns = this.getNamespace();
            return ns == null && name.getNamespaceURI().length() == 0 || ns != null && name.getNamespaceURI().equals(ns.getNamespaceURI());
        }
        return false;
    }

    @Override
    public final String coreGetNamespaceURI() {
        OMNamespace namespace = this.getNamespace();
        return namespace == null ? "" : namespace.getNamespaceURI();
    }

    @Override
    public final String coreGetPrefix() {
        OMNamespace namespace = this.getNamespace();
        return namespace == null ? "" : namespace.getPrefix();
    }

    @Override
    public final void coreSetName(String namespaceURI, String localName, String prefix) {
        this.localName = localName;
        this.namespace = namespaceURI.length() == 0 && prefix.length() == 0 ? null : new OMNamespaceImpl(namespaceURI, prefix);
    }

    @Override
    public final void initName(CoreNamedNode other) {
        AxiomNamedInformationItem o = (AxiomNamedInformationItem)other;
        if (o instanceof AxiomSourcedElement && ((AxiomElement)((Object)this)).isExpanded()) {
            this.localName = o.coreGetLocalName();
            this.namespace = o.getNamespace();
        } else {
            this.localName = o.internalGetLocalName();
            this.namespace = o.defaultGetNamespace();
        }
    }

    public void updateLocalName() {
        throw new IllegalStateException();
    }

    @Override
    public final String coreGetLocalName() {
        if (this.localName == null) {
            this.updateLocalName();
        }
        return this.localName;
    }

    @Override
    public final void coreSetPrefix(String prefix) {
        OMNamespace ns = this.getNamespace();
        if (ns == null) {
            if (prefix.length() > 0) {
                throw new OMException("Cannot set prefix on an information item without namespace");
            }
        } else {
            this.internalSetNamespace(new OMNamespaceImpl(ns.getNamespaceURI(), prefix));
        }
    }
}

