/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.code;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.openjdk.javax.lang.model.element.Modifier;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.StringUtils;

public class Flags {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICTFP = 2048;
    public static final int SYNTHETIC = 4096;
    public static final int ANNOTATION = 8192;
    public static final int ENUM = 16384;
    public static final int MANDATED = 32768;
    public static final int StandardFlags = 4095;
    public static final int ACC_SUPER = 32;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_MODULE = 32768;
    public static final int DEPRECATED = 131072;
    public static final int HASINIT = 262144;
    public static final int BLOCK = 0x100000;
    public static final int NOOUTERTHIS = 0x400000;
    public static final int EXISTS = 0x800000;
    public static final int COMPOUND = 0x1000000;
    public static final int CLASS_SEEN = 0x2000000;
    public static final int SOURCE_SEEN = 0x4000000;
    public static final int LOCKED = 0x8000000;
    public static final int UNATTRIBUTED = 0x10000000;
    public static final int ANONCONSTR = 0x20000000;
    public static final int ACYCLIC = 0x40000000;
    public static final long BRIDGE = 0x80000000L;
    public static final long PARAMETER = 0x200000000L;
    public static final long VARARGS = 0x400000000L;
    public static final long ACYCLIC_ANN = 0x800000000L;
    public static final long GENERATEDCONSTR = 0x1000000000L;
    public static final long HYPOTHETICAL = 0x2000000000L;
    public static final long PROPRIETARY = 0x4000000000L;
    public static final long UNION = 0x8000000000L;
    public static final long EFFECTIVELY_FINAL = 0x20000000000L;
    public static final long CLASH = 0x40000000000L;
    public static final long DEFAULT = 0x80000000000L;
    public static final long AUXILIARY = 0x100000000000L;
    public static final long NOT_IN_PROFILE = 0x200000000000L;
    public static final long BAD_OVERRIDE = 0x200000000000L;
    public static final long SIGNATURE_POLYMORPHIC = 0x400000000000L;
    public static final long THROWS = 0x800000000000L;
    public static final long POTENTIALLY_AMBIGUOUS = 0x1000000000000L;
    public static final long LAMBDA_METHOD = 0x2000000000000L;
    public static final long TYPE_TRANSLATED = 0x4000000000000L;
    public static final long MODULE = 0x8000000000000L;
    public static final long AUTOMATIC_MODULE = 0x10000000000000L;
    public static final long SYSTEM_MODULE = 0x20000000000000L;
    public static final long DEPRECATED_ANNOTATION = 0x40000000000000L;
    public static final long DEPRECATED_REMOVAL = 0x80000000000000L;
    public static final long HAS_RESOURCE = 0x100000000000000L;
    public static final int AccessFlags = 7;
    public static final int LocalClassFlags = 23568;
    public static final int MemberClassFlags = 24087;
    public static final int ClassFlags = 32273;
    public static final int InterfaceVarFlags = 25;
    public static final int VarFlags = 16607;
    public static final int ConstructorFlags = 7;
    public static final int InterfaceMethodFlags = 1025;
    public static final int MethodFlags = 3391;
    public static final long ExtendedStandardFlags = 0x80000000FFFL;
    public static final long ModifierFlags = 8796093025791L;
    public static final long InterfaceMethodMask = 8796093025291L;
    public static final long AnnotationTypeElementMask = 1025L;
    public static final long LocalVarFlags = 0x200000010L;
    public static final long ReceiverParamFlags = 0x200000000L;
    private static final Map<Long, Set<Modifier>> modifierSets = new ConcurrentHashMap<Long, Set<Modifier>>(64);

    private Flags() {
    }

    public static String toString(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (Flag flag : Flags.asFlagSet(l)) {
            stringBuilder.append(string);
            stringBuilder.append((Object)flag);
            string = " ";
        }
        return stringBuilder.toString();
    }

    public static EnumSet<Flag> asFlagSet(long l) {
        EnumSet<Flag> enumSet = EnumSet.noneOf(Flag.class);
        for (Flag flag : Flag.values()) {
            if ((l & flag.value) == 0L) continue;
            enumSet.add(flag);
            l &= flag.value ^ 0xFFFFFFFFFFFFFFFFL;
        }
        Assert.check(l == 0L);
        return enumSet;
    }

    public static Set<Modifier> asModifierSet(long l) {
        Set<Modifier> set = modifierSets.get(l);
        if (set == null) {
            set = EnumSet.noneOf(Modifier.class);
            if (0L != (l & 1L)) {
                set.add(Modifier.PUBLIC);
            }
            if (0L != (l & 4L)) {
                set.add(Modifier.PROTECTED);
            }
            if (0L != (l & 2L)) {
                set.add(Modifier.PRIVATE);
            }
            if (0L != (l & 0x400L)) {
                set.add(Modifier.ABSTRACT);
            }
            if (0L != (l & 8L)) {
                set.add(Modifier.STATIC);
            }
            if (0L != (l & 0x10L)) {
                set.add(Modifier.FINAL);
            }
            if (0L != (l & 0x80L)) {
                set.add(Modifier.TRANSIENT);
            }
            if (0L != (l & 0x40L)) {
                set.add(Modifier.VOLATILE);
            }
            if (0L != (l & 0x20L)) {
                set.add(Modifier.SYNCHRONIZED);
            }
            if (0L != (l & 0x100L)) {
                set.add(Modifier.NATIVE);
            }
            if (0L != (l & 0x800L)) {
                set.add(Modifier.STRICTFP);
            }
            if (0L != (l & 0x80000000000L)) {
                set.add(Modifier.DEFAULT);
            }
            set = Collections.unmodifiableSet(set);
            modifierSets.put(l, set);
        }
        return set;
    }

    public static boolean isStatic(Symbol symbol) {
        return (symbol.flags() & 8L) != 0L;
    }

    public static boolean isEnum(Symbol symbol) {
        return (symbol.flags() & 0x4000L) != 0L;
    }

    public static boolean isConstant(Symbol.VarSymbol varSymbol) {
        return varSymbol.getConstValue() != null;
    }

    public static enum Flag {
        PUBLIC(1L),
        PRIVATE(2L),
        PROTECTED(4L),
        STATIC(8L),
        FINAL(16L),
        SYNCHRONIZED(32L),
        VOLATILE(64L),
        TRANSIENT(128L),
        NATIVE(256L),
        INTERFACE(512L),
        ABSTRACT(1024L),
        DEFAULT(0x80000000000L),
        STRICTFP(2048L),
        BRIDGE(0x80000000L),
        SYNTHETIC(4096L),
        ANNOTATION(8192L),
        DEPRECATED(131072L),
        HASINIT(262144L),
        BLOCK(0x100000L),
        ENUM(16384L),
        MANDATED(32768L),
        NOOUTERTHIS(0x400000L),
        EXISTS(0x800000L),
        COMPOUND(0x1000000L),
        CLASS_SEEN(0x2000000L),
        SOURCE_SEEN(0x4000000L),
        LOCKED(0x8000000L),
        UNATTRIBUTED(0x10000000L),
        ANONCONSTR(0x20000000L),
        ACYCLIC(0x40000000L),
        PARAMETER(0x200000000L),
        VARARGS(0x400000000L),
        ACYCLIC_ANN(0x800000000L),
        GENERATEDCONSTR(0x1000000000L),
        HYPOTHETICAL(0x2000000000L),
        PROPRIETARY(0x4000000000L),
        UNION(0x8000000000L),
        EFFECTIVELY_FINAL(0x20000000000L),
        CLASH(0x40000000000L),
        AUXILIARY(0x100000000000L),
        NOT_IN_PROFILE(0x200000000000L),
        BAD_OVERRIDE(0x200000000000L),
        SIGNATURE_POLYMORPHIC(0x400000000000L),
        THROWS(0x800000000000L),
        LAMBDA_METHOD(0x2000000000000L),
        TYPE_TRANSLATED(0x4000000000000L),
        MODULE(0x8000000000000L),
        AUTOMATIC_MODULE(0x10000000000000L),
        SYSTEM_MODULE(0x20000000000000L),
        DEPRECATED_ANNOTATION(0x40000000000000L),
        DEPRECATED_REMOVAL(0x80000000000000L),
        HAS_RESOURCE(0x100000000000000L);

        final long value;
        final String lowercaseName;

        private Flag(long l) {
            this.value = l;
            this.lowercaseName = StringUtils.toLowerCase(this.name());
        }

        public String toString() {
            return this.lowercaseName;
        }
    }
}

