/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context.externalize;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.mime.MultipartBody;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.externalize.ExternalizeConstants;
import org.apache.axis2.kernel.MessageFormatter;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageExternalizeUtils
implements ExternalizeConstants {
    static final Log log = LogFactory.getLog(MessageExternalizeUtils.class);
    private static final int REVISION_2 = 2;
    private static final int revisionID = 2;

    private MessageExternalizeUtils() {
    }

    public static void writeExternal(ObjectOutput out, MessageContext mc, String correlationIDString, OMOutputFormat outputFormat) throws IOException {
        SOAPEnvelope envelope;
        if (log.isDebugEnabled()) {
            log.debug((Object)(correlationIDString + ":writeExternal(): start"));
        }
        if ((envelope = mc.getEnvelope()) == null) {
            out.writeUTF("NULL_ENVELOPE");
            out.writeInt(2);
            out.writeBoolean(false);
            out.writeInt(0);
            if (log.isDebugEnabled()) {
                log.debug((Object)(correlationIDString + ":writeExternal(): end: msg is Empty"));
            }
            return;
        }
        String msgClass = envelope.getClass().getName();
        out.writeUTF(msgClass);
        out.writeInt(2);
        out.writeBoolean(true);
        if (outputFormat.isOptimized()) {
            out.writeBoolean(true);
            out.writeUTF(outputFormat.getContentType());
        } else {
            out.writeBoolean(false);
        }
        out.writeUTF(outputFormat.getCharSetEncoding());
        out.writeUTF(envelope.getNamespace().getNamespaceURI());
        if (log.isDebugEnabled()) {
            log.debug((Object)(correlationIDString + ":writeExternal(): optimized=[" + outputFormat.isOptimized() + "]  optimizedContentType " + outputFormat.getContentType() + "]  charSetEnc=[" + outputFormat.getCharSetEncoding() + "]  namespaceURI=[" + envelope.getNamespace().getNamespaceURI() + "]"));
        }
        MessageOutputStream mos = new MessageOutputStream(out);
        BufferedOutputStream bos = new BufferedOutputStream(mos);
        boolean errorOccurred = false;
        try {
            MessageFormatter msgFormatter = MessageProcessorSelector.getMessageFormatter(mc);
            msgFormatter.writeTo(mc, outputFormat, bos, true);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw AxisFault.makeFault(t);
        }
        finally {
            bos.flush();
            bos.close();
        }
        if (errorOccurred) {
            out.writeInt(-1);
        } else {
            out.writeInt(0);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(correlationIDString + ":writeExternal(): end"));
        }
    }

    private static OMXMLParserWrapper getAttachmentsBuilder(MessageContext msgContext, InputStream inStream, String contentTypeString, boolean isSOAP) throws OMException, XMLStreamException, FactoryConfigurationError {
        Attachments attachments = BuilderUtil.createAttachmentsMap(msgContext, inStream, contentTypeString);
        String charSetEncoding = BuilderUtil.getCharSetEncoding(attachments.getRootPartContentType());
        if (charSetEncoding == null || "null".equalsIgnoreCase(charSetEncoding)) {
            charSetEncoding = "UTF-8";
        }
        msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEncoding);
        msgContext.setAttachmentMap(attachments);
        if (isSOAP) {
            if (attachments.getAttachmentSpecType().equals("application/xop+xml")) {
                return OMXMLBuilderFactory.createSOAPModelBuilder((MultipartBody)attachments.getMultipartBody());
            }
            return OMXMLBuilderFactory.createSOAPModelBuilder((InputStream)attachments.getRootPartInputStream(), (String)charSetEncoding);
        }
        if (attachments.getAttachmentSpecType().equals("application/xop+xml")) {
            return OMXMLBuilderFactory.createOMBuilder((StAXParserConfiguration)StAXParserConfiguration.DEFAULT, (MultipartBody)attachments.getMultipartBody());
        }
        return OMXMLBuilderFactory.createOMBuilder((InputStream)attachments.getRootPartInputStream(), (String)charSetEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SOAPEnvelope readExternal(ObjectInput in, MessageContext mc, String correlationIDString) throws IOException, ClassNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(correlationIDString + ":readExternal(): start"));
        }
        SOAPEnvelope envelope = null;
        String name = in.readUTF();
        int revision = in.readInt();
        if (log.isDebugEnabled()) {
            log.debug((Object)(correlationIDString + ":readExternal(): name= " + name + " revision= " + revision));
        }
        if (revision != 2) {
            throw new ClassNotFoundException("Revision ID is not supported.");
        }
        boolean gotMsg = in.readBoolean();
        if (!gotMsg) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(correlationIDString + ":readExternal(): end:no message present"));
            }
            in.readInt();
            return envelope;
        }
        boolean optimized = in.readBoolean();
        String optimizedContentType = null;
        if (optimized) {
            optimizedContentType = in.readUTF();
        }
        String charSetEnc = in.readUTF();
        String namespaceURI = in.readUTF();
        if (log.isDebugEnabled()) {
            log.debug((Object)(correlationIDString + ":readExternal(): optimized=[" + optimized + "]  optimizedContentType=[" + optimizedContentType + "]  charSetEnc=[" + charSetEnc + "]  namespaceURI=[" + namespaceURI + "]"));
        }
        MessageInputStream mis = new MessageInputStream(in);
        SOAPModelBuilder builder = null;
        try {
            if (optimized) {
                boolean isSOAP = true;
                builder = MessageExternalizeUtils.getAttachmentsBuilder(mc, mis, optimizedContentType, isSOAP);
                envelope = (SOAPEnvelope)builder.getDocumentElement();
            } else {
                builder = OMXMLBuilderFactory.createSOAPModelBuilder((InputStream)mis, (String)charSetEnc);
                envelope = (SOAPEnvelope)builder.getDocumentElement();
            }
        }
        catch (Exception ex) {
            log.error((Object)(correlationIDString + ":readExternal(): Error when deserializing persisted envelope: [" + ex.getClass().getName() + " : " + ex.getLocalizedMessage() + "]"), (Throwable)ex);
            envelope = null;
        }
        finally {
            builder.detach();
            mis.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)(correlationIDString + ":readExternal(): end"));
            }
        }
        return envelope;
    }

    private static class MessageOutputStream
    extends OutputStream {
        ObjectOutput out;
        boolean isDebug;

        MessageOutputStream(ObjectOutput out) {
            this.out = out;
            this.isDebug = log.isDebugEnabled();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                if (this.isDebug) {
                    log.debug((Object)("Write data chunk with len=" + len));
                }
                this.out.writeInt(len);
                this.out.write(b, off, len);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (b != null && b.length > 0) {
                if (this.isDebug) {
                    log.debug((Object)("Write data chunk with size=" + b.length));
                }
                this.out.writeInt(b.length);
                this.out.write(b);
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.isDebug) {
                log.debug((Object)"Write one byte data chunk");
            }
            this.out.writeInt(1);
            this.out.write(b);
        }
    }

    private static class MessageInputStream
    extends InputStream {
        ObjectInput in;
        boolean isDebug;
        int chunkAvail = 0;
        boolean isEOD = false;

        MessageInputStream(ObjectInput in) {
            this.in = in;
            this.isDebug = log.isDebugEnabled();
        }

        @Override
        public int read() throws IOException {
            if (this.isDebug) {
                log.debug((Object)"invoking read()");
            }
            this.updateChunkAvail();
            int ret = 0;
            if (this.isEOD) {
                ret = -1;
            } else {
                --this.chunkAvail;
                ret = this.in.readByte();
            }
            log.debug((Object)("returning " + ret));
            return ret;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.isDebug) {
                log.debug((Object)("invoking read with off=" + off + " and len=" + len));
            }
            if (this.isEOD) {
                if (this.isDebug) {
                    log.debug((Object)"EOD returning -1");
                }
                return -1;
            }
            int bytesRead = 0;
            while (len > 0 && !this.isEOD) {
                this.updateChunkAvail();
                if (this.isEOD) continue;
                int readLength = len < this.chunkAvail ? len : this.chunkAvail;
                int br = this.in.read(b, off, readLength);
                if (br < 0) {
                    throw new IOException("End of File encountered");
                }
                off += br;
                len -= br;
                this.chunkAvail -= br;
                bytesRead += br;
            }
            if (this.isDebug) {
                log.debug((Object)("bytes read = " + bytesRead));
            }
            return bytesRead;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public void close() throws IOException {
            if (this.isDebug) {
                log.debug((Object)"start close");
            }
            if (!this.isEOD) {
                byte[] tempBuffer = new byte[4096];
                while (!this.isEOD) {
                    this.read(tempBuffer);
                }
            }
            if (this.isDebug) {
                log.debug((Object)"end close");
            }
        }

        private void updateChunkAvail() throws IOException {
            if (this.chunkAvail == 0 && !this.isEOD) {
                this.chunkAvail = this.in.readInt();
                if (this.isDebug) {
                    log.debug((Object)("New DataBlock with size=" + this.chunkAvail));
                }
                if (this.chunkAvail <= 0) {
                    if (this.isDebug) {
                        log.debug((Object)"End of data");
                    }
                    this.isEOD = true;
                    this.chunkAvail = 0;
                }
            }
        }
    }
}

