/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.context.externalize.ActivateUtils;
import org.apache.axis2.context.externalize.ExternalizeConstants;
import org.apache.axis2.context.externalize.SafeObjectInputStream;
import org.apache.axis2.context.externalize.SafeObjectOutputStream;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.kernel.TransportListener;
import org.apache.axis2.util.MetaDataEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectStateUtils
implements ExternalizeConstants {
    private static final Log log = LogFactory.getLog(ObjectStateUtils.class);
    public static String NULL_OBJECT = "NULL_OBJ";
    public static final String UNSUPPORTED_SUID = "Serialization version ID is not supported.";
    public static final String UNSUPPORTED_REVID = "Revision ID is not supported.";

    public static void writeString(ObjectOutput o, String str, String desc) throws IOException {
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        out.writeUTF(desc);
        out.writeObject(str);
    }

    public static String readString(ObjectInput i, String desc) throws IOException, ClassNotFoundException {
        SafeObjectInputStream in = SafeObjectInputStream.install(i);
        in.readUTF();
        return (String)in.readObject();
    }

    public static void writeObject(ObjectOutput o, Object obj, String desc) throws IOException {
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        out.writeUTF(desc);
        out.writeObject(obj);
    }

    public static Object readObject(ObjectInput i, String desc) throws IOException, ClassNotFoundException {
        SafeObjectInputStream in = SafeObjectInputStream.install(i);
        in.readUTF();
        return in.readObject();
    }

    public static void writeArrayList(ObjectOutput o, ArrayList al, String desc) throws IOException {
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        out.writeUTF(desc);
        out.writeList(al);
    }

    public static ArrayList readArrayList(ObjectInput i, String desc) throws IOException {
        SafeObjectInputStream in = SafeObjectInputStream.install(i);
        in.readUTF();
        return in.readArrayList();
    }

    public static void writeHashMap(ObjectOutput o, HashMap map, String desc) throws IOException {
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        out.writeUTF(desc);
        out.writeMap(map);
    }

    public static HashMap readHashMap(ObjectInput i, String desc) throws IOException {
        SafeObjectInputStream in = SafeObjectInputStream.install(i);
        in.readUTF();
        return in.readHashMap();
    }

    public static void writeLinkedList(ObjectOutput o, LinkedList objlist, String desc) throws IOException {
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        out.writeUTF(desc);
        out.writeList(objlist);
    }

    public static LinkedList readLinkedList(ObjectInput i, String desc) throws IOException {
        SafeObjectInputStream in = SafeObjectInputStream.install(i);
        in.readUTF();
        return in.readLinkedList();
    }

    public static AxisOperation findOperation(AxisConfiguration axisConfig, String opClassName, QName opQName) {
        return ActivateUtils.findOperation(axisConfig, opClassName, opQName);
    }

    public static AxisOperation findOperation(AxisService service, String opClassName, QName opQName) {
        return ActivateUtils.findOperation(service, opClassName, opQName);
    }

    public static AxisService findService(AxisConfiguration axisConfig, String serviceClassName, String serviceName) {
        return ActivateUtils.findService(axisConfig, serviceClassName, serviceName);
    }

    public static AxisServiceGroup findServiceGroup(AxisConfiguration axisConfig, String serviceGrpClassName, String serviceGrpName) {
        return ActivateUtils.findServiceGroup(axisConfig, serviceGrpClassName, serviceGrpName);
    }

    public static AxisMessage findMessage(AxisOperation op, String msgName, String msgElementName) {
        return ActivateUtils.findMessage(op, msgName, msgElementName);
    }

    public static Object findHandler(ArrayList existingHandlers, MetaDataEntry metaDataEntry) {
        return ActivateUtils.findHandler(existingHandlers, metaDataEntry);
    }

    public static TransportListener findTransportListener(AxisConfiguration axisConfig, String listenerClassName) {
        return ActivateUtils.findTransportListener(axisConfig, listenerClassName);
    }

    public static boolean isEquivalent(ArrayList a1, ArrayList a2, boolean strict) {
        return ActivateUtils.isEquivalent(a1, a2, strict);
    }

    public static boolean isEquivalent(Map m1, Map m2, boolean strict) {
        return ActivateUtils.isEquivalent(m1, m2, strict);
    }

    public static boolean isEquivalent(LinkedList l1, LinkedList l2) {
        return ActivateUtils.isEquivalent(l1, l2);
    }
}

