/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.mixin;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.intf.Sequence;
import org.apache.axiom.soap.SOAP12Constants;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.impl.factory.SOAP12Factory;
import org.apache.axiom.soap.impl.intf.soap12.AxiomSOAP12FaultClassifier;
import org.apache.axiom.weaver.annotation.Mixin;

@Mixin
public abstract class AxiomSOAP12FaultClassifierMixin
implements AxiomSOAP12FaultClassifier {
    private static final Sequence sequence = new Sequence(SOAPFaultValue.class, SOAPFaultSubCode.class);

    @Override
    public final boolean isChildElementAllowed(OMElement child) {
        return child instanceof SOAPFaultValue || child instanceof SOAPFaultSubCode;
    }

    public final SOAPFaultValue getValue() {
        return (SOAPFaultValue)this.getFirstChildWithName(SOAP12Constants.QNAME_FAULT_VALUE);
    }

    public final void setValue(SOAPFaultValue value) {
        this.insertChild(sequence, 0, (OMElement)value, true);
    }

    public final SOAPFaultSubCode getSubCode() {
        return (SOAPFaultSubCode)this.getFirstChildWithName(SOAP12Constants.QNAME_FAULT_SUBCODE);
    }

    public final void setSubCode(SOAPFaultSubCode subCode) {
        this.insertChild(sequence, 1, (OMElement)subCode, true);
    }

    public final QName getValueAsQName() {
        SOAPFaultValue value = this.getValue();
        return value == null ? null : value.getTextAsQName();
    }

    public final void setValue(QName value) {
        SOAPFaultValue valueElement = this.getValue();
        if (valueElement == null) {
            valueElement = ((SOAP12Factory)this.getOMFactory()).internalCreateSOAPFaultValue(this);
        }
        valueElement.setText(value);
    }
}

