/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime;

import java.io.IOException;
import java.io.InputStream;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.blob.WritableBlob;
import org.apache.axiom.blob.WritableBlobFactory;

final class PartInputStream
extends InputStream {
    private WritableBlob content;
    private InputStream in;
    private WritableBlobFactory<?> blobFactory;

    PartInputStream(WritableBlob content) throws IOException {
        this.content = content;
        this.in = PartInputStream.getInputStream(content);
    }

    PartInputStream(InputStream in, WritableBlobFactory<?> blobFactory) {
        this.in = in;
        this.blobFactory = blobFactory;
    }

    private static InputStream getInputStream(WritableBlob content) throws IOException {
        if (content instanceof MemoryBlob) {
            return ((MemoryBlob)content).readOnce();
        }
        return content.getInputStream();
    }

    void detach() throws IOException {
        if (this.blobFactory == null) {
            throw new IllegalStateException();
        }
        if (this.in != null) {
            Object content = this.blobFactory.createBlob();
            content.readFrom(this.in);
            this.content = content;
            this.in = PartInputStream.getInputStream(content);
        }
        this.blobFactory = null;
    }

    @Override
    public int available() throws IOException {
        return this.in == null ? 0 : this.in.available();
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            return -1;
        }
        int result = this.in.read();
        if (result == -1) {
            this.close();
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.in == null) {
            return -1;
        }
        int result = this.in.read(b, off, len);
        if (result == -1) {
            this.close();
        }
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.in == null) {
            return -1;
        }
        int result = this.in.read(b);
        if (result == -1) {
            this.close();
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in == null ? 0L : this.in.skip(n);
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        if (this.content != null) {
            this.content.release();
            this.content = null;
        }
    }
}

