/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.binding.decoding;

import java.util.List;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml1.binding.decoding.BaseSAML1MessageDecoder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPArtifactDecoder
extends BaseSAML1MessageDecoder {
    private final Logger log = LoggerFactory.getLogger(HTTPArtifactDecoder.class);

    public HTTPArtifactDecoder(SAMLArtifactMap map, ParserPool pool) {
        super(map, pool);
    }

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01";
    }

    protected void doDecode(MessageContext messageContext) throws MessageDecodingException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.error("Invalid message context type, this decoder only support SAMLMessageContext");
            throw new MessageDecodingException("Invalid message context type, this decoder only support SAMLMessageContext");
        }
        if (!(messageContext.getInboundMessageTransport() instanceof HTTPInTransport)) {
            this.log.error("Invalid inbound message transport type, this decoder only support HTTPInTransport");
            throw new MessageDecodingException("Invalid inbound message transport type, this decoder only support HTTPInTransport");
        }
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        this.decodeTarget(samlMsgCtx);
        this.processArtifacts(samlMsgCtx);
        this.populateMessageContext(samlMsgCtx);
    }

    protected void decodeTarget(SAMLMessageContext samlMsgCtx) throws MessageDecodingException {
        HTTPInTransport inTransport = (HTTPInTransport)samlMsgCtx.getInboundMessageTransport();
        String target = DatatypeHelper.safeTrim((String)inTransport.getParameterValue("TARGET"));
        if (target == null) {
            this.log.error("URL TARGET parameter was missing or did not contain a value.");
            throw new MessageDecodingException("URL TARGET parameter was missing or did not contain a value.");
        }
        samlMsgCtx.setRelayState(target);
    }

    protected void processArtifacts(SAMLMessageContext samlMsgCtx) throws MessageDecodingException {
        HTTPInTransport inTransport = (HTTPInTransport)samlMsgCtx.getInboundMessageTransport();
        List encodedArtifacts = inTransport.getParameterValues("SAMLart");
        if (encodedArtifacts == null || encodedArtifacts.size() == 0) {
            this.log.error("URL SAMLart parameter was missing or did not contain a value.");
            throw new MessageDecodingException("URL SAMLart parameter was missing or did not contain a value.");
        }
    }

    protected boolean isIntendedDestinationEndpointURIRequired(SAMLMessageContext samlMsgCtx) {
        return false;
    }

    protected String getIntendedDestinationEndpointURI(SAMLMessageContext samlMsgCtx) throws MessageDecodingException {
        return null;
    }
}

