// @generated by protobuf-ts 2.1.0 with parameter client_grpc1,server_grpc1,generate_dependencies
// @generated from protobuf file "org/apache/beam/model/fn_execution/v1/beam_fn_api.proto" (package "org.apache.beam.model.fn_execution.v1", syntax proto3)
// tslint:disable
//
//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//
//
// Protocol Buffers describing the Fn API and boostrapping.
//
// TODO: Usage of plural names in lists looks awkward in Java
// e.g. getOutputsMap, addCodersBuilder
//
// TODO: gRPC / proto field names conflict with generated code
// e.g. "class" in java, "output" in python
//
//
// TODO: Consider consolidating common components in another package
// and language namespaces for re-use with Runner Api.
//
import { BeamFnWorkerStatus } from "./beam_fn_api";
import type { WorkerStatusRequest } from "./beam_fn_api";
import type { WorkerStatusResponse } from "./beam_fn_api";
import { BeamFnExternalWorkerPool } from "./beam_fn_api";
import type { StopWorkerResponse } from "./beam_fn_api";
import type { StopWorkerRequest } from "./beam_fn_api";
import type { StartWorkerResponse } from "./beam_fn_api";
import type { StartWorkerRequest } from "./beam_fn_api";
import { BeamFnLogging } from "./beam_fn_api";
import type { LogControl } from "./beam_fn_api";
import type { LogEntry_List } from "./beam_fn_api";
import { BeamFnState } from "./beam_fn_api";
import type { StateResponse } from "./beam_fn_api";
import type { StateRequest } from "./beam_fn_api";
import { BeamFnData } from "./beam_fn_api";
import type { Elements } from "./beam_fn_api";
import { BeamFnControl } from "./beam_fn_api";
import type { BinaryWriteOptions } from "@protobuf-ts/runtime";
import type { BinaryReadOptions } from "@protobuf-ts/runtime";
import type { ProcessBundleDescriptor } from "./beam_fn_api";
import type { GetProcessBundleDescriptorRequest } from "./beam_fn_api";
import type { InstructionRequest } from "./beam_fn_api";
import type { InstructionResponse } from "./beam_fn_api";
import * as grpc from "@grpc/grpc-js";
// 
// Control Plane API
// 
// Progress reporting and splitting still need further vetting. Also, this may
// change with the addition of new types of instructions/responses related to
// metrics.

/**
 * An API that describes the work that a SDK harness is meant to do.
 * Stable
 *
 * @generated from protobuf service org.apache.beam.model.fn_execution.v1.BeamFnControl
 */
export interface IBeamFnControlClient {
    /**
     * Instructions sent by the runner to the SDK requesting different types
     * of work.
     *
     * @generated from protobuf rpc: Control(stream org.apache.beam.model.fn_execution.v1.InstructionResponse) returns (stream org.apache.beam.model.fn_execution.v1.InstructionRequest);
     */
    control(metadata: grpc.Metadata, options?: grpc.CallOptions): grpc.ClientDuplexStream<InstructionResponse, InstructionRequest>;
    control(options?: grpc.CallOptions): grpc.ClientDuplexStream<InstructionResponse, InstructionRequest>;
    /**
     * Used to get the full process bundle descriptors for bundles one
     * is asked to process.
     *
     * @generated from protobuf rpc: GetProcessBundleDescriptor(org.apache.beam.model.fn_execution.v1.GetProcessBundleDescriptorRequest) returns (org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor);
     */
    getProcessBundleDescriptor(input: GetProcessBundleDescriptorRequest, metadata: grpc.Metadata, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: ProcessBundleDescriptor) => void): grpc.ClientUnaryCall;
    getProcessBundleDescriptor(input: GetProcessBundleDescriptorRequest, metadata: grpc.Metadata, callback: (err: grpc.ServiceError | null, value?: ProcessBundleDescriptor) => void): grpc.ClientUnaryCall;
    getProcessBundleDescriptor(input: GetProcessBundleDescriptorRequest, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: ProcessBundleDescriptor) => void): grpc.ClientUnaryCall;
    getProcessBundleDescriptor(input: GetProcessBundleDescriptorRequest, callback: (err: grpc.ServiceError | null, value?: ProcessBundleDescriptor) => void): grpc.ClientUnaryCall;
}
// 
// Control Plane API
// 
// Progress reporting and splitting still need further vetting. Also, this may
// change with the addition of new types of instructions/responses related to
// metrics.

/**
 * An API that describes the work that a SDK harness is meant to do.
 * Stable
 *
 * @generated from protobuf service org.apache.beam.model.fn_execution.v1.BeamFnControl
 */
export class BeamFnControlClient extends grpc.Client implements IBeamFnControlClient {
    private readonly _binaryOptions: Partial<BinaryReadOptions & BinaryWriteOptions>;
    constructor(address: string, credentials: grpc.ChannelCredentials, options: grpc.ClientOptions = {}, binaryOptions: Partial<BinaryReadOptions & BinaryWriteOptions> = {}) {
        super(address, credentials, options);
        this._binaryOptions = binaryOptions;
    }
    /**
     * Instructions sent by the runner to the SDK requesting different types
     * of work.
     *
     * @generated from protobuf rpc: Control(stream org.apache.beam.model.fn_execution.v1.InstructionResponse) returns (stream org.apache.beam.model.fn_execution.v1.InstructionRequest);
     */
    control(metadata?: grpc.Metadata | grpc.CallOptions, options?: grpc.CallOptions): grpc.ClientDuplexStream<InstructionResponse, InstructionRequest> {
        const method = BeamFnControl.methods[0];
        return this.makeBidiStreamRequest<InstructionResponse, InstructionRequest>(`/${BeamFnControl.typeName}/${method.name}`, (value: InstructionResponse): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): InstructionRequest => method.O.fromBinary(value, this._binaryOptions), (metadata as any), options);
    }
    /**
     * Used to get the full process bundle descriptors for bundles one
     * is asked to process.
     *
     * @generated from protobuf rpc: GetProcessBundleDescriptor(org.apache.beam.model.fn_execution.v1.GetProcessBundleDescriptorRequest) returns (org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor);
     */
    getProcessBundleDescriptor(input: GetProcessBundleDescriptorRequest, metadata: grpc.Metadata | grpc.CallOptions | ((err: grpc.ServiceError | null, value?: ProcessBundleDescriptor) => void), options?: grpc.CallOptions | ((err: grpc.ServiceError | null, value?: ProcessBundleDescriptor) => void), callback?: ((err: grpc.ServiceError | null, value?: ProcessBundleDescriptor) => void)): grpc.ClientUnaryCall {
        const method = BeamFnControl.methods[1];
        return this.makeUnaryRequest<GetProcessBundleDescriptorRequest, ProcessBundleDescriptor>(`/${BeamFnControl.typeName}/${method.name}`, (value: GetProcessBundleDescriptorRequest): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): ProcessBundleDescriptor => method.O.fromBinary(value, this._binaryOptions), input, (metadata as any), (options as any), (callback as any));
    }
}
/**
 * Stable
 *
 * @generated from protobuf service org.apache.beam.model.fn_execution.v1.BeamFnData
 */
export interface IBeamFnDataClient {
    /**
     * Used to send data between harnesses.
     *
     * @generated from protobuf rpc: Data(stream org.apache.beam.model.fn_execution.v1.Elements) returns (stream org.apache.beam.model.fn_execution.v1.Elements);
     */
    data(metadata: grpc.Metadata, options?: grpc.CallOptions): grpc.ClientDuplexStream<Elements, Elements>;
    data(options?: grpc.CallOptions): grpc.ClientDuplexStream<Elements, Elements>;
}
/**
 * Stable
 *
 * @generated from protobuf service org.apache.beam.model.fn_execution.v1.BeamFnData
 */
export class BeamFnDataClient extends grpc.Client implements IBeamFnDataClient {
    private readonly _binaryOptions: Partial<BinaryReadOptions & BinaryWriteOptions>;
    constructor(address: string, credentials: grpc.ChannelCredentials, options: grpc.ClientOptions = {}, binaryOptions: Partial<BinaryReadOptions & BinaryWriteOptions> = {}) {
        super(address, credentials, options);
        this._binaryOptions = binaryOptions;
    }
    /**
     * Used to send data between harnesses.
     *
     * @generated from protobuf rpc: Data(stream org.apache.beam.model.fn_execution.v1.Elements) returns (stream org.apache.beam.model.fn_execution.v1.Elements);
     */
    data(metadata?: grpc.Metadata | grpc.CallOptions, options?: grpc.CallOptions): grpc.ClientDuplexStream<Elements, Elements> {
        const method = BeamFnData.methods[0];
        return this.makeBidiStreamRequest<Elements, Elements>(`/${BeamFnData.typeName}/${method.name}`, (value: Elements): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): Elements => method.O.fromBinary(value, this._binaryOptions), (metadata as any), options);
    }
}
/**
 * @generated from protobuf service org.apache.beam.model.fn_execution.v1.BeamFnState
 */
export interface IBeamFnStateClient {
    /**
     * Used to get/append/clear state stored by the runner on behalf of the SDK.
     *
     * @generated from protobuf rpc: State(stream org.apache.beam.model.fn_execution.v1.StateRequest) returns (stream org.apache.beam.model.fn_execution.v1.StateResponse);
     */
    state(metadata: grpc.Metadata, options?: grpc.CallOptions): grpc.ClientDuplexStream<StateRequest, StateResponse>;
    state(options?: grpc.CallOptions): grpc.ClientDuplexStream<StateRequest, StateResponse>;
}
/**
 * @generated from protobuf service org.apache.beam.model.fn_execution.v1.BeamFnState
 */
export class BeamFnStateClient extends grpc.Client implements IBeamFnStateClient {
    private readonly _binaryOptions: Partial<BinaryReadOptions & BinaryWriteOptions>;
    constructor(address: string, credentials: grpc.ChannelCredentials, options: grpc.ClientOptions = {}, binaryOptions: Partial<BinaryReadOptions & BinaryWriteOptions> = {}) {
        super(address, credentials, options);
        this._binaryOptions = binaryOptions;
    }
    /**
     * Used to get/append/clear state stored by the runner on behalf of the SDK.
     *
     * @generated from protobuf rpc: State(stream org.apache.beam.model.fn_execution.v1.StateRequest) returns (stream org.apache.beam.model.fn_execution.v1.StateResponse);
     */
    state(metadata?: grpc.Metadata | grpc.CallOptions, options?: grpc.CallOptions): grpc.ClientDuplexStream<StateRequest, StateResponse> {
        const method = BeamFnState.methods[0];
        return this.makeBidiStreamRequest<StateRequest, StateResponse>(`/${BeamFnState.typeName}/${method.name}`, (value: StateRequest): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): StateResponse => method.O.fromBinary(value, this._binaryOptions), (metadata as any), options);
    }
}
/**
 * Stable
 *
 * @generated from protobuf service org.apache.beam.model.fn_execution.v1.BeamFnLogging
 */
export interface IBeamFnLoggingClient {
    /**
     * Allows for the SDK to emit log entries which the runner can
     * associate with the active job.
     *
     * @generated from protobuf rpc: Logging(stream org.apache.beam.model.fn_execution.v1.LogEntry.List) returns (stream org.apache.beam.model.fn_execution.v1.LogControl);
     */
    logging(metadata: grpc.Metadata, options?: grpc.CallOptions): grpc.ClientDuplexStream<LogEntry_List, LogControl>;
    logging(options?: grpc.CallOptions): grpc.ClientDuplexStream<LogEntry_List, LogControl>;
}
/**
 * Stable
 *
 * @generated from protobuf service org.apache.beam.model.fn_execution.v1.BeamFnLogging
 */
export class BeamFnLoggingClient extends grpc.Client implements IBeamFnLoggingClient {
    private readonly _binaryOptions: Partial<BinaryReadOptions & BinaryWriteOptions>;
    constructor(address: string, credentials: grpc.ChannelCredentials, options: grpc.ClientOptions = {}, binaryOptions: Partial<BinaryReadOptions & BinaryWriteOptions> = {}) {
        super(address, credentials, options);
        this._binaryOptions = binaryOptions;
    }
    /**
     * Allows for the SDK to emit log entries which the runner can
     * associate with the active job.
     *
     * @generated from protobuf rpc: Logging(stream org.apache.beam.model.fn_execution.v1.LogEntry.List) returns (stream org.apache.beam.model.fn_execution.v1.LogControl);
     */
    logging(metadata?: grpc.Metadata | grpc.CallOptions, options?: grpc.CallOptions): grpc.ClientDuplexStream<LogEntry_List, LogControl> {
        const method = BeamFnLogging.methods[0];
        return this.makeBidiStreamRequest<LogEntry_List, LogControl>(`/${BeamFnLogging.typeName}/${method.name}`, (value: LogEntry_List): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): LogControl => method.O.fromBinary(value, this._binaryOptions), (metadata as any), options);
    }
}
/**
 * @generated from protobuf service org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool
 */
export interface IBeamFnExternalWorkerPoolClient {
    /**
     * Start the SDK worker with the given ID.
     *
     * @generated from protobuf rpc: StartWorker(org.apache.beam.model.fn_execution.v1.StartWorkerRequest) returns (org.apache.beam.model.fn_execution.v1.StartWorkerResponse);
     */
    startWorker(input: StartWorkerRequest, metadata: grpc.Metadata, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: StartWorkerResponse) => void): grpc.ClientUnaryCall;
    startWorker(input: StartWorkerRequest, metadata: grpc.Metadata, callback: (err: grpc.ServiceError | null, value?: StartWorkerResponse) => void): grpc.ClientUnaryCall;
    startWorker(input: StartWorkerRequest, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: StartWorkerResponse) => void): grpc.ClientUnaryCall;
    startWorker(input: StartWorkerRequest, callback: (err: grpc.ServiceError | null, value?: StartWorkerResponse) => void): grpc.ClientUnaryCall;
    /**
     * Stop the SDK worker.
     *
     * @generated from protobuf rpc: StopWorker(org.apache.beam.model.fn_execution.v1.StopWorkerRequest) returns (org.apache.beam.model.fn_execution.v1.StopWorkerResponse);
     */
    stopWorker(input: StopWorkerRequest, metadata: grpc.Metadata, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: StopWorkerResponse) => void): grpc.ClientUnaryCall;
    stopWorker(input: StopWorkerRequest, metadata: grpc.Metadata, callback: (err: grpc.ServiceError | null, value?: StopWorkerResponse) => void): grpc.ClientUnaryCall;
    stopWorker(input: StopWorkerRequest, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: StopWorkerResponse) => void): grpc.ClientUnaryCall;
    stopWorker(input: StopWorkerRequest, callback: (err: grpc.ServiceError | null, value?: StopWorkerResponse) => void): grpc.ClientUnaryCall;
}
/**
 * @generated from protobuf service org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool
 */
export class BeamFnExternalWorkerPoolClient extends grpc.Client implements IBeamFnExternalWorkerPoolClient {
    private readonly _binaryOptions: Partial<BinaryReadOptions & BinaryWriteOptions>;
    constructor(address: string, credentials: grpc.ChannelCredentials, options: grpc.ClientOptions = {}, binaryOptions: Partial<BinaryReadOptions & BinaryWriteOptions> = {}) {
        super(address, credentials, options);
        this._binaryOptions = binaryOptions;
    }
    /**
     * Start the SDK worker with the given ID.
     *
     * @generated from protobuf rpc: StartWorker(org.apache.beam.model.fn_execution.v1.StartWorkerRequest) returns (org.apache.beam.model.fn_execution.v1.StartWorkerResponse);
     */
    startWorker(input: StartWorkerRequest, metadata: grpc.Metadata | grpc.CallOptions | ((err: grpc.ServiceError | null, value?: StartWorkerResponse) => void), options?: grpc.CallOptions | ((err: grpc.ServiceError | null, value?: StartWorkerResponse) => void), callback?: ((err: grpc.ServiceError | null, value?: StartWorkerResponse) => void)): grpc.ClientUnaryCall {
        const method = BeamFnExternalWorkerPool.methods[0];
        return this.makeUnaryRequest<StartWorkerRequest, StartWorkerResponse>(`/${BeamFnExternalWorkerPool.typeName}/${method.name}`, (value: StartWorkerRequest): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): StartWorkerResponse => method.O.fromBinary(value, this._binaryOptions), input, (metadata as any), (options as any), (callback as any));
    }
    /**
     * Stop the SDK worker.
     *
     * @generated from protobuf rpc: StopWorker(org.apache.beam.model.fn_execution.v1.StopWorkerRequest) returns (org.apache.beam.model.fn_execution.v1.StopWorkerResponse);
     */
    stopWorker(input: StopWorkerRequest, metadata: grpc.Metadata | grpc.CallOptions | ((err: grpc.ServiceError | null, value?: StopWorkerResponse) => void), options?: grpc.CallOptions | ((err: grpc.ServiceError | null, value?: StopWorkerResponse) => void), callback?: ((err: grpc.ServiceError | null, value?: StopWorkerResponse) => void)): grpc.ClientUnaryCall {
        const method = BeamFnExternalWorkerPool.methods[1];
        return this.makeUnaryRequest<StopWorkerRequest, StopWorkerResponse>(`/${BeamFnExternalWorkerPool.typeName}/${method.name}`, (value: StopWorkerRequest): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): StopWorkerResponse => method.O.fromBinary(value, this._binaryOptions), input, (metadata as any), (options as any), (callback as any));
    }
}
/**
 * API for SDKs to report debug-related statuses to runner during pipeline execution.
 *
 * @generated from protobuf service org.apache.beam.model.fn_execution.v1.BeamFnWorkerStatus
 */
export interface IBeamFnWorkerStatusClient {
    /**
     * @generated from protobuf rpc: WorkerStatus(stream org.apache.beam.model.fn_execution.v1.WorkerStatusResponse) returns (stream org.apache.beam.model.fn_execution.v1.WorkerStatusRequest);
     */
    workerStatus(metadata: grpc.Metadata, options?: grpc.CallOptions): grpc.ClientDuplexStream<WorkerStatusResponse, WorkerStatusRequest>;
    workerStatus(options?: grpc.CallOptions): grpc.ClientDuplexStream<WorkerStatusResponse, WorkerStatusRequest>;
}
/**
 * API for SDKs to report debug-related statuses to runner during pipeline execution.
 *
 * @generated from protobuf service org.apache.beam.model.fn_execution.v1.BeamFnWorkerStatus
 */
export class BeamFnWorkerStatusClient extends grpc.Client implements IBeamFnWorkerStatusClient {
    private readonly _binaryOptions: Partial<BinaryReadOptions & BinaryWriteOptions>;
    constructor(address: string, credentials: grpc.ChannelCredentials, options: grpc.ClientOptions = {}, binaryOptions: Partial<BinaryReadOptions & BinaryWriteOptions> = {}) {
        super(address, credentials, options);
        this._binaryOptions = binaryOptions;
    }
    /**
     * @generated from protobuf rpc: WorkerStatus(stream org.apache.beam.model.fn_execution.v1.WorkerStatusResponse) returns (stream org.apache.beam.model.fn_execution.v1.WorkerStatusRequest);
     */
    workerStatus(metadata?: grpc.Metadata | grpc.CallOptions, options?: grpc.CallOptions): grpc.ClientDuplexStream<WorkerStatusResponse, WorkerStatusRequest> {
        const method = BeamFnWorkerStatus.methods[0];
        return this.makeBidiStreamRequest<WorkerStatusResponse, WorkerStatusRequest>(`/${BeamFnWorkerStatus.typeName}/${method.name}`, (value: WorkerStatusResponse): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): WorkerStatusRequest => method.O.fromBinary(value, this._binaryOptions), (metadata as any), options);
    }
}
