/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.winrm;

import com.google.common.annotations.Beta;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.function.Function;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.location.winrm.WinRmMachineLocation;
import org.apache.brooklyn.util.core.internal.winrm.winrm4j.PrettyXmlWriter;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.ssh.internal.AbstractSshExecTaskFactory;
import org.apache.brooklyn.util.core.task.ssh.internal.PlainSshExecTaskFactory;
import org.apache.brooklyn.util.core.task.ssh.internal.RemoteExecTaskConfigHelper;
import org.apache.brooklyn.util.core.task.system.ProcessTaskStub;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.commons.io.output.WriterOutputStream;

public class PlainWinRmExecTaskFactory<RET>
extends AbstractSshExecTaskFactory<PlainSshExecTaskFactory<RET>, RET> {
    public static final String WINRM_STREAM = "winrm";

    public PlainWinRmExecTaskFactory(String ... commands) {
        super(commands);
    }

    public PlainWinRmExecTaskFactory(WinRmMachineLocation machine, String ... commands) {
        this(commands);
        this.machine(machine);
    }

    public PlainWinRmExecTaskFactory(RemoteExecTaskConfigHelper.RemoteExecCapability remoteExecCapability, String ... commands) {
        this(commands);
        this.machine(this.machine);
        this.remoteExecCapability(remoteExecCapability);
    }

    protected String taskTypeShortName() {
        return "WinRM";
    }

    public <T2> PlainWinRmExecTaskFactory<T2> returning(ProcessTaskStub.ScriptReturnType type) {
        return (PlainWinRmExecTaskFactory)super.returning(type);
    }

    public <RET2> PlainWinRmExecTaskFactory<RET2> returning(Function<ProcessTaskWrapper<?>, RET2> resultTransformation) {
        return (PlainWinRmExecTaskFactory)super.returning(resultTransformation);
    }

    public PlainWinRmExecTaskFactory<Boolean> returningIsExitCodeZero() {
        return (PlainWinRmExecTaskFactory)super.returningIsExitCodeZero();
    }

    public PlainWinRmExecTaskFactory<String> requiringZeroAndReturningStdout() {
        return (PlainWinRmExecTaskFactory)super.requiringZeroAndReturningStdout();
    }

    protected AbstractSshExecTaskFactory.Std2x2StreamProvider getRichStreamProvider(TaskBuilder<?> tb) {
        return PlainWinRmExecTaskFactory.newStreamProviderForWindowsXml(tb);
    }

    @Beta
    public static AbstractSshExecTaskFactory.Std2x2StreamProvider newStreamProviderForWindowsXml(TaskBuilder<?> tb) {
        AbstractSshExecTaskFactory.Std2x2StreamProvider std2x2StreamProvider = new AbstractSshExecTaskFactory.Std2x2StreamProvider();
        std2x2StreamProvider.stdoutForReading = new ByteArrayOutputStream();
        std2x2StreamProvider.stdoutForWriting = std2x2StreamProvider.stdoutForReading;
        tb.tag((Object)BrooklynTaskTags.tagForStreamSoft((String)"stdout", (ByteArrayOutputStream)std2x2StreamProvider.stdoutForReading));
        ByteArrayOutputStream stderrXmlPrettyOut = new ByteArrayOutputStream();
        std2x2StreamProvider.stderrForWriting = new WriterOutputStream((Writer)new PrettyXmlWriter(new OutputStreamWriter(stderrXmlPrettyOut)));
        tb.tag((Object)BrooklynTaskTags.tagForStreamSoft((String)WINRM_STREAM, (ByteArrayOutputStream)stderrXmlPrettyOut));
        return std2x2StreamProvider;
    }
}

