/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigMap;
import org.apache.brooklyn.core.server.BrooklynServiceAttributes;
import org.apache.brooklyn.launcher.config.CustomResourceLocator;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.Identifiers;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppContextProvider {
    private static final Logger LOG = LoggerFactory.getLogger(WebAppContextProvider.class);
    protected final String pathSpec;
    protected final String warUrl;

    public WebAppContextProvider(String pathSpec, String warUrl) {
        this.warUrl = (String)Preconditions.checkNotNull((Object)warUrl, (Object)"warUrl");
        String cleanPathSpec = (String)Preconditions.checkNotNull((Object)pathSpec, (Object)"pathSpec");
        while (cleanPathSpec.startsWith("/")) {
            cleanPathSpec = cleanPathSpec.substring(1);
        }
        this.pathSpec = cleanPathSpec;
    }

    public WebAppContext get(ManagementContext managementContext, Map<String, Object> attributes, boolean ignoreFailures) {
        Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
        Preconditions.checkNotNull(attributes, (Object)"attributes");
        boolean isRoot = this.pathSpec.isEmpty();
        WebAppContext context = new WebAppContext();
        context.setInitParameter("org.eclipse.jetty.servlet.SessionCookie", "JSESSIONID_BROOKLYN" + Identifiers.makeRandomId((int)6));
        context.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        context.setAttribute(BrooklynServiceAttributes.BROOKLYN_MANAGEMENT_CONTEXT, (Object)managementContext);
        for (Map.Entry<String, Object> attributeEntry : attributes.entrySet()) {
            context.setAttribute(attributeEntry.getKey(), attributeEntry.getValue());
        }
        try {
            CustomResourceLocator locator = new CustomResourceLocator((ConfigMap)managementContext.getConfig(), ResourceUtils.create((Object)this));
            InputStream resource = locator.getResourceFromUrl(this.warUrl);
            String warName = isRoot ? "ROOT" : "embedded-" + this.pathSpec;
            File tmpWarFile = Os.writeToTempFile((InputStream)resource, (String)warName, (String)".war");
            context.setWar(tmpWarFile.getAbsolutePath());
        }
        catch (Exception e) {
            LOG.warn("Failed to deploy webapp " + this.pathSpec + " from " + this.warUrl + (ignoreFailures ? "; launching run without WAR" : " (rethrowing)") + ": " + Exceptions.collapseText((Throwable)e));
            if (!ignoreFailures) {
                throw new IllegalStateException("Failed to deploy webapp " + this.pathSpec + " from " + this.warUrl + ": " + Exceptions.collapseText((Throwable)e), e);
            }
            LOG.debug("Detail on failure to deploy webapp: " + e, (Throwable)e);
            context.setWar("/dev/null");
        }
        context.setContextPath("/" + this.pathSpec);
        context.setParentLoaderPriority(true);
        return context;
    }

    public String getPath() {
        return this.pathSpec;
    }

    public String getWarUrl() {
        return this.warUrl;
    }

    public String toString() {
        String path = this.pathSpec.isEmpty() ? "/" : this.pathSpec;
        return this.warUrl + "@" + path;
    }
}

