/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.container.location.docker;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.container.entity.docker.DockerContainer;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationCustomizer;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.docker.compute.options.DockerTemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerJcloudsLocation
extends JcloudsLocation {
    public static final ConfigKey<Boolean> INJECT_LOGIN_CREDENTIAL = ConfigKeys.newBooleanConfigKey((String)"injectLoginCredential", (String)"Whether to inject login credentials (if null, will infer from image choice)", null);
    public static final ConfigKey<String> DEFAULT_IMAGE_DESCRIPTION_REGEX = ConfigKeys.newStringConfigKey((String)"defaultImageDescriptionRegex", (String)"The default image description to use, if no other image preferences are supplied", (String)"brooklyncentral/centos:7");
    private static final Logger LOG = LoggerFactory.getLogger(DockerJcloudsLocation.class);
    private static final List<String> IMAGE_DESCRIPTION_REGEXES_REQUIRING_INJECTED_LOGIN_CREDS = ImmutableList.of((Object)"brooklyncentral/centos.*", (Object)"brooklyncentral/ubuntu.*");
    private static final List<ImageMetadata> DEFAULT_IMAGES = ImmutableList.of((Object)new ImageMetadata(OsFamily.CENTOS, "7", "brooklyncentral/centos:7"), (Object)new ImageMetadata(OsFamily.UBUNTU, "14.04", "brooklyncentral/ubuntu:14.04"), (Object)new ImageMetadata(OsFamily.UBUNTU, "16.04", "brooklyncentral/ubuntu:16.04"));

    protected MachineLocation obtainOnce(ConfigBag setup) throws NoMachinesAvailableException {
        setup.configure(JcloudsLocation.CLOUD_PROVIDER, (Object)"docker");
        String imageId = (String)setup.get(JcloudsLocation.IMAGE_ID);
        String imageNameRegex = (String)setup.get(JcloudsLocation.IMAGE_NAME_REGEX);
        String imageDescriptionRegex = (String)setup.get(JcloudsLocation.IMAGE_DESCRIPTION_REGEX);
        String defaultImageDescriptionRegex = (String)setup.get(DEFAULT_IMAGE_DESCRIPTION_REGEX);
        OsFamily osFamily = (OsFamily)setup.get(OS_FAMILY);
        String osVersionRegex = (String)setup.get(OS_VERSION_REGEX);
        if (Strings.isBlank((CharSequence)imageId) && Strings.isBlank((CharSequence)imageNameRegex) && Strings.isBlank((CharSequence)imageDescriptionRegex)) {
            if (osFamily != null || osVersionRegex != null) {
                for (ImageMetadata imageMetadata : DEFAULT_IMAGES) {
                    if (!imageMetadata.matches(osFamily, osVersionRegex)) continue;
                    String imageDescription = imageMetadata.getImageDescription();
                    LOG.debug("Setting default image regex to {}, for obtain call in {}; removing osFamily={} and osVersionRegex={}", new Object[]{imageDescription, this, osFamily, osVersionRegex});
                    setup.configure(JcloudsLocation.IMAGE_DESCRIPTION_REGEX, (Object)imageDescription);
                    setup.configure(OS_FAMILY, null);
                    setup.configure(OS_VERSION_REGEX, null);
                    break;
                }
            } else if (Strings.isNonBlank((CharSequence)defaultImageDescriptionRegex)) {
                LOG.debug("Setting default image regex to {}, for obtain call in {}", (Object)defaultImageDescriptionRegex, (Object)this);
                setup.configure(JcloudsLocation.IMAGE_DESCRIPTION_REGEX, (Object)defaultImageDescriptionRegex);
            }
        }
        return super.obtainOnce(setup);
    }

    public Template buildTemplate(ComputeService computeService, ConfigBag config, Collection<JcloudsLocationCustomizer> customizers) {
        String loginUser = (String)config.get(JcloudsLocation.LOGIN_USER);
        String loginPassword = (String)config.get(JcloudsLocation.LOGIN_USER_PASSWORD);
        String loginKeyFile = (String)config.get(JcloudsLocation.LOGIN_USER_PRIVATE_KEY_FILE);
        String loginKeyData = (String)config.get(JcloudsLocation.LOGIN_USER_PRIVATE_KEY_DATA);
        Template template = super.buildTemplate(computeService, config, customizers);
        DockerTemplateOptions templateOptions = (DockerTemplateOptions)template.getOptions();
        Image image = template.getImage();
        MutableList env = MutableList.copyOf((Iterable)templateOptions.getEnv());
        Boolean injectLoginCredentials = (Boolean)config.get(INJECT_LOGIN_CREDENTIAL);
        if (injectLoginCredentials == null) {
            String imageDescription = image.getDescription();
            for (String regex : IMAGE_DESCRIPTION_REGEXES_REQUIRING_INJECTED_LOGIN_CREDS) {
                if (imageDescription == null || !imageDescription.matches(regex)) continue;
                injectLoginCredentials = true;
                break;
            }
        }
        if (Strings.isBlank((CharSequence)loginUser) && Strings.isBlank((CharSequence)loginPassword) && Strings.isBlank((CharSequence)loginKeyFile) && Strings.isBlank((CharSequence)loginKeyData) && Boolean.TRUE.equals(injectLoginCredentials)) {
            loginUser = "root";
            loginPassword = Identifiers.makeRandomPassword((int)12);
            templateOptions.overrideLoginUser(loginUser);
            templateOptions.overrideLoginPassword(loginPassword);
            env.add("BROOKLYN_ROOT_PASSWORD=" + loginPassword);
        }
        Entity context = this.validateCallerContext(config);
        MutableMap containerEnv = MutableMap.copyOf((Map)((Map)context.config().get(DockerContainer.CONTAINER_ENVIRONMENT)));
        for (Map.Entry entry : Maps.transformValues((Map)containerEnv, (Function)Functions.toStringFunction()).entrySet()) {
            env.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        templateOptions.env((Iterable)env);
        return template;
    }

    private Entity validateCallerContext(ConfigBag setup) {
        Object callerContext = setup.get(LocationConfigKeys.CALLER_CONTEXT);
        if (callerContext == null || !(callerContext instanceof Entity)) {
            throw new IllegalStateException("Invalid caller context: " + callerContext);
        }
        return (Entity)callerContext;
    }

    private static class ImageMetadata {
        private final OsFamily osFamily;
        private final String osVersion;
        private final String imageDescription;

        public ImageMetadata(OsFamily osFamily, String osVersion, String imageDescription) {
            this.osFamily = (OsFamily)Preconditions.checkNotNull((Object)osFamily, (Object)"osFamily");
            this.osVersion = (String)Preconditions.checkNotNull((Object)osVersion, (Object)"osVersion");
            this.imageDescription = (String)Preconditions.checkNotNull((Object)imageDescription, (Object)"imageDescription");
        }

        public boolean matches(@Nullable OsFamily osFamily, @Nullable String osVersionRegex) {
            if (osFamily != null && osFamily != this.osFamily) {
                return false;
            }
            return osVersionRegex == null || this.osVersion.matches(osVersionRegex);
        }

        public String getImageDescription() {
            return this.imageDescription;
        }
    }
}

