/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.cm.ansible;

import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.entity.cm.ansible.AnsibleEntity;
import org.apache.brooklyn.entity.cm.ansible.AnsibleEntityDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.feed.CommandPollConfig;
import org.apache.brooklyn.feed.ssh.SshFeed;
import org.apache.brooklyn.feed.ssh.SshPollConfig;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnsibleEntityImpl
extends SoftwareProcessImpl
implements AnsibleEntity {
    private static final Logger LOG = LoggerFactory.getLogger(AnsibleEntityImpl.class);
    private SshFeed feed;

    public Class getDriverInterface() {
        return AnsibleEntityDriver.class;
    }

    public AnsibleEntityDriver getDriver() {
        return (AnsibleEntityDriver)super.getDriver();
    }

    protected void connectSensors() {
        super.connectSensors();
        Maybe machine = Locations.findUniqueSshMachineLocation((Iterable)this.getLocations());
        if (machine.isPresent()) {
            String cmd = this.getDriver().getStatusCmd();
            this.feed = (SshFeed)((SshFeed.Builder)((SshFeed.Builder)((SshFeed.Builder)SshFeed.builder().entity((Entity)this)).period((Duration)this.config().get(SERVICE_PROCESS_IS_RUNNING_POLL_PERIOD))).machine((MachineLocation)machine.get())).poll((CommandPollConfig)((CommandPollConfig)new SshPollConfig(SERVICE_UP).command(cmd).setOnSuccess((Object)true)).setOnFailureOrException((Object)false)).build();
        } else {
            LOG.warn("Location(s) {} not an ssh-machine location, so not polling for status; setting serviceUp immediately", (Object)this.getLocations());
            this.sensors().set(SERVICE_UP, (Object)true);
        }
    }

    protected void disconnectSensors() {
        if (this.feed != null) {
            this.feed.stop();
        }
        super.disconnectSensors();
    }

    public void populateServiceNotUpDiagnostics() {
    }

    @Override
    public String ansibleCommand(String module, String args) {
        ProcessTaskWrapper<Integer> command = this.getDriver().ansibleCommand(module, args);
        command.asTask().blockUntilEnded();
        if (0 == command.getExitCode()) {
            return command.getStdout();
        }
        throw new RuntimeException("Command (" + args + ") in module " + module + " failed with stderr:\n" + command.getStderr() + "\n");
    }
}

