/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1alpha1.kameletbindingspec.integration.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.Owner;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.owner.Configuration;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.owner.ConfigurationBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.owner.ConfigurationFluent;

public class OwnerFluent<A extends OwnerFluent<A>>
extends BaseFluent<A> {
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private List<String> targetAnnotations;
    private List<String> targetLabels;

    public OwnerFluent() {
    }

    public OwnerFluent(Owner instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Owner instance) {
        Owner owner = instance = instance != null ? instance : new Owner();
        if (instance != null) {
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withTargetAnnotations(instance.getTargetAnnotations());
            this.withTargetLabels(instance.getTargetLabels());
        }
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public A addToTargetAnnotations(int index, String item) {
        if (this.targetAnnotations == null) {
            this.targetAnnotations = new ArrayList<String>();
        }
        this.targetAnnotations.add(index, item);
        return (A)((Object)this);
    }

    public A setToTargetAnnotations(int index, String item) {
        if (this.targetAnnotations == null) {
            this.targetAnnotations = new ArrayList<String>();
        }
        this.targetAnnotations.set(index, item);
        return (A)((Object)this);
    }

    public A addToTargetAnnotations(String ... items) {
        if (this.targetAnnotations == null) {
            this.targetAnnotations = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetAnnotations.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTargetAnnotations(Collection<String> items) {
        if (this.targetAnnotations == null) {
            this.targetAnnotations = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetAnnotations.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTargetAnnotations(String ... items) {
        if (this.targetAnnotations == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.targetAnnotations.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTargetAnnotations(Collection<String> items) {
        if (this.targetAnnotations == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.targetAnnotations.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTargetAnnotations() {
        return this.targetAnnotations;
    }

    public String getTargetAnnotation(int index) {
        return this.targetAnnotations.get(index);
    }

    public String getFirstTargetAnnotation() {
        return this.targetAnnotations.get(0);
    }

    public String getLastTargetAnnotation() {
        return this.targetAnnotations.get(this.targetAnnotations.size() - 1);
    }

    public String getMatchingTargetAnnotation(Predicate<String> predicate) {
        for (String item : this.targetAnnotations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTargetAnnotation(Predicate<String> predicate) {
        for (String item : this.targetAnnotations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTargetAnnotations(List<String> targetAnnotations) {
        if (targetAnnotations != null) {
            this.targetAnnotations = new ArrayList<String>();
            for (String item : targetAnnotations) {
                this.addToTargetAnnotations(item);
            }
        } else {
            this.targetAnnotations = null;
        }
        return (A)((Object)this);
    }

    public A withTargetAnnotations(String ... targetAnnotations) {
        if (this.targetAnnotations != null) {
            this.targetAnnotations.clear();
            this._visitables.remove((Object)"targetAnnotations");
        }
        if (targetAnnotations != null) {
            for (String item : targetAnnotations) {
                this.addToTargetAnnotations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTargetAnnotations() {
        return this.targetAnnotations != null && !this.targetAnnotations.isEmpty();
    }

    public A addToTargetLabels(int index, String item) {
        if (this.targetLabels == null) {
            this.targetLabels = new ArrayList<String>();
        }
        this.targetLabels.add(index, item);
        return (A)((Object)this);
    }

    public A setToTargetLabels(int index, String item) {
        if (this.targetLabels == null) {
            this.targetLabels = new ArrayList<String>();
        }
        this.targetLabels.set(index, item);
        return (A)((Object)this);
    }

    public A addToTargetLabels(String ... items) {
        if (this.targetLabels == null) {
            this.targetLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTargetLabels(Collection<String> items) {
        if (this.targetLabels == null) {
            this.targetLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTargetLabels(String ... items) {
        if (this.targetLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.targetLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTargetLabels(Collection<String> items) {
        if (this.targetLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.targetLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTargetLabels() {
        return this.targetLabels;
    }

    public String getTargetLabel(int index) {
        return this.targetLabels.get(index);
    }

    public String getFirstTargetLabel() {
        return this.targetLabels.get(0);
    }

    public String getLastTargetLabel() {
        return this.targetLabels.get(this.targetLabels.size() - 1);
    }

    public String getMatchingTargetLabel(Predicate<String> predicate) {
        for (String item : this.targetLabels) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTargetLabel(Predicate<String> predicate) {
        for (String item : this.targetLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTargetLabels(List<String> targetLabels) {
        if (targetLabels != null) {
            this.targetLabels = new ArrayList<String>();
            for (String item : targetLabels) {
                this.addToTargetLabels(item);
            }
        } else {
            this.targetLabels = null;
        }
        return (A)((Object)this);
    }

    public A withTargetLabels(String ... targetLabels) {
        if (this.targetLabels != null) {
            this.targetLabels.clear();
            this._visitables.remove((Object)"targetLabels");
        }
        if (targetLabels != null) {
            for (String item : targetLabels) {
                this.addToTargetLabels(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTargetLabels() {
        return this.targetLabels != null && !this.targetLabels.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OwnerFluent that = (OwnerFluent)((Object)o);
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.targetAnnotations, that.targetAnnotations)) {
            return false;
        }
        return Objects.equals(this.targetLabels, that.targetLabels);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configuration, this.enabled, this.targetAnnotations, this.targetLabels, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.targetAnnotations != null && !this.targetAnnotations.isEmpty()) {
            sb.append("targetAnnotations:");
            sb.append(this.targetAnnotations + ",");
        }
        if (this.targetLabels != null && !this.targetLabels.isEmpty()) {
            sb.append("targetLabels:");
            sb.append(this.targetLabels);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)OwnerFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

