/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1alpha1.Kamelet;
import org.apache.camel.v1alpha1.KameletSpec;
import org.apache.camel.v1alpha1.KameletSpecBuilder;
import org.apache.camel.v1alpha1.KameletSpecFluent;
import org.apache.camel.v1alpha1.KameletStatus;
import org.apache.camel.v1alpha1.KameletStatusBuilder;
import org.apache.camel.v1alpha1.KameletStatusFluent;

public class KameletFluent<A extends KameletFluent<A>>
extends BaseFluent<A> {
    private ObjectMetaBuilder metadata;
    private KameletSpecBuilder spec;
    private KameletStatusBuilder status;
    private String kind;
    private String apiVersion;

    public KameletFluent() {
    }

    public KameletFluent(Kamelet instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Kamelet instance) {
        Kamelet kamelet = instance = instance != null ? instance : new Kamelet();
        if (instance != null) {
            this.withMetadata(instance.getMetadata());
            this.withSpec((KameletSpec)instance.getSpec());
            this.withStatus((KameletStatus)instance.getStatus());
            this.withKind(instance.getKind());
            this.withApiVersion(instance.getApiVersion());
        }
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public KameletSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    public A withSpec(KameletSpec spec) {
        this._visitables.remove((Object)"spec");
        if (spec != null) {
            this.spec = new KameletSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get((Object)"spec").remove((Object)this.spec);
        }
        return (A)((Object)this);
    }

    public boolean hasSpec() {
        return this.spec != null;
    }

    public SpecNested<A> withNewSpec() {
        return new SpecNested(null);
    }

    public SpecNested<A> withNewSpecLike(KameletSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<A> editSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(null));
    }

    public SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(new KameletSpecBuilder().build()));
    }

    public SpecNested<A> editOrNewSpecLike(KameletSpec item) {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(item));
    }

    public KameletStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    public A withStatus(KameletStatus status) {
        this._visitables.remove((Object)"status");
        if (status != null) {
            this.status = new KameletStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove((Object)this.status);
        }
        return (A)((Object)this);
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public StatusNested<A> withNewStatus() {
        return new StatusNested(null);
    }

    public StatusNested<A> withNewStatusLike(KameletStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<A> editStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(null));
    }

    public StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(new KameletStatusBuilder().build()));
    }

    public StatusNested<A> editOrNewStatusLike(KameletStatus item) {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(item));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KameletFluent that = (KameletFluent)((Object)o);
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals((Object)this.spec, (Object)that.spec)) {
            return false;
        }
        if (!Objects.equals((Object)this.status, (Object)that.status)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.apiVersion, that.apiVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metadata, this.spec, this.status, this.kind, this.apiVersion, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)KameletFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class SpecNested<N>
    extends KameletSpecFluent<SpecNested<N>>
    implements Nested<N> {
        KameletSpecBuilder builder;

        SpecNested(KameletSpec item) {
            this.builder = new KameletSpecBuilder(this, item);
        }

        public N and() {
            return (N)KameletFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class StatusNested<N>
    extends KameletStatusFluent<StatusNested<N>>
    implements Nested<N> {
        KameletStatusBuilder builder;

        StatusNested(KameletStatus item) {
            this.builder = new KameletStatusBuilder(this, item);
        }

        public N and() {
            return (N)KameletFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }
}

