/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.cayenne.access.trans.BatchQueryBuilder;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.DeleteBatchQuery;

public class DeleteBatchQueryBuilder
extends BatchQueryBuilder {
    public DeleteBatchQueryBuilder(DbAdapter adapter) {
        super(adapter);
    }

    public String createSqlString(BatchQuery batch) throws IOException {
        boolean status = batch.getDbEntity().getDataMap() != null && batch.getDbEntity().getDataMap().isQuotingSQLIdentifiers();
        QuotingStrategy strategy = this.getAdapter().getQuotingStrategy(status);
        StringBuffer query = new StringBuffer("DELETE FROM ");
        query.append(strategy.quoteFullyQualifiedName(batch.getDbEntity()));
        this.applyQualifier(query, batch);
        return query.toString();
    }

    protected void applyQualifier(StringBuffer query, BatchQuery batch) {
        query.append(" WHERE ");
        DeleteBatchQuery deleteBatch = (DeleteBatchQuery)batch;
        Iterator<DbAttribute> i = deleteBatch.getQualifierAttributes().iterator();
        while (i.hasNext()) {
            DbAttribute attribute = i.next();
            this.appendDbAttribute(query, attribute);
            query.append(deleteBatch.isNull(attribute) ? " IS NULL" : " = ?");
            if (!i.hasNext()) continue;
            query.append(" AND ");
        }
    }

    public void bindParameters(PreparedStatement statement, BatchQuery query) throws SQLException, Exception {
        DeleteBatchQuery deleteBatch = (DeleteBatchQuery)query;
        int parameterIndex = this.getFirstParameterIndex(query);
        int i = 0;
        for (DbAttribute attribute : deleteBatch.getQualifierAttributes()) {
            Object value = query.getValue(i++);
            if (deleteBatch.isNull(attribute)) continue;
            this.adapter.bindParameter(statement, value, parameterIndex++, attribute.getType(), attribute.getScale());
        }
    }

    protected int getFirstParameterIndex(BatchQuery query) {
        return 1;
    }
}

