/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.event.EntityListenerEvent;
import org.apache.cayenne.modeler.util.CayenneAction;

public class ChangeObjEntityListenerClassAction
extends CayenneAction {
    private static final String ACTION_NAME = "Change objentity entity listener class";

    public ChangeObjEntityListenerClassAction(Application application) {
        super(ChangeObjEntityListenerClassAction.getActionName(), application);
    }

    protected ChangeObjEntityListenerClassAction(String name, Application application) {
        super(name, application);
    }

    public static String getActionName() {
        return ACTION_NAME;
    }

    public String getIconName() {
        return "icon-change-listener.gif";
    }

    protected boolean isListenerClassAlreadyExists(String className) {
        return this.getProjectController().getCurrentObjEntity().getEntityListener(className) != null;
    }

    protected void renameEntityListener(String prevListenerClass, String newListenerClass) {
        this.getProjectController().getCurrentObjEntity().getEntityListener(prevListenerClass).setClassName(newListenerClass);
    }

    public void performAction(ActionEvent e) {
        String currentListenerClass = this.getProjectController().getCurrentListenerClass();
        String newListenerClass = JOptionPane.showInputDialog("Please enter listener class:", (Object)currentListenerClass);
        if (newListenerClass != null && newListenerClass.trim().length() > 0) {
            if (this.isListenerClassAlreadyExists(newListenerClass)) {
                JOptionPane.showMessageDialog(null, "Listener class already exists.", "Error creating entity listener", 0);
            } else {
                this.renameEntityListener(currentListenerClass, newListenerClass);
                this.getProjectController().fireEntityListenerEvent(new EntityListenerEvent(e.getSource(), currentListenerClass, newListenerClass, 2));
            }
        }
    }
}

