/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.modeler.dialog.TableModel;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.swing.ImageRendererColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindDialogView
extends JDialog {
    private JButton okButton;
    private static JScrollPane scrollPane;
    private JTable table;
    private static Map LabelAndObjectIndex;

    public static Map getLabelAndObjectIndex() {
        return LabelAndObjectIndex;
    }

    public JTable getTable() {
        return this.table;
    }

    public FindDialogView(Map objEntityNames, Map dbEntityNames, Map attrNames, Map relatNames, Map queryNames, Map embeddableNames, Map embeddableAttributeNames) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        if (objEntityNames.isEmpty() && dbEntityNames.isEmpty() && attrNames.isEmpty() && relatNames.isEmpty() && queryNames.isEmpty() && embeddableNames.isEmpty() && embeddableAttributeNames.isEmpty()) {
            panel.add(new JLabel("Nothing found!"));
        } else {
            int curentLineInTable = 0;
            int sizeDataVector = objEntityNames.size() + dbEntityNames.size() + attrNames.size() + relatNames.size() + queryNames.size() + embeddableNames.size() + embeddableAttributeNames.size();
            Object[][] dataVector = new Object[sizeDataVector][];
            TableModel tableModel = new TableModel();
            LabelAndObjectIndex = new HashMap();
            dataVector = this.createResultTable(objEntityNames, CellRenderers.iconForObject(new ObjEntity()), dataVector, curentLineInTable);
            curentLineInTable = objEntityNames.size();
            dataVector = this.createResultTable(embeddableNames, CellRenderers.iconForObject(new Embeddable()), dataVector, curentLineInTable);
            dataVector = this.createResultTable(dbEntityNames, CellRenderers.iconForObject(new DbEntity()), dataVector, curentLineInTable += embeddableNames.size());
            dataVector = this.createResultTable(attrNames, CellRenderers.iconForObject(new ObjAttribute()), dataVector, curentLineInTable += dbEntityNames.size());
            dataVector = this.createResultTable(embeddableAttributeNames, CellRenderers.iconForObject(new ObjAttribute()), dataVector, curentLineInTable += attrNames.size());
            dataVector = this.createResultTable(relatNames, CellRenderers.iconForObject(new ObjRelationship()), dataVector, curentLineInTable += embeddableAttributeNames.size());
            dataVector = this.createResultTable(queryNames, CellRenderers.iconForObject(new SelectQuery()), dataVector, curentLineInTable += relatNames.size());
            tableModel.setDataVector(dataVector, new Object[]{""});
            this.table = new JTable(tableModel);
            this.table.getColumnModel().getColumn(0).setCellRenderer(new ImageRendererColumn());
            this.table.setSelectionMode(0);
            InputMap im = this.table.getInputMap(1);
            InputMap imParent = im.getParent();
            imParent.remove(KeyStroke.getKeyStroke(10, 0));
            im.setParent(imParent);
            im.remove(KeyStroke.getKeyStroke(10, 0));
            this.table.setInputMap(1, im);
        }
        JPanel okPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton("OK");
        okPanel.add(this.okButton);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        scrollPane = new JScrollPane(this.table, 20, 30);
        contentPane.add(scrollPane);
        contentPane.add((Component)okPanel, "South");
        contentPane.setPreferredSize(new Dimension(400, 325));
        this.setTitle("Search results");
    }

    private Object[][] createResultTable(Map names, Icon icon, Object[][] dataVector, int curentLineInTable) {
        Comparator<String> comparer = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        Map sortedByNameMap = this.sortMapByValue(names, comparer);
        Iterator it = sortedByNameMap.keySet().iterator();
        Object[] objectHelper = new Object[]{};
        while (it.hasNext()) {
            Integer index = (Integer)it.next();
            JLabel labelIcon = new JLabel();
            labelIcon.setIcon(icon);
            labelIcon.setVisible(true);
            labelIcon.setText(sortedByNameMap.get(index));
            objectHelper = new Object[]{labelIcon};
            dataVector[curentLineInTable] = objectHelper;
            LabelAndObjectIndex.put(labelIcon, index);
            ++curentLineInTable;
        }
        return dataVector;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public <K, V> Map<K, V> sortMapByValue(Map<K, V> in, Comparator<? super V> compare) {
        TreeMap<K, K> swapped = new TreeMap<K, K>(compare);
        for (Map.Entry<K, V> entry : in.entrySet()) {
            if (entry.getValue() == null) continue;
            swapped.put(entry.getValue(), entry.getKey());
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : swapped.entrySet()) {
            if (entry.getValue() == null) continue;
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }
}

