/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.datadomain;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.DomainEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datadomain.CacheSyncConfigView;
import org.apache.cayenne.modeler.dialog.datadomain.CustomRemoteEventsConfigPanel;
import org.apache.cayenne.modeler.dialog.datadomain.JGroupsConfigPanel;
import org.apache.cayenne.modeler.dialog.datadomain.JMSConfigPanel;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheSyncConfigController
extends CayenneController {
    private static Log logObj = LogFactory.getLog(CacheSyncConfigController.class);
    private static final String JGROUPS_FACTORY_CLASS = "org.apache.cayenne.event.JavaGroupsBridgeFactory";
    private static final String JMS_FACTORY_CLASS = "org.apache.cayenne.event.JMSBridgeFactory";
    public static final String SAVE_CONFIG_CONTROL = "Done";
    public static final String CANCEL_CONFIG_CONTROL = "Cancel";
    public static final String JGROUPS_DEFAULT_CONTROL = "Standard Configuration";
    public static final String JGROUPS_URL_CONTROL = "Use Configuration File";
    public static final String JGROUPS_FACTORY_LABEL = "JavaGroups Multicast (Default)";
    public static final String JMS_FACTORY_LABEL = "JMS Transport";
    public static final String CUSTOM_FACTORY_LABEL = "Custom Transport";
    protected Map existingCards;
    protected Map properties;
    protected boolean modified;
    protected ProjectController eventController;
    protected CacheSyncConfigView view;

    public CacheSyncConfigController(ProjectController eventController) {
        super(eventController);
        this.eventController = eventController;
    }

    public void startup() {
        DataChannelDescriptor domain = (DataChannelDescriptor)this.eventController.getProject().getRootNode();
        String factory = domain.getProperties().get("cayenne.DataRowStore.EventBridge.factory");
        this.view = new CacheSyncConfigView();
        this.initView();
        this.properties = new HashMap<String, String>(((DataChannelDescriptor)this.eventController.getProject().getRootNode()).getProperties());
        this.prepareChildren(factory);
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }

    public Component getView() {
        return this.view;
    }

    private void initView() {
        this.view.getCancelButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CacheSyncConfigController.this.view.dispose();
            }
        });
        this.view.getSaveButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CacheSyncConfigController.this.commitChanges();
            }
        });
        this.view.getTypeSelector().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CacheSyncConfigController.this.selectCard();
            }
        });
    }

    protected void selectCard() {
        this.view.showCard((String)this.view.getTypeSelector().getSelectedItem());
    }

    protected void jgroupsDefaultConfig() {
        JGroupsConfigPanel view = (JGroupsConfigPanel)this.existingCards.get(JGROUPS_FACTORY_LABEL);
        if (view != null) {
            view.showDefaultConfig();
        }
    }

    protected void jgroupsURLConfig() {
        JGroupsConfigPanel view = (JGroupsConfigPanel)this.existingCards.get(JGROUPS_FACTORY_LABEL);
        if (view != null) {
            view.showCustomConfig();
        }
    }

    protected void commitChanges() {
        DataChannelDescriptor domain = (DataChannelDescriptor)this.eventController.getProject().getRootNode();
        logObj.warn("domain properties BEFORE: " + domain.getProperties());
        Map<String, String> props = domain.getProperties();
        String type = (String)this.view.getTypeSelector().getSelectedItem();
        if (JGROUPS_FACTORY_LABEL.equals(type)) {
            JGroupsConfigPanel jgroupsPanel = (JGroupsConfigPanel)this.existingCards.get(JGROUPS_FACTORY_LABEL);
            props.put("cayenne.DataRowStore.EventBridge.factory", JGROUPS_FACTORY_CLASS);
            if (jgroupsPanel.useConfigFile.isSelected()) {
                props.remove("cayenne.JavaGroupsBridge.mcast.address");
                props.remove("cayenne.JavaGroupsBridge.mcast.port");
                if (!"".equals(jgroupsPanel.configURL.getText())) {
                    props.put("javagroupsbridge.config.url", jgroupsPanel.configURL.getText());
                } else {
                    props.put("javagroupsbridge.config.url", null);
                }
            } else {
                props.remove("javagroupsbridge.config.url");
                if (!"".equals(jgroupsPanel.multicastAddress.getText())) {
                    props.put("cayenne.JavaGroupsBridge.mcast.address", jgroupsPanel.multicastAddress.getText());
                } else {
                    props.put("cayenne.JavaGroupsBridge.mcast.address", null);
                }
                if (!"".equals(jgroupsPanel.multicastPort.getText())) {
                    props.put("cayenne.JavaGroupsBridge.mcast.port", jgroupsPanel.multicastPort.getText());
                } else {
                    props.put("cayenne.JavaGroupsBridge.mcast.port", null);
                }
            }
        } else if (JMS_FACTORY_LABEL.equals(type)) {
            JMSConfigPanel jmsPanel = (JMSConfigPanel)this.existingCards.get(JMS_FACTORY_LABEL);
            props.put("cayenne.DataRowStore.EventBridge.factory", JMS_FACTORY_CLASS);
            if (!"".equals(jmsPanel.topicFactory.getText())) {
                props.put("cayenne.JMSBridge.topic.connection.factory", jmsPanel.topicFactory.getText());
            } else {
                props.put("cayenne.JMSBridge.topic.connection.factory", null);
            }
        } else if (CUSTOM_FACTORY_LABEL.equals(type)) {
            CustomRemoteEventsConfigPanel customPanel = (CustomRemoteEventsConfigPanel)this.existingCards.get(CUSTOM_FACTORY_LABEL);
            if (!"".equals(customPanel.factoryClass.getText())) {
                props.put("cayenne.DataRowStore.EventBridge.factory", customPanel.factoryClass.getText());
            } else {
                props.put("cayenne.DataRowStore.EventBridge.factory", null);
            }
        }
        logObj.warn("domain properties: " + domain.getProperties());
        this.eventController.fireDomainEvent(new DomainEvent((Object)this, domain));
        this.view.dispose();
    }

    protected void loadProperties(String factory) {
        String configUrl = (String)this.properties.get("javagroupsbridge.config.url");
        String multicastAddress = (String)this.properties.get("cayenne.JavaGroupsBridge.mcast.address");
        String multicastPort = (String)this.properties.get("cayenne.JavaGroupsBridge.mcast.port");
        String topicFactory = (String)this.properties.get("cayenne.JMSBridge.topic.connection.factory");
        JGroupsConfigPanel jgroupsPanel = (JGroupsConfigPanel)this.existingCards.get(JGROUPS_FACTORY_LABEL);
        if (configUrl != null) {
            jgroupsPanel.useConfigFile.setSelected(true);
            this.jgroupsURLConfig();
            jgroupsPanel.configURL.setText(configUrl);
        } else {
            jgroupsPanel.useDefaultConfig.setSelected(true);
            this.jgroupsDefaultConfig();
        }
        if (multicastAddress != null) {
            jgroupsPanel.multicastAddress.setText(multicastAddress);
        } else {
            jgroupsPanel.multicastAddress.setText("228.0.0.5");
        }
        if (multicastPort != null) {
            jgroupsPanel.multicastPort.setText(multicastPort);
        } else {
            jgroupsPanel.multicastPort.setText("22222");
        }
        JMSConfigPanel jmsPanel = (JMSConfigPanel)this.existingCards.get(JMS_FACTORY_LABEL);
        if (topicFactory != null) {
            jmsPanel.topicFactory.setText(topicFactory);
        } else {
            jmsPanel.topicFactory.setText("JmsTopicConnectionFactory");
        }
        CustomRemoteEventsConfigPanel customPanel = (CustomRemoteEventsConfigPanel)this.existingCards.get(CUSTOM_FACTORY_LABEL);
        String factoryClass = (String)this.properties.get("cayenne.DataRowStore.EventBridge.factory");
        if (factoryClass != null) {
            customPanel.factoryClass.setText(factoryClass);
        } else {
            customPanel.factoryClass.setText(JGROUPS_FACTORY_CLASS);
        }
        if (JGROUPS_FACTORY_CLASS.equals(factory)) {
            this.view.getTypeSelector().setSelectedItem(JGROUPS_FACTORY_LABEL);
        } else if (JMS_FACTORY_CLASS.equals(factory)) {
            this.view.getTypeSelector().setSelectedItem(JMS_FACTORY_LABEL);
        } else {
            this.view.getTypeSelector().setSelectedItem(CUSTOM_FACTORY_LABEL);
        }
    }

    protected void prepareChildren(String factory) {
        this.existingCards = new HashMap();
        CacheSyncConfigView topView = (CacheSyncConfigView)this.getView();
        JGroupsConfigPanel jgroupsPanel = new JGroupsConfigPanel();
        this.existingCards.put(JGROUPS_FACTORY_LABEL, jgroupsPanel);
        topView.addCard(jgroupsPanel, JGROUPS_FACTORY_LABEL);
        jgroupsPanel.getUseDefaultConfig().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CacheSyncConfigController.this.jgroupsDefaultConfig();
            }
        });
        jgroupsPanel.getUseConfigFile().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CacheSyncConfigController.this.jgroupsURLConfig();
            }
        });
        JMSConfigPanel jmsPanel = new JMSConfigPanel();
        this.existingCards.put(JMS_FACTORY_LABEL, jmsPanel);
        topView.addCard(jmsPanel, JMS_FACTORY_LABEL);
        CustomRemoteEventsConfigPanel customFactoryPanel = new CustomRemoteEventsConfigPanel();
        this.existingCards.put(CUSTOM_FACTORY_LABEL, customFactoryPanel);
        topView.addCard(customFactoryPanel, CUSTOM_FACTORY_LABEL);
        if (factory == null) {
            factory = JGROUPS_FACTORY_CLASS;
        }
        if (JGROUPS_FACTORY_CLASS.equals(factory)) {
            ((CacheSyncConfigView)this.getView()).showCard(JGROUPS_FACTORY_LABEL);
        } else if (JMS_FACTORY_CLASS.equals(factory)) {
            ((CacheSyncConfigView)this.getView()).showCard(JMS_FACTORY_LABEL);
        } else {
            ((CacheSyncConfigView)this.getView()).showCard(CUSTOM_FACTORY_LABEL);
        }
        this.loadProperties(factory);
    }
}

