/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph.action;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.FindDialog;
import org.apache.cayenne.modeler.graph.GraphBuilder;
import org.apache.cayenne.modeler.util.CayenneAction;

public class EntityDisplayAction
extends CayenneAction {
    CayenneAction delegate;
    GraphBuilder builder;

    public EntityDisplayAction(GraphBuilder builder) {
        super("Show", Application.getInstance());
        this.builder = builder;
        this.init();
    }

    public EntityDisplayAction(GraphBuilder builder, CayenneAction delegate) {
        super((String)delegate.getValue("Name"), Application.getInstance());
        this.delegate = delegate;
        this.builder = builder;
        this.init();
    }

    private void init() {
        this.setEnabled(true);
        Icon icon = this.createIcon();
        if (icon != null) {
            super.putValue("SmallIcon", icon);
        }
    }

    public void performAction(ActionEvent e) {
        if (this.display() && this.delegate != null) {
            this.delegate.performAction(e);
        }
    }

    boolean display() {
        Entity entity = this.builder.getSelectedEntity();
        if (entity == null) {
            return false;
        }
        ProjectController mediator = this.getProjectController();
        FindDialog.jumpToResult(new Object[]{this.getApplication().getProject(), (DataChannelDescriptor)mediator.getProject().getRootNode(), entity.getDataMap(), entity});
        return true;
    }

    public String getIconName() {
        if (this.delegate != null) {
            return this.delegate.getIconName();
        }
        return null;
    }

    public boolean enableForPath(ConfigurationNode object) {
        return this.builder.getSelectedEntity() != null;
    }
}

