/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellRenderer;
import org.apache.cayenne.modeler.util.BevelArrowIcon;
import org.apache.cayenne.modeler.util.BlankIcon;

public class SortButtonRenderer
extends JButton
implements TableCellRenderer {
    public static final int NONE = 0;
    public static final int DOWN = 1;
    public static final int UP = 2;
    private int pushedColumn;
    private Hashtable state;
    private JButton downButton;
    private JButton upButton;

    public SortButtonRenderer() {
        MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 1, 1, Color.gray);
        this.setBorder(matteBorder);
        this.pushedColumn = -1;
        this.state = new Hashtable();
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setHorizontalTextPosition(0);
        this.setIcon(new BlankIcon());
        this.downButton = new JButton();
        this.downButton.setBorder(matteBorder);
        this.downButton.setMargin(new Insets(0, 0, 0, 0));
        this.downButton.setHorizontalTextPosition(2);
        this.downButton.setIcon(new BevelArrowIcon(1, false, false));
        this.downButton.setPressedIcon(new BevelArrowIcon(1, false, true));
        this.upButton = new JButton();
        this.upButton.setBorder(matteBorder);
        this.upButton.setMargin(new Insets(0, 0, 0, 0));
        this.upButton.setHorizontalTextPosition(2);
        this.upButton.setIcon(new BevelArrowIcon(0, false, false));
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JButton button = this;
        Object obj = this.state.get(new Integer(column));
        if (obj != null) {
            button = (Integer)obj == 1 ? this.downButton : this.upButton;
        }
        button.setText(value == null ? "" : value.toString());
        return button;
    }

    public void setPressedColumn(int col) {
        this.pushedColumn = col;
    }

    public void setSelectedColumn(int col, boolean isAscOrder) {
        if (col < 0) {
            return;
        }
        Integer value = null;
        value = isAscOrder ? new Integer(1) : new Integer(2);
        this.state.clear();
        this.state.put(new Integer(col), value);
    }

    public int getState(int col) {
        Object obj = this.state.get(new Integer(col));
        int retValue = obj == null ? 0 : ((Integer)obj == 1 ? 1 : 2);
        return retValue;
    }
}

