/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.upgrade.v6;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectSaver;
import org.apache.cayenne.project.upgrade.BaseUpgradeHandler;
import org.apache.cayenne.project.upgrade.UpgradeMetaData;
import org.apache.cayenne.project.upgrade.UpgradeType;
import org.apache.cayenne.project.upgrade.v6.XMLDataChannelDescriptorLoader_V3_0_0_1;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.Util;

class UpgradeHandler_V6
extends BaseUpgradeHandler {
    static final String TO_VERSION = "6";
    static final String MIN_SUPPORTED_VERSION = "3.0.0.1";
    private XMLDataChannelDescriptorLoader_V3_0_0_1 projectLoader = new XMLDataChannelDescriptorLoader_V3_0_0_1();
    @Inject
    private ProjectSaver projectSaver;

    UpgradeHandler_V6(Resource source) {
        super(source);
    }

    protected UpgradeMetaData loadMetaData() {
        String version = this.loadProjectVersion();
        UpgradeMetaData metadata = new UpgradeMetaData();
        metadata.setSupportedVersion(TO_VERSION);
        metadata.setProjectVersion(version);
        int c1 = this.compareVersions(version, MIN_SUPPORTED_VERSION);
        int c2 = this.compareVersions(TO_VERSION, version);
        if (c1 < 0) {
            metadata.setIntermediateUpgradeVersion(MIN_SUPPORTED_VERSION);
            metadata.setUpgradeType(UpgradeType.INTERMEDIATE_UPGRADE_NEEDED);
        } else if (c2 < 0) {
            metadata.setUpgradeType(UpgradeType.DOWNGRADE_NEEDED);
        } else if (c2 == 0) {
            metadata.setUpgradeType(UpgradeType.UPGRADE_NOT_NEEDED);
        } else {
            metadata.setUpgradeType(UpgradeType.UPGRADE_NEEDED);
        }
        return metadata;
    }

    protected Resource doPerformUpgrade() throws ConfigurationException {
        List<DataChannelDescriptor> domains = this.projectLoader.load(this.projectSource);
        if (domains.isEmpty()) {
            DataChannelDescriptor descriptor = new DataChannelDescriptor();
            descriptor.setName("DEFAULT");
            domains.add(descriptor);
        }
        ArrayList<Resource> resourcesToDelete = new ArrayList<Resource>();
        for (DataChannelDescriptor descriptor : domains) {
            for (DataNodeDescriptor node : descriptor.getNodeDescriptors()) {
                Resource nodeResource = node.getConfigurationSource();
                if (nodeResource == null) continue;
                resourcesToDelete.add(nodeResource);
            }
        }
        for (DataChannelDescriptor descriptor : domains) {
            Project project = new Project(new ConfigurationTree<DataChannelDescriptor>(descriptor));
            EntityResolver entityResolver = new EntityResolver(((DataChannelDescriptor)project.getRootNode()).getDataMaps());
            for (DataMap map : entityResolver.getDataMaps()) {
                map.setNamespace(entityResolver);
            }
            this.projectSaver.save(project);
        }
        for (Resource resource : resourcesToDelete) {
            try {
                File file = Util.toFile(resource.getURL());
                if (!file.exists() || !file.getName().endsWith(".driver.xml")) continue;
                file.delete();
            }
            catch (Exception exception) {}
        }
        return domains.get(0).getConfigurationSource();
    }
}

