/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.SQLTemplate;

class SQLTemplateMetadata
extends BaseQueryMetadata {
    SQLTemplateMetadata() {
    }

    boolean resolve(Object root, EntityResolver resolver, SQLTemplate query) {
        if (super.resolve(root, resolver, null)) {
            List list = this.resultSetMapping = query.getResult() != null ? query.getResult().getResolvedComponents(resolver) : null;
            if (QueryCacheStrategy.NO_CACHE != this.getCacheStrategy()) {
                Map<String, ?> parameters;
                StringBuilder key = new StringBuilder();
                ObjEntity entity = this.getObjEntity();
                if (entity != null) {
                    key.append(entity.getName());
                } else if (this.dbEntity != null) {
                    key.append("db:").append(this.dbEntity.getName());
                }
                if (query.getDefaultTemplate() != null) {
                    key.append('/').append(query.getDefaultTemplate());
                }
                if (!(parameters = query.getParameters()).isEmpty()) {
                    ArrayList<String> keys = new ArrayList<String>(parameters.keySet());
                    Collections.sort(keys);
                    for (String parameterKey : keys) {
                        key.append('/').append(parameterKey).append('=').append(parameters.get(parameterKey));
                    }
                }
                if (query.getFetchOffset() > 0 || query.getFetchLimit() > 0) {
                    key.append('/');
                    if (query.getFetchOffset() > 0) {
                        key.append('o').append(query.getFetchOffset());
                    }
                    if (query.getFetchLimit() > 0) {
                        key.append('l').append(query.getFetchLimit());
                    }
                }
                this.cacheKey = key.toString();
            }
            return true;
        }
        return false;
    }
}

