/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.CayenneMapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DbEntityClassDescriptor {
    private ClassDescriptor classDescriptor;
    private List<DbRelationship> pathFromMaster;
    private DbEntity dbEntity;

    DbEntityClassDescriptor(ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
        this.dbEntity = classDescriptor.getEntity().getDbEntity();
    }

    DbEntityClassDescriptor(ClassDescriptor classDescriptor, ObjAttribute masterAttribute) {
        this.classDescriptor = classDescriptor;
        Iterator<CayenneMapEntry> it = masterAttribute.getDbPathIterator();
        if (masterAttribute.isFlattened()) {
            while (it.hasNext()) {
                CayenneMapEntry object = it.next();
                if (object instanceof DbRelationship) {
                    if (this.pathFromMaster == null) {
                        this.pathFromMaster = new ArrayList<DbRelationship>(2);
                    }
                    this.pathFromMaster.add((DbRelationship)object);
                    continue;
                }
                if (!(object instanceof DbAttribute)) continue;
                this.dbEntity = (DbEntity)((DbAttribute)object).getEntity();
            }
        }
        if (this.dbEntity == null) {
            this.dbEntity = classDescriptor.getEntity().getDbEntity();
        }
    }

    boolean isMaster() {
        return this.pathFromMaster == null;
    }

    ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    List<DbRelationship> getPathFromMaster() {
        return this.pathFromMaster;
    }

    DbEntity getDbEntity() {
        return this.dbEntity;
    }

    ObjEntity getEntity() {
        return this.classDescriptor.getEntity();
    }
}

