/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.validation;

import java.util.Collection;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.reflect.PropertyUtils;
import org.apache.cayenne.validation.SimpleValidationFailure;
import org.apache.cayenne.validation.ValidationFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationFailure
extends SimpleValidationFailure {
    protected String property;

    private static String validationMessage(String attribute, String message) {
        StringBuilder buffer = new StringBuilder(message.length() + attribute.length() + 5);
        buffer.append('\"').append(attribute).append("\" ").append(message);
        return buffer.toString();
    }

    public static ValidationFailure validateNotEmpty(Object bean, String attribute, Collection<?> value) {
        if (value == null) {
            return new BeanValidationFailure(bean, attribute, BeanValidationFailure.validationMessage(attribute, " is required."));
        }
        if (value.isEmpty()) {
            return new BeanValidationFailure(bean, attribute, BeanValidationFailure.validationMessage(attribute, " can not be empty."));
        }
        return null;
    }

    public static ValidationFailure validateMandatory(Object bean, String attribute, Object value) {
        if (value instanceof String) {
            return BeanValidationFailure.validateNotEmpty(bean, attribute, (String)value);
        }
        if (value instanceof Collection) {
            return BeanValidationFailure.validateNotEmpty(bean, attribute, (Collection)value);
        }
        return BeanValidationFailure.validateNotNull(bean, attribute, value);
    }

    public static ValidationFailure validateMandatory(Object bean, String attribute) {
        if (bean == null) {
            throw new NullPointerException("Null bean.");
        }
        try {
            Object result = PropertyUtils.getProperty(bean, attribute);
            return BeanValidationFailure.validateMandatory(bean, attribute, result);
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error validationg bean property: " + bean.getClass().getName() + "." + attribute, (Throwable)ex, new Object[0]);
        }
    }

    public static ValidationFailure validateNotNull(Object bean, String attribute, Object value) {
        if (value == null) {
            return new BeanValidationFailure(bean, attribute, BeanValidationFailure.validationMessage(attribute, " is required."));
        }
        return null;
    }

    public static ValidationFailure validateNotEmpty(Object bean, String attribute, String value) {
        if (value == null || value.length() == 0) {
            return new BeanValidationFailure(bean, attribute, BeanValidationFailure.validationMessage(attribute, " is a required field."));
        }
        return null;
    }

    public static ValidationFailure validateJavaClassName(Object bean, String attribute, String identifier) {
        ValidationFailure emptyFailure = BeanValidationFailure.validateNotEmpty(bean, attribute, identifier);
        if (emptyFailure != null) {
            return emptyFailure;
        }
        char c = identifier.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return new BeanValidationFailure(bean, attribute, BeanValidationFailure.validationMessage(attribute, " starts with invalid character: " + c));
        }
        if (identifier.endsWith("[]")) {
            identifier = identifier.substring(0, identifier.length() - 2);
        }
        boolean wasDot = false;
        for (int i = 1; i < identifier.length(); ++i) {
            c = identifier.charAt(i);
            if (c == '.') {
                if (wasDot || i + 1 == identifier.length()) {
                    return new BeanValidationFailure(bean, attribute, BeanValidationFailure.validationMessage(attribute, " is not a valid Java Class Name: " + identifier));
                }
                wasDot = true;
                continue;
            }
            if (!Character.isJavaIdentifierPart(c)) {
                return new BeanValidationFailure(bean, attribute, BeanValidationFailure.validationMessage(attribute, " contains invalid character: " + c));
            }
            wasDot = false;
        }
        return null;
    }

    public BeanValidationFailure(Object source, String property, Object error) {
        super(source, error);
        if (source == null && property != null) {
            throw new IllegalArgumentException("ValidationFailure cannot have 'property' when 'source' is null.");
        }
        this.property = property;
    }

    public String getProperty() {
        return this.property;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Validation failure for ");
        Object source = this.getSource();
        if (source == null) {
            buffer.append("[General]");
        } else {
            String property = this.getProperty();
            buffer.append(source.getClass().getName()).append('.').append(property == null ? "[General]" : property);
        }
        buffer.append(": ");
        buffer.append(this.getDescription());
        return buffer.toString();
    }
}

