/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.log;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cayenne.log.CommonsJdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattedCommonsJdbcEventLogger
extends CommonsJdbcEventLogger {
    private static final Map<String, String> KEYWORDS = new HashMap<String, String>();

    private String formatQuery(String sql) {
        Map<Integer, String> scanResult = this.scanQuery(sql);
        Iterator<Integer> iter = scanResult.keySet().iterator();
        int nextKeyIdx = iter.hasNext() ? iter.next() : -1;
        StringBuffer buffer = new StringBuffer();
        int apixCount = 0;
        int bufferPos = 0;
        for (int pos = 0; pos < sql.length(); ++pos) {
            if (sql.charAt(pos) == '\'') {
                ++apixCount;
                if (pos > 0 && sql.charAt(pos - 1) == '\'') {
                    apixCount -= 2;
                }
            }
            if (apixCount % 2 != 0) continue;
            if (pos == nextKeyIdx) {
                buffer.append(sql.substring(bufferPos, pos + 1));
                buffer.append("\n");
                String shiftedKeyWrd = scanResult.get(nextKeyIdx);
                nextKeyIdx = iter.hasNext() ? iter.next() : -1;
                buffer.append(shiftedKeyWrd);
                bufferPos = (pos += shiftedKeyWrd.length()) + 1;
                continue;
            }
            if (sql.charAt(pos) != ',' && sql.charAt(pos) != ')' && sql.charAt(pos) != '(') continue;
            buffer.append(sql.substring(bufferPos, pos + 1));
            buffer.append("\n\t");
            bufferPos = pos + 1;
        }
        buffer.append(sql.substring(bufferPos));
        buffer.append("\n");
        String result = buffer.toString();
        while (result.contains("  ")) {
            result = result.replaceAll("  ", " ");
        }
        return result;
    }

    private Map<Integer, String> scanQuery(String sql) {
        TreeMap<Integer, String> result = new TreeMap<Integer, String>();
        String sql2Lower = sql.toLowerCase();
        for (String keyWrd : KEYWORDS.keySet()) {
            int idx;
            int prevIdx = 0;
            while ((idx = sql2Lower.indexOf(keyWrd, prevIdx)) >= 0) {
                result.put(idx, KEYWORDS.get(keyWrd));
                prevIdx = idx + 1;
            }
        }
        return result;
    }

    @Override
    public void logQuery(String queryStr, List<DbAttribute> attrs, List<?> params, long time) {
        if (this.isLoggable()) {
            super.logQuery(this.formatQuery(queryStr), attrs, params, time);
        }
    }

    static {
        KEYWORDS.put(" select ", "SELECT");
        KEYWORDS.put(" from ", "FROM");
        KEYWORDS.put(" where ", "WHERE");
        KEYWORDS.put(" order by ", "ORDER BY");
        KEYWORDS.put(" group by ", "GROUP BY");
        KEYWORDS.put(" update ", "UPDATE");
        KEYWORDS.put(" exec ", "EXEC");
        KEYWORDS.put(" set ", "SET");
        KEYWORDS.put(" insert ", "INSERT");
        KEYWORDS.put(" values ", "VALUES");
        KEYWORDS.put(" delete ", "DELETE");
        KEYWORDS.put(" declare ", "DECLARE");
        KEYWORDS.put(" case ", "CASE");
    }
}

