/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.Map;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.NameValidationHelper;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class ObjAttributeValidator
extends ConfigurationNodeValidator {
    ObjAttributeValidator() {
    }

    void validate(ObjAttribute attribute, ValidationResult validationResult) {
        if (Util.isEmptyString((String)attribute.getName())) {
            this.addFailure(validationResult, attribute, "Unnamed ObjAttribute", new Object[0]);
        } else {
            NameValidationHelper helper = NameValidationHelper.getInstance();
            String invalidChars = helper.invalidCharsInObjPathComponent(attribute.getName());
            if (invalidChars != null) {
                this.addFailure(validationResult, attribute, "ObjAttribute name '%s' contains invalid characters: %s", attribute.getName(), invalidChars);
            } else if (helper.invalidDataObjectProperty(attribute.getName())) {
                this.addFailure(validationResult, attribute, "ObjAttribute name '%s' is invalid", attribute.getName());
            }
        }
        if (Util.isEmptyString((String)attribute.getType())) {
            this.addFailure(validationResult, attribute, "ObjAttribute '%s' has no Java type", attribute.getName());
        }
        if (!(attribute.getEntity() instanceof ObjEntity) || !((ObjEntity)attribute.getEntity()).isAbstract()) {
            if (attribute instanceof EmbeddedAttribute) {
                Map attrOverrides = ((EmbeddedAttribute)attribute).getAttributeOverrides();
                Embeddable embeddable = ((EmbeddedAttribute)attribute).getEmbeddable();
                if (embeddable == null && ((EmbeddedAttribute)attribute).getType() != null) {
                    this.addFailure(validationResult, attribute, "EmbeddedAttribute '%s' has incorrect Embeddable", attribute.getName());
                } else if (embeddable == null && ((EmbeddedAttribute)attribute).getType() == null) {
                    this.addFailure(validationResult, attribute, "EmbeddedAttribute '%s' has no Embeddable", attribute.getName());
                }
                if (embeddable != null) {
                    for (EmbeddableAttribute embeddableAttribute : embeddable.getAttributes()) {
                        String dbAttributeName = attrOverrides.size() > 0 && attrOverrides.containsKey(embeddableAttribute.getName()) ? (String)attrOverrides.get(embeddableAttribute.getName()) : embeddableAttribute.getDbAttributeName();
                        if (dbAttributeName == "" || dbAttributeName == null) {
                            this.addFailure(validationResult, attribute, "EmbeddedAttribute '%s' has no DbAttribute mapping", attribute.getName());
                            continue;
                        }
                        if (((ObjEntity)attribute.getEntity()).getDbEntity().getAttribute(dbAttributeName) != null) continue;
                        this.addFailure(validationResult, attribute, "EmbeddedAttribute '%s' has incorrect DbAttribute mapping", attribute.getName());
                    }
                }
            } else if (attribute.getDbAttribute() == null) {
                this.addFailure(validationResult, attribute, "ObjAttribute '%s' has no DbAttribute mapping", attribute.getName());
            } else if (attribute.getDbAttribute().isPrimaryKey() && attribute.getDbAttribute().isGenerated()) {
                this.addFailure(validationResult, attribute, "ObjAttribute '%s' is mapped to a generated PK: %s", attribute.getName(), attribute.getDbAttributeName());
            }
        }
        this.checkForDuplicates(attribute, validationResult);
    }

    private void checkForDuplicates(ObjAttribute attribute, ValidationResult validationResult) {
        if (attribute != null && attribute.getName() != null && !attribute.isInherited()) {
            ObjEntity entity = (ObjEntity)attribute.getEntity();
            for (ObjAttribute comparisonAttribute : entity.getAttributes()) {
                String dbAttributePath;
                if (attribute == comparisonAttribute || (dbAttributePath = attribute.getDbAttributePath()) == null || !dbAttributePath.equals(comparisonAttribute.getDbAttributePath())) continue;
                this.addFailure(validationResult, attribute, "ObjEntity '%s' contains a duplicate DbAttribute mapping ('%s' -> '%s')", entity.getName(), attribute.getName(), dbAttributePath);
                return;
            }
        }
    }
}

