/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.ProcedureEvent;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureDisplayListener;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class ProcedureTab
extends JPanel
implements ProcedureDisplayListener,
ExistingSelectionProcessor {
    protected ProjectController eventController;
    protected TextAdapter name;
    protected TextAdapter schema;
    protected TextAdapter catalog;
    protected JCheckBox returnsValue;
    protected boolean ignoreChange;

    public ProcedureTab(ProjectController eventController) {
        this.eventController = eventController;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.name = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                ProcedureTab.this.setProcedureName(text);
            }
        };
        this.schema = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                ProcedureTab.this.setSchema(text);
            }
        };
        this.catalog = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                ProcedureTab.this.setCatalog(text);
            }
        };
        JLabel returnValueHelp = new JLabel("(first parameter will be used as return value)");
        returnValueHelp.setFont(returnValueHelp.getFont().deriveFont(10));
        this.returnsValue = new JCheckBox();
        this.returnsValue.setToolTipText(returnValueHelp.getText());
        FormLayout layout = new FormLayout("right:pref, 3dlu, fill:200dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Stored Procedure Configuration");
        builder.append("Procedure Name:", (Component)this.name.getComponent());
        builder.append("Catalog:", (Component)this.catalog.getComponent());
        builder.append("Schema:", (Component)this.schema.getComponent());
        builder.append("Returns Value:", (Component)this.returnsValue);
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
    }

    private void initController() {
        this.returnsValue.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Procedure procedure = ProcedureTab.this.eventController.getCurrentProcedure();
                if (procedure != null && !ProcedureTab.this.ignoreChange) {
                    procedure.setReturningValue(ProcedureTab.this.returnsValue.isSelected());
                    ProcedureTab.this.eventController.fireProcedureEvent(new ProcedureEvent((Object)ProcedureTab.this, procedure));
                }
            }
        });
        this.eventController.addProcedureDisplayListener(this);
    }

    @Override
    public void processExistingSelection(EventObject e) {
        ProcedureDisplayEvent pde = new ProcedureDisplayEvent((Object)this, this.eventController.getCurrentProcedure(), this.eventController.getCurrentDataMap(), (DataChannelDescriptor)this.eventController.getProject().getRootNode());
        this.eventController.fireProcedureDisplayEvent(pde);
    }

    @Override
    public void currentProcedureChanged(ProcedureDisplayEvent e) {
        Procedure procedure = e.getProcedure();
        if (procedure == null || !e.isProcedureChanged()) {
            return;
        }
        this.name.setText(procedure.getName());
        this.schema.setText(procedure.getSchema());
        this.catalog.setText(procedure.getCatalog());
        this.ignoreChange = true;
        this.returnsValue.setSelected(procedure.isReturningValue());
        this.ignoreChange = false;
    }

    void setProcedureName(String newName) {
        Procedure procedure;
        if (newName != null && newName.trim().length() == 0) {
            newName = null;
        }
        if ((procedure = this.eventController.getCurrentProcedure()) == null || Util.nullSafeEquals(newName, procedure.getName())) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("Procedure name is required.", new Object[0]);
        }
        if (procedure.getDataMap().getProcedure(newName) != null) {
            throw new ValidationException("There is another procedure with name '" + newName + "'.", new Object[0]);
        }
        ProcedureEvent e = new ProcedureEvent((Object)this, procedure, procedure.getName());
        ProjectUtil.setProcedureName(procedure.getDataMap(), procedure, newName);
        this.eventController.fireProcedureEvent(e);
    }

    void setSchema(String text) {
        Procedure procedure;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if ((procedure = this.eventController.getCurrentProcedure()) != null && !Util.nullSafeEquals(procedure.getSchema(), text)) {
            procedure.setSchema(text);
            this.eventController.fireProcedureEvent(new ProcedureEvent((Object)this, procedure));
        }
    }

    void setCatalog(String text) {
        Procedure procedure;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if ((procedure = this.eventController.getCurrentProcedure()) != null && !Util.nullSafeEquals(procedure.getCatalog(), text)) {
            procedure.setCatalog(text);
            this.eventController.fireProcedureEvent(new ProcedureEvent((Object)this, procedure));
        }
    }
}

