/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.project.ConfigurationSourceGetter;
import org.apache.cayenne.resource.Resource;

public class Project {
    protected boolean modified;
    protected ConfigurationTree<?> configurationTree;
    private ConfigurationNodeVisitor<Resource> configurationSourceGetter;
    private Collection<URL> unusedResources;

    public Project(ConfigurationTree<?> configurationTree) {
        this.configurationTree = configurationTree;
        this.configurationSourceGetter = new ConfigurationSourceGetter();
        this.unusedResources = new HashSet<URL>();
    }

    public ConfigurationTree<?> getConfigurationTree() {
        return this.configurationTree;
    }

    public ConfigurationNode getRootNode() {
        return this.configurationTree.getRootNode();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public Resource getConfigurationResource(ConfigurationNode configNode) {
        return configNode.acceptVisitor(this.configurationSourceGetter);
    }

    public Resource getConfigurationResource() {
        return this.configurationTree.getRootNode().acceptVisitor(this.configurationSourceGetter);
    }

    public Collection<URL> getUnusedResources() {
        return this.unusedResources;
    }
}

