/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.tx.BaseTransaction;

public class CayenneTransaction
extends BaseTransaction {
    protected JdbcEventLogger logger;

    public CayenneTransaction(JdbcEventLogger logger) {
        this.logger = logger;
    }

    @Override
    public void begin() {
        super.begin();
        this.logger.logBeginTransaction("transaction started.");
    }

    @Override
    protected void connectionAdded(Connection connection) {
        super.connectionAdded(connection);
        try {
            this.fixConnectionState(connection);
        }
        catch (SQLException e) {
            throw new CayenneRuntimeException("Exception changing connection state", (Throwable)e, new Object[0]);
        }
    }

    void fixConnectionState(Connection connection) throws SQLException {
        if (connection.getAutoCommit()) {
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void processCommit() {
        this.status = 2;
        if (this.connections == null || this.connections.isEmpty()) {
            return;
        }
        Throwable deferredException = null;
        for (Connection connection : this.connections.values()) {
            try {
                if (deferredException == null) {
                    connection.commit();
                    continue;
                }
                connection.rollback();
            }
            catch (Throwable th) {
                this.setRollbackOnly();
                deferredException = th;
            }
        }
        if (deferredException != null) {
            this.logger.logRollbackTransaction("transaction rolledback.");
            throw new CayenneRuntimeException(deferredException);
        }
        this.logger.logCommitTransaction("transaction committed.");
    }

    @Override
    protected void processRollback() {
        this.status = 5;
        if (this.connections == null || this.connections.isEmpty()) {
            return;
        }
        Throwable deferredException = null;
        for (Connection connection : this.connections.values()) {
            try {
                connection.rollback();
            }
            catch (Throwable th) {
                deferredException = th;
            }
        }
        if (deferredException != null) {
            throw new CayenneRuntimeException(deferredException);
        }
    }

    @Override
    public boolean isExternal() {
        return false;
    }
}

