/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.di.spi.DefaultAdhocObjectFactory;
import org.apache.cayenne.di.spi.DefaultClassLoaderManager;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.EqualsBuilder;
import org.apache.cayenne.util.HashCodeBuilder;
import org.apache.cayenne.util.RegexUtil;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Util {
    private static final Map<String, String> SPECIAL_CHAR_TO_JAVA_MAPPING = new HashMap<String, String>();
    @Deprecated
    private static DefaultAdhocObjectFactory objectFactory;

    public static File toFile(URL url) throws IllegalArgumentException {
        URI uri;
        String urlString = url.toExternalForm();
        try {
            uri = new URI(urlString.replace(" ", "%20"));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URL " + urlString + " can't be converted to URI", e);
        }
        return new File(uri);
    }

    public static String stringFromFile(File file) throws IOException {
        return Util.stringFromFile(file, System.getProperty("line.separator"));
    }

    public static String stringFromFile(File file, String joinWith) throws IOException {
        StringBuilder buf = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String line = null;
            while ((line = in.readLine()) != null) {
                buf.append(line).append(joinWith);
            }
        }
        return buf.toString();
    }

    public static String join(Iterable<?> objects, String separator) {
        if (objects == null) {
            return "";
        }
        if (separator == null) {
            separator = "";
        }
        StringBuilder builder = new StringBuilder();
        for (Object o : objects) {
            if (builder.length() > 0) {
                builder.append(separator);
            }
            String string = o != null ? o.toString() : "";
            builder.append(string);
        }
        return builder.toString();
    }

    public static String substBackslashes(String string) {
        return RegexUtil.substBackslashes(string);
    }

    public static Throwable unwindException(Throwable th) {
        if (th instanceof SAXException) {
            SAXException sax = (SAXException)th;
            if (sax.getException() != null) {
                return Util.unwindException(sax.getException());
            }
        } else if (th instanceof SQLException) {
            SQLException sql = (SQLException)th;
            if (sql.getNextException() != null) {
                return Util.unwindException(sql.getNextException());
            }
        } else if (th.getCause() != null) {
            return Util.unwindException(th.getCause());
        }
        return th;
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o1.getClass().isArray()) {
            EqualsBuilder builder = new EqualsBuilder();
            builder.append(o1, o2);
            return builder.isEquals();
        }
        return o1.equals(o2);
    }

    public static <T> int nullSafeCompare(boolean nullsFirst, Comparable<T> o1, T o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return nullsFirst ? -1 : 1;
        }
        if (o2 == null) {
            return nullsFirst ? 1 : -1;
        }
        return o1.compareTo(o2);
    }

    public static boolean isEmptyString(String string) {
        return string == null || string.length() == 0;
    }

    public static <T extends Serializable> T cloneViaSerialization(T object) throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(){

            @Override
            public byte[] toByteArray() {
                return this.buf;
            }
        };
        try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
            out.writeObject(object);
        }
        var3_3 = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));){
            Serializable serializable = (Serializable)in.readObject();
            return (T)serializable;
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    public static XMLReader createXmlReader() throws SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        spf.setFeature("http://xml.org/sax/features/namespaces", true);
        SAXParser saxParser = spf.newSAXParser();
        return saxParser.getXMLReader();
    }

    public static String getPackagePath(String className) {
        return RegexUtil.getPackagePath(className);
    }

    public static String stripPackageName(String className) {
        if (className == null || className.length() == 0) {
            return className;
        }
        int lastDot = className.lastIndexOf(46);
        if (-1 == lastDot || className.length() - 1 == lastDot) {
            return className;
        }
        return className.substring(lastDot + 1);
    }

    public static <K, V> Map<K, V> toMap(K[] keys, V[] values) {
        int valuesSize;
        int keysSize = keys != null ? keys.length : 0;
        int n = valuesSize = values != null ? values.length : 0;
        if (keysSize == 0 && valuesSize == 0) {
            return new HashMap();
        }
        if (keysSize != valuesSize) {
            throw new IllegalArgumentException("The number of keys doesn't match the number of values.");
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (int i = 0; i < keysSize; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static String extractFileExtension(String fileName) {
        int dotInd = fileName.lastIndexOf(46);
        return dotInd > 0 && dotInd < fileName.length() ? fileName.substring(dotInd + 1) : null;
    }

    public static String stripFileExtension(String fileName) {
        int dotInd = fileName.lastIndexOf(46);
        return dotInd > 0 ? fileName.substring(0, dotInd) : fileName;
    }

    public static String stripLineBreaks(String string, char replaceWith) {
        if (string == null) {
            return null;
        }
        int len = string.length();
        char[] buffer = new char[len];
        boolean matched = false;
        int j = 0;
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == '\n' || c == '\r') {
                matched = true;
                if (i + 1 < len && string.charAt(i + 1) == '\n') {
                    ++i;
                }
                buffer[j] = replaceWith;
            } else {
                buffer[j] = c;
            }
            ++i;
            ++j;
        }
        return matched ? new String(buffer, 0, j) : string;
    }

    public static String encodeXmlAttribute(String string) {
        if (string == null) {
            return null;
        }
        int len = string.length();
        if (len == 0) {
            return string;
        }
        StringBuilder encoded = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                encoded.append("&lt;");
                continue;
            }
            if (c == '\"') {
                encoded.append("&quot;");
                continue;
            }
            if (c == '>') {
                encoded.append("&gt;");
                continue;
            }
            if (c == '\'') {
                encoded.append("&apos;");
                continue;
            }
            if (c == '&') {
                encoded.append("&amp;");
                continue;
            }
            encoded.append(c);
        }
        return encoded.toString();
    }

    public static String prettyTrim(String str, int maxLength) {
        if (maxLength < 5) {
            throw new IllegalArgumentException("Algorithm for 'prettyTrim' works only with length >= 5. Supplied length is " + maxLength);
        }
        if (str == null || str.length() <= maxLength) {
            return str;
        }
        int len = maxLength - 3;
        int startLen = len / 2;
        int endLen = len - startLen;
        return str.substring(0, startLen) + "..." + str.substring(str.length() - endLen);
    }

    public static <T> Iterator<T> sortedIterator(Iterator<T> it, Comparator<T> comparator) {
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        Collections.sort(list, comparator);
        return list.iterator();
    }

    public static int hashCode(Collection<?> c) {
        HashCodeBuilder builder = new HashCodeBuilder();
        for (Object o : c) {
            builder.append(o);
        }
        return builder.toHashCode();
    }

    public static Pattern sqlPatternToPattern(String pattern, boolean ignoreCase) {
        String preprocessed = RegexUtil.sqlPatternToRegex(pattern);
        int flag = ignoreCase ? 66 : 0;
        return Pattern.compile(preprocessed, flag);
    }

    public static boolean isAccessible(Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(member.getDeclaringClass().getModifiers());
    }

    @Deprecated
    public static Class<?> getJavaClass(String className) throws ClassNotFoundException {
        return objectFactory.getJavaClass(className);
    }

    public static String underscoredToJava(String name, boolean capitalize) {
        StringTokenizer st = new StringTokenizer(name, "_");
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int len = (token = Util.specialCharsToJava(token)).length();
            if (len == 0) continue;
            boolean hasLowerCase = false;
            boolean hasUpperCase = false;
            for (int i = 0; !(i >= len || hasUpperCase && hasLowerCase); ++i) {
                if (Character.isUpperCase(token.charAt(i))) {
                    hasUpperCase = true;
                    continue;
                }
                if (!Character.isLowerCase(token.charAt(i))) continue;
                hasLowerCase = true;
            }
            if (hasUpperCase && !hasLowerCase) {
                token = token.toLowerCase();
            }
            if (first) {
                first = false;
                if (capitalize) {
                    buf.append(Character.toUpperCase(token.charAt(0)));
                } else {
                    buf.append(Character.toLowerCase(token.charAt(0)));
                }
            } else {
                buf.append(Character.toUpperCase(token.charAt(0)));
            }
            if (len <= 1) continue;
            buf.append(token.substring(1, len));
        }
        return buf.toString();
    }

    public static String specialCharsToJava(String string) {
        int len = string.length();
        if (len == 0) {
            return string;
        }
        StringBuilder buffer = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                buffer.append(c);
                continue;
            }
            String word = SPECIAL_CHAR_TO_JAVA_MAPPING.get(String.valueOf(c));
            buffer.append((Object)(word != null ? word : "_"));
        }
        return buffer.toString();
    }

    static void setReverse(final Persistent sourceObject, String propertyName, final Persistent targetObject) {
        ArcProperty property = (ArcProperty)Cayenne.getClassDescriptor(sourceObject).getProperty(propertyName);
        ArcProperty reverseArc = property.getComplimentaryReverseArc();
        if (reverseArc != null) {
            reverseArc.visit(new PropertyVisitor(){

                @Override
                public boolean visitToMany(ToManyProperty property) {
                    property.addTargetDirectly(targetObject, sourceObject);
                    return false;
                }

                @Override
                public boolean visitToOne(ToOneProperty property) {
                    property.setTarget(targetObject, sourceObject, false);
                    return false;
                }

                @Override
                public boolean visitAttribute(AttributeProperty property) {
                    return false;
                }
            });
            sourceObject.getObjectContext().getGraphManager().arcCreated(targetObject.getObjectId(), sourceObject.getObjectId(), reverseArc.getName());
            Util.markAsDirty(targetObject);
        }
    }

    static void unsetReverse(final Persistent sourceObject, String propertyName, final Persistent targetObject) {
        ArcProperty property = (ArcProperty)Cayenne.getClassDescriptor(sourceObject).getProperty(propertyName);
        ArcProperty reverseArc = property.getComplimentaryReverseArc();
        if (reverseArc != null) {
            reverseArc.visit(new PropertyVisitor(){

                @Override
                public boolean visitToMany(ToManyProperty property) {
                    property.removeTargetDirectly(targetObject, sourceObject);
                    return false;
                }

                @Override
                public boolean visitToOne(ToOneProperty property) {
                    property.setTarget(targetObject, null, false);
                    return false;
                }

                @Override
                public boolean visitAttribute(AttributeProperty property) {
                    return false;
                }
            });
            sourceObject.getObjectContext().getGraphManager().arcDeleted(targetObject.getObjectId(), sourceObject.getObjectId(), reverseArc.getName());
            Util.markAsDirty(targetObject);
        }
    }

    static boolean markAsDirty(Persistent object) {
        if (object.getPersistenceState() == 3) {
            object.setPersistenceState(4);
            return true;
        }
        return false;
    }

    static {
        SPECIAL_CHAR_TO_JAVA_MAPPING.put("#", "pound");
        objectFactory = new DefaultAdhocObjectFactory(null, new DefaultClassLoaderManager());
    }
}

