/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.wocompat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.Relationship;
import org.apache.commons.collections.Transformer;

public class EOObjEntity
extends ObjEntity {
    protected boolean subclass;
    protected boolean abstractEntity;
    private Collection filteredQueries;
    private Map eoMap;

    public EOObjEntity() {
    }

    public EOObjEntity(String name) {
        super(name);
    }

    @Override
    public Expression translateToDbPath(Expression expression) {
        if (expression == null) {
            return null;
        }
        if (this.getDbEntity() == null) {
            throw new CayenneRuntimeException("Can't translate expression to DB_PATH, no DbEntity for '" + this.getName() + "'.", new Object[0]);
        }
        return expression.transform(new DBPathConverter());
    }

    Map getEoMap() {
        return this.eoMap;
    }

    void setEoMap(Map eoMap) {
        this.eoMap = eoMap;
    }

    public Collection getEOQueries() {
        if (this.filteredQueries == null) {
            Collection<QueryDescriptor> queries = this.getDataMap().getQueryDescriptors();
            if (queries.isEmpty()) {
                this.filteredQueries = Collections.EMPTY_LIST;
            } else {
                Map<String, EOObjEntity> params = Collections.singletonMap("root", this);
                Expression filter = ExpressionFactory.exp("root = $root", new Object[0]).params(params);
                this.filteredQueries = filter.filter(queries, new ArrayList());
            }
        }
        return this.filteredQueries;
    }

    public boolean isAbstractEntity() {
        return this.abstractEntity;
    }

    public void setAbstractEntity(boolean abstractEntity) {
        this.abstractEntity = abstractEntity;
    }

    public boolean isSubclass() {
        return this.subclass;
    }

    public void setSubclass(boolean subclass) {
        this.subclass = subclass;
    }

    public String qualifiedQueryName(String queryName) {
        return this.getName() + "_" + queryName;
    }

    public String localQueryName(String qualifiedQueryName) {
        return qualifiedQueryName != null && qualifiedQueryName.startsWith(this.getName() + "_") ? qualifiedQueryName.substring(this.getName().length() + 1) : qualifiedQueryName;
    }

    final class DBPathConverter
    implements Transformer {
        DBPathConverter() {
        }

        @Override
        public Object transform(Object input) {
            if (!(input instanceof Expression)) {
                return input;
            }
            Expression expression = (Expression)input;
            if (expression.getType() != 26) {
                return input;
            }
            StringBuilder buffer = new StringBuilder();
            EOObjEntity entity = EOObjEntity.this;
            StringTokenizer toks = new StringTokenizer(expression.toString(), ".");
            block0: while (toks.hasMoreTokens() && entity != null) {
                String chunk = toks.nextToken();
                if (toks.hasMoreTokens()) {
                    if (buffer.length() > 0) {
                        buffer.append(".");
                    }
                    buffer.append(chunk);
                    ObjRelationship r = entity.getRelationship(chunk);
                    if (r == null) {
                        throw new ExpressionException("Invalid path component: " + chunk, new Object[0]);
                    }
                    entity = (EOObjEntity)((Relationship)r).getTargetEntity();
                    continue;
                }
                List attributes = (List)entity.getEoMap().get("attributes");
                for (Map attribute : attributes) {
                    if (!chunk.equals(attribute.get("name"))) continue;
                    if (buffer.length() > 0) {
                        buffer.append(".");
                    }
                    buffer.append(attribute.get("columnName"));
                    continue block0;
                }
            }
            Expression exp = ExpressionFactory.expressionOfType(27);
            exp.setOperand(0, buffer.toString());
            return exp;
        }
    }
}

